/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessages;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.loader.CmsTemplateLoaderFacade;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.types.A_CmsXmlContentValue;

public class CmsDisplayTypeSelectWidget
extends CmsSelectWidget {
    public static final String ATTR_USE_CONFIG_FORMATTERS = "list.use.configured.formatters";
    public static final String MATCH_TYPES_KEY = "matchTypes";
    private static final Log LOG = CmsLog.getLog(CmsDisplayTypeSelectWidget.class);
    private static final String TYPES_SPLITTER = " *, *";
    private String m_displayContainerTypeConfig;
    private boolean m_matchTypes;
    private String m_config;

    @Override
    public String getConfiguration() {
        return this.m_config;
    }

    @Override
    public String getConfiguration(CmsObject cms, A_CmsXmlContentValue schemaType, CmsMessages messages, CmsResource resource, Locale contentLocale) {
        List<FormatterOption> options = this.getFormatterOptions(cms, resource);
        JSONObject config = new JSONObject();
        try {
            String path = CmsStringUtil.isNotEmptyOrWhitespaceOnly(schemaType.getPath()) ? CmsStringUtil.joinPaths(schemaType.getPath(), schemaType.getName()) : schemaType.getName();
            config.put("valuePath", path);
            config.put(MATCH_TYPES_KEY, this.m_matchTypes);
            config.put("emptyLabel", messages.key("GUI_DISPLAYTYPE_SELECT_0"));
            JSONArray optionArray = new JSONArray();
            for (FormatterOption option : options) {
                JSONObject opt = new JSONObject();
                try {
                    opt.put("value", option.m_key);
                    opt.put("label", option.m_label);
                    opt.put("displayType", option.m_displayType);
                    optionArray.put(opt);
                }
                catch (JSONException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            config.put("options", optionArray);
        }
        catch (JSONException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return config.toString();
    }

    @Override
    public String getWidgetName() {
        return CmsDisplayTypeSelectWidget.class.getName();
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsDisplayTypeSelectWidget();
    }

    @Override
    public void setConfiguration(String configuration) {
        this.m_config = configuration;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(configuration)) {
            String[] conf = configuration.split("\\|");
            for (int i = 0; i < conf.length; ++i) {
                if (MATCH_TYPES_KEY.equals(conf[i])) {
                    this.m_matchTypes = true;
                    continue;
                }
                this.m_displayContainerTypeConfig = conf[i];
            }
        }
    }

    @Override
    protected List<CmsSelectWidgetOption> parseSelectOptions(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        CmsResource resource = null;
        ArrayList<CmsSelectWidgetOption> result = new ArrayList<CmsSelectWidgetOption>();
        try {
            Object sitePath;
            if (widgetDialog instanceof A_CmsWidget.CmsDummyWidgetDialog) {
                resource = ((A_CmsWidget.CmsDummyWidgetDialog)widgetDialog).getResource();
            } else if (widgetDialog instanceof CmsDialog && (sitePath = ((CmsDialog)((Object)widgetDialog)).getParamResource()) != null) {
                resource = cms.readResource((String)sitePath);
            }
            for (FormatterOption option : this.getFormatterOptions(cms, resource)) {
                result.add(new CmsSelectWidgetOption(option.m_key, false, option.m_label));
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    private String getDisplayType(I_CmsFormatterBean formatter) {
        return formatter.getDisplayType();
    }

    private List<FormatterOption> getFormatterOptions(CmsObject cms, CmsResource resource) {
        CmsADEConfigData config;
        ArrayList<FormatterOption> options = new ArrayList<FormatterOption>();
        HashSet<String> containerTypes = new HashSet<String>();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_displayContainerTypeConfig)) {
            String types;
            block17: {
                types = null;
                if ("template.display.types".equals(this.m_displayContainerTypeConfig)) {
                    try {
                        CmsProperty prop = cms.readPropertyObject(resource, "template.display.types", true);
                        String propValue = prop.getValue();
                        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(propValue)) {
                            types = propValue;
                            break block17;
                        }
                        try {
                            CmsTemplateLoaderFacade loaderFacade = OpenCms.getResourceManager().getTemplateLoaderFacade(cms, null, resource, "template");
                            CmsResource template = loaderFacade.getLoaderStartResource();
                            if (template != null && !CmsStringUtil.isEmptyOrWhitespaceOnly(propValue = (prop = cms.readPropertyObject(template, "template.display.types", false)).getValue())) {
                                types = propValue;
                            }
                        }
                        catch (Exception ex) {
                            LOG.debug((Object)ex.getMessage(), (Throwable)ex);
                        }
                    }
                    catch (CmsException e) {
                        LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                } else {
                    types = this.m_displayContainerTypeConfig;
                }
            }
            if (types != null) {
                containerTypes.addAll(Arrays.asList(types.split(TYPES_SPLITTER)));
            }
        }
        if ((config = OpenCms.getADEManager().lookupConfiguration(cms, resource.getRootPath())) != null) {
            List<CmsResourceTypeConfig> typeConfigs = config.getResourceTypes();
            HashMap<String, Integer> typePositions = new HashMap<String, Integer>();
            int index = 0;
            for (CmsResourceTypeConfig type : typeConfigs) {
                typePositions.put(type.getTypeName(), index);
                ++index;
            }
            boolean useConfiguredFormatters = Boolean.parseBoolean(config.getAttribute(ATTR_USE_CONFIG_FORMATTERS, "false"));
            Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
            for (I_CmsFormatterBean formatter : config.getDisplayFormatters(cms)) {
                if (useConfiguredFormatters) {
                    boolean inactive;
                    boolean bl = inactive = formatter.getId() == null || !config.getActiveFormatters().containsKey(new CmsUUID(formatter.getId()));
                    if (inactive) {
                        continue;
                    }
                } else if (!containerTypes.isEmpty() && Sets.intersection(containerTypes, formatter.getContainerTypes()).isEmpty()) continue;
                for (String typeName : formatter.getResourceTypeNames()) {
                    String label = formatter.getNiceName(wpLocale) + " (" + CmsWorkplaceMessages.getResourceTypeName(wpLocale, typeName) + ")";
                    options.add(new FormatterOption(typeName + ":" + formatter.getKeyOrId(), typeName, this.getDisplayType(formatter), label, formatter.getRank(), (Integer)typePositions.get(typeName)));
                }
            }
        }
        Collections.sort(options, (f1, f2) -> ComparisonChain.start().compare((Object)f1.getTypePosition(), (Object)f2.getTypePosition(), Comparator.nullsLast(Comparator.naturalOrder())).compare((Comparable)((Object)f1.m_typeName), (Comparable)((Object)f2.m_typeName)).compare(f2.m_rank, f1.m_rank).compare((Comparable)((Object)f1.m_label), (Comparable)((Object)f2.m_label)).result());
        return options;
    }

    class FormatterOption {
        String m_displayType;
        String m_key;
        String m_label;
        int m_rank;
        Integer m_typePosition;
        String m_typeName;

        FormatterOption(String key, String typeName, String displayType, String label, int rank, Integer typePos) {
            this.m_key = key;
            this.m_typeName = typeName;
            this.m_displayType = displayType;
            this.m_label = label;
            this.m_rank = rank;
            this.m_typePosition = typePos;
        }

        public Integer getTypePosition() {
            return this.m_typePosition;
        }
    }
}

