/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.webdav;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.EnumerationUtils;
import org.apache.commons.logging.Log;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavSessionProvider;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.header.IfHeader;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.SimpleLockManager;
import org.apache.jackrabbit.webdav.server.AbstractWebdavServlet;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.repository.A_CmsRepository;
import org.opencms.webdav.CmsDavInputContext;
import org.opencms.webdav.CmsDavLocatorFactory;
import org.opencms.webdav.CmsDavResourceFactory;
import org.opencms.webdav.CmsDavSessionProvider;

public class CmsJackrabbitWebdavServlet
extends AbstractWebdavServlet {
    private static final Log LOG = CmsLog.getLog(CmsJackrabbitWebdavServlet.class);
    private static final long serialVersionUID = 1L;
    private CmsDavLocatorFactory m_locatorFactory = new CmsDavLocatorFactory();
    private CmsDavSessionProvider m_sessionProvider = new CmsDavSessionProvider();
    private CmsDavResourceFactory m_resourceFactory = new CmsDavResourceFactory();
    private LockManager m_lockManager = new SimpleLockManager();
    private A_CmsRepository m_repository;

    public DavSessionProvider getDavSessionProvider() {
        return this.m_sessionProvider;
    }

    public DavLocatorFactory getLocatorFactory() {
        return this.m_locatorFactory;
    }

    public DavResourceFactory getResourceFactory() {
        return this.m_resourceFactory;
    }

    public void init(final ServletConfig config) throws ServletException {
        A_CmsRepository repository;
        final LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (String name : Collections.list(config.getInitParameterNames())) {
            params.put(name, config.getInitParameter(name));
        }
        params.put("createAbsoluteURI", "false");
        super.init(new ServletConfig(){

            public String getInitParameter(String name) {
                return (String)params.get(name);
            }

            public Enumeration<String> getInitParameterNames() {
                return Collections.enumeration(params.keySet());
            }

            public ServletContext getServletContext() {
                return config.getServletContext();
            }

            public String getServletName() {
                return config.getServletName();
            }
        });
        String repName = config.getInitParameter("repository");
        this.m_repository = repository = OpenCms.getRepositoryManager().getRepository(repName, A_CmsRepository.class);
        this.m_sessionProvider.setRepository(repository);
        this.m_resourceFactory.setLockManager(this.m_lockManager);
    }

    public void setDavSessionProvider(DavSessionProvider davSessionProvider) {
        throw new UnsupportedOperationException();
    }

    public void setLocatorFactory(DavLocatorFactory locatorFactory) {
        throw new UnsupportedOperationException();
    }

    public void setResourceFactory(DavResourceFactory resourceFactory) {
        throw new UnsupportedOperationException();
    }

    protected InputContext getInputContext(DavServletRequest request, InputStream in) {
        return new CmsDavInputContext(request, in);
    }

    protected boolean isPreconditionValid(WebdavRequest request, DavResource resource) {
        String[] tokens;
        IfHeader header = new IfHeader((HttpServletRequest)request);
        for (String token : tokens = (String[])Iterators.toArray((Iterator)header.getAllTokens(), String.class)) {
            if (!"DAV:no-lock".equals(token)) continue;
            return false;
        }
        return !resource.exists() || request.matchesIfHeader(resource);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String range;
        LOG.debug((Object)("WEBDAV: " + request.getMethod() + " " + request.getRequestURI()));
        if (Boolean.parseBoolean(this.m_repository.getConfiguration().getString("failOnRangeHeader", "false")) && (range = request.getHeader("range")) != null) {
            response.setStatus(400);
            return;
        }
        try {
            super.service(request, response);
        }
        catch (IOException | ServletException e) {
            LOG.error((Object)e.getLocalizedMessage(), e);
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void printHeaderInfo(HttpServletRequest request) {
        System.out.println("--------------- " + request.getMethod() + " " + request.getRequestURI());
        Enumeration hnames = request.getHeaderNames();
        while (hnames.hasMoreElements()) {
            String name = (String)hnames.nextElement();
            System.out.println(name + ": " + String.valueOf(EnumerationUtils.toList((Enumeration)request.getHeaders(name))));
        }
    }
}

