/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.webdav;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.DavSessionProvider;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.repository.A_CmsRepository;
import org.opencms.repository.I_CmsRepositorySession;
import org.opencms.webdav.CmsDavSession;

public class CmsDavSessionProvider
implements DavSessionProvider {
    private static final Log LOG = CmsLog.getLog(CmsDavSessionProvider.class);
    private A_CmsRepository m_repository;

    public boolean attachSession(WebdavRequest request) throws DavException {
        if (this.m_repository == null) {
            throw new IllegalStateException("Uninitialized repository");
        }
        String authHeader = request.getHeader("Authorization");
        I_CmsRepositorySession repoSession = null;
        String basic = "BASIC";
        if (authHeader != null && authHeader.toUpperCase().startsWith(basic)) {
            String base64Token = authHeader.substring(basic.length() + 1);
            String token = new String(Base64.decodeBase64((byte[])base64Token.getBytes()));
            String password = null;
            String username = null;
            int pos = token.indexOf(":");
            if (pos != -1) {
                username = token.substring(0, pos);
                password = token.substring(pos + 1);
            }
            try {
                repoSession = this.m_repository.login(username, password);
            }
            catch (CmsException e) {
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (repoSession == null) {
            throw new DavException(401);
        }
        request.setDavSession((DavSession)new CmsDavSession(repoSession));
        return true;
    }

    public void releaseSession(WebdavRequest request) {
    }

    public void setRepository(A_CmsRepository repository) {
        this.m_repository = repository;
    }
}

