/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util.benchmark;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.util.benchmark.CmsBenchmarkTable;

public class CmsFileBenchmarkReceiver
implements CmsBenchmarkTable.Receiver {
    private static final Log LOG = CmsLog.getLog(CmsFileBenchmarkReceiver.class);
    private String m_path;
    private String m_group;
    private String m_benchmark;

    public CmsFileBenchmarkReceiver() {
        Properties prop = System.getProperties();
        String prefix = "opencms.benchmark.";
        this.m_path = prop.getProperty(prefix + "file");
        this.m_benchmark = prop.getProperty(prefix + "name");
        this.m_group = prop.getProperty(prefix + "group");
    }

    public CmsFileBenchmarkReceiver(String path, String benchmark, String group) {
        this.m_path = path;
        this.m_group = group;
        this.m_benchmark = benchmark;
    }

    @Override
    public synchronized void receiveSample(String sampleName, long sampleTime) {
        try (FileWriter fw = new FileWriter(this.m_path, true);){
            String line = System.currentTimeMillis() + " " + this.m_benchmark + " " + this.m_group + " " + sampleName + " " + sampleTime + "\n";
            fw.write(line);
        }
        catch (IOException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            e.printStackTrace();
        }
    }
}

