/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util.benchmark;

import java.util.concurrent.ConcurrentHashMap;

public class CmsBenchmarkTable {
    private Receiver m_receiver;
    private ConcurrentHashMap<String, Long> m_startTimes = new ConcurrentHashMap();

    public CmsBenchmarkTable(Receiver receiver) {
        this.m_receiver = receiver;
    }

    public void start(String name) {
        if (this.m_startTimes.containsKey(name)) {
            throw new IllegalStateException("Can't start timer for given key twice: " + name);
        }
        this.m_startTimes.put(name, System.currentTimeMillis());
    }

    public void stop(String name) {
        if (!this.m_startTimes.containsKey(name)) {
            throw new IllegalStateException("Can't stop a timer that wasn't started: " + name);
        }
        long duration = System.currentTimeMillis() - this.m_startTimes.get(name);
        this.m_receiver.receiveSample(name, duration);
        this.m_startTimes.remove(name);
    }

    static interface Receiver {
        public void receiveSample(String var1, long var2);
    }
}

