/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceAlreadyExistsException;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;

public final class CmsVfsUtil {
    private static final Log LOG = CmsLog.getLog(CmsVfsUtil.class);

    private CmsVfsUtil() {
    }

    public static void createFolder(CmsObject cms, String rootPath) throws CmsException {
        CmsObject rootCms = OpenCms.initCmsObject(cms);
        rootCms.getRequestContext().setSiteRoot("");
        List<String> parents = new ArrayList();
        String currentPath = rootPath;
        while (currentPath != null && !rootCms.existsResource(currentPath)) {
            parents.add(currentPath);
            currentPath = CmsResource.getParentFolder(currentPath);
        }
        parents = Lists.reverse(parents);
        for (String parent : parents) {
            try {
                rootCms.createResource(parent, OpenCms.getResourceManager().getResourceType(CmsResourceTypeFolder.getStaticTypeName()));
                try {
                    rootCms.unlockResource(parent);
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (CmsVfsResourceAlreadyExistsException cmsVfsResourceAlreadyExistsException) {}
        }
    }

    public static boolean isDefaultFile(CmsObject cms, CmsResource resource) {
        if (null == resource || resource.isFolder()) {
            return false;
        }
        try {
            CmsResource defaultFile = cms.readDefaultFile(CmsResource.getFolderPath(cms.getSitePath(resource)), CmsResourceFilter.ALL);
            return null != defaultFile && defaultFile.getRootPath().equals(resource.getRootPath());
        }
        catch (Throwable t) {
            String message = "Failed to check if \"" + resource.getRootPath() + "\" is a default file. Assuming it is not.";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message, t);
            } else {
                LOG.error((Object)message);
            }
            return false;
        }
    }

    public static String readPropertyValueWithFolderFallbackForDefaultFiles(CmsObject cms, CmsResource resource, String propertyName, Locale locale) {
        try {
            List<CmsProperty> resourcePropsList = cms.readPropertyObjects(resource, false);
            Map<String, CmsProperty> resourceProps = CmsProperty.getPropertyMap(resourcePropsList);
            String value = CmsProperty.getLocaleSpecificPropertyValue(resourceProps, propertyName, locale);
            if (value == null && CmsVfsUtil.isDefaultFile(cms, resource)) {
                try {
                    List<CmsProperty> folderPropsList = cms.readPropertyObjects(CmsResource.getFolderPath(cms.getSitePath(resource)), false);
                    Map<String, CmsProperty> folderProps = CmsProperty.getPropertyMap(folderPropsList);
                    value = CmsProperty.getLocaleSpecificPropertyValue(folderProps, propertyName, locale);
                }
                catch (Throwable e) {
                    String message = "Failed to read folder property \"" + propertyName + "\" for resource \"" + resource.getRootPath() + "\".";
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)message, e);
                    }
                    LOG.error((Object)message);
                }
            }
            return value;
        }
        catch (Throwable e) {
            String message = "Failed to read property \"" + propertyName + "\" for resource \"" + (null == resource ? "null" : resource.getRootPath()) + "\".";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message, e);
            } else {
                LOG.error((Object)message);
            }
            return null;
        }
    }
}

