/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import com.google.common.collect.ComparisonChain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.I_CmsCloseable;

public class CmsTaskWatcher {
    private static final Log TASKWATCHER = CmsLog.getLog("taskwatcher");
    private static CmsTaskWatcher m_instance = new CmsTaskWatcher();
    private ConcurrentHashMap<String, Entry> m_map = new ConcurrentHashMap();

    public static CmsTaskWatcher get() {
        return m_instance;
    }

    public static void initialize() {
        OpenCms.getExecutor().scheduleWithFixedDelay(() -> {
            try {
                String report = CmsTaskWatcher.get().getReport(5000L);
                if (report.length() > 0) {
                    TASKWATCHER.error((Object)"Report:\n");
                    TASKWATCHER.error((Object)report);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    public Map<String, Entry> getMap() {
        return Collections.unmodifiableMap(this.m_map);
    }

    public String getReport(long minAge) {
        ArrayList<Entry> entries = new ArrayList<Entry>(this.m_map.values());
        StringBuilder builder = new StringBuilder();
        Collections.sort(entries, (a, b) -> ComparisonChain.start().compare(a.getStartTime(), b.getStartTime()).compare((Comparable)((Object)a.getThreadName()), (Comparable)((Object)b.getThreadName())).compare((Comparable)((Object)a.getLabel()), (Comparable)((Object)b.getLabel())).result());
        for (Entry entry : entries) {
            if (entry.getAge() <= minAge) continue;
            builder.append(entry.toString());
            builder.append("\n");
        }
        return builder.toString();
    }

    public I_CmsCloseable openTask(String label) {
        Entry entry = new Entry(Thread.currentThread().getName(), label, System.currentTimeMillis());
        String id = entry.getId();
        this.m_map.put(id, entry);
        return () -> this.m_map.remove(id);
    }

    static class Entry {
        private String m_label;
        private long m_startTime;
        private String m_id = RandomStringUtils.randomAlphanumeric((int)10);
        private String m_threadName;

        public Entry(String threadName, String label, long startTime) {
            this.m_threadName = threadName;
            this.m_label = label;
            this.m_startTime = startTime;
        }

        public long getAge() {
            return System.currentTimeMillis() - this.m_startTime;
        }

        public String getId() {
            return this.m_id;
        }

        public String getLabel() {
            return this.m_label;
        }

        public long getStartTime() {
            return this.m_startTime;
        }

        public String getThreadName() {
            return this.m_threadName;
        }

        public String toString() {
            return System.currentTimeMillis() - this.m_startTime + " " + this.m_threadName + " / " + this.m_label;
        }
    }
}

