/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class CmsPriorityLock {
    private Thread m_holder = null;
    private int m_holdCount = 0;
    private ReentrantLock m_lock = new ReentrantLock(true);
    private Condition m_highCond = this.m_lock.newCondition();
    private Condition m_lowCond = this.m_lock.newCondition();
    private int m_waitHigh;
    private int m_waitLow;

    public void lock(boolean highPriority) {
        this.m_lock.lock();
        try {
            Thread current = Thread.currentThread();
            if (current == this.m_holder) {
                ++this.m_holdCount;
                return;
            }
            if (highPriority) {
                ++this.m_waitHigh;
                while (this.m_holder != null) {
                    this.m_highCond.awaitUninterruptibly();
                }
                --this.m_waitHigh;
                this.m_holder = current;
                this.m_holdCount = 1;
            } else {
                ++this.m_waitLow;
                while (this.m_holder != null || this.m_waitHigh > 0) {
                    this.m_lowCond.awaitUninterruptibly();
                }
                --this.m_waitLow;
                this.m_holder = current;
                this.m_holdCount = 1;
            }
        }
        finally {
            this.m_lock.unlock();
        }
    }

    public void unlock() {
        this.m_lock.lock();
        try {
            Thread current = Thread.currentThread();
            if (current != this.m_holder) {
                throw new IllegalMonitorStateException();
            }
            --this.m_holdCount;
            if (this.m_holdCount == 0) {
                this.m_holder = null;
                if (this.m_waitHigh > 0) {
                    this.m_highCond.signal();
                } else if (this.m_waitLow > 0) {
                    this.m_lowCond.signal();
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
    }
}

