/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.io.Serializable;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsPath
implements Serializable,
Comparable<CmsPath> {
    private static final long serialVersionUID = 1L;
    private String m_pathStr;

    public CmsPath(String pathStr) {
        this.m_pathStr = CmsPath.normalize(pathStr);
    }

    public static boolean equal(String path1, String path2) {
        if (path1 == null && path2 == null) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        return CmsPath.normalize(path1).equals(CmsPath.normalize(path2));
    }

    private static String normalize(String pathStr) {
        Object result = null;
        if (pathStr.equals("") || pathStr.equals("/")) {
            result = "/";
        } else {
            result = CmsFileUtil.removeTrailingSeparator(pathStr);
            if (!((String)result).startsWith("/")) {
                result = "/" + (String)result;
            }
        }
        return result;
    }

    public String asString() {
        return this.m_pathStr;
    }

    @Override
    public int compareTo(CmsPath o) {
        return this.m_pathStr.compareTo(o.m_pathStr);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CmsPath)) {
            return false;
        }
        return ((CmsPath)obj).m_pathStr.equals(this.m_pathStr);
    }

    public int hashCode() {
        return this.m_pathStr.hashCode();
    }

    public boolean isPrefixOf(CmsPath path) {
        return this.isPrefixOfStr(path.asString());
    }

    public boolean isPrefixOfStr(String path) {
        return CmsStringUtil.isPrefixPath(this.m_pathStr, path);
    }

    public String toString() {
        return "CmsPath[" + this.asString() + "]";
    }
}

