/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CmsPair<A, B>
implements Serializable {
    private static final long serialVersionUID = 1185676847810113664L;
    private A m_first;
    private B m_second;

    public CmsPair() {
    }

    public CmsPair(A a, B b) {
        this.m_first = a;
        this.m_second = b;
    }

    public static <A, B> CmsPair<A, B> create(A a, B b) {
        return new CmsPair<A, B>(a, b);
    }

    public static <A extends Comparable<A>, B extends Comparable<B>> Comparator<CmsPair<A, B>> getLexicalComparator() {
        return new Comparator<CmsPair<A, B>>(){

            @Override
            public int compare(CmsPair<A, B> pair1, CmsPair<A, B> pair2) {
                int c = ((Comparable)pair1.getFirst()).compareTo((Comparable)pair2.getFirst());
                if (c != 0) {
                    return c;
                }
                return ((Comparable)pair1.getSecond()).compareTo((Comparable)pair2.getSecond());
            }
        };
    }

    public static Map<String, String> pairsToMap(List<CmsPair<String, String>> pairs) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (CmsPair<String, String> pair : pairs) {
            result.put(pair.getFirst(), pair.getSecond());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CmsPair)) {
            return false;
        }
        CmsPair otherPair = (CmsPair)o;
        return this.getFirst().equals(otherPair.getFirst()) && this.getSecond().equals(otherPair.getSecond());
    }

    public A getFirst() {
        return this.m_first;
    }

    public B getSecond() {
        return this.m_second;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getFirst(), this.getSecond()});
    }
}

