/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import com.google.common.base.Function;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.jsp.PageContext;
import org.apache.commons.collections.Factory;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.configuration.CmsParameterStore;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeBinary;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.i18n.CmsMessages;
import org.opencms.i18n.CmsMultiMessages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.ui.editors.messagebundle.CmsMessageBundleEditorTypes;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.util.I_CmsMacroResolver;
import org.opencms.util.Messages;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentValueSequence;

public class CmsMacroResolver
implements I_CmsMacroResolver {
    public static final String KEY_ATTRIBUTE = "attribute.";
    public static final String KEY_CONTEXT_PATH = "contextPath";
    public static final String KEY_CURRENT_ORGUNIT_DESCRIPTION = "currentou.description";
    public static final String KEY_CURRENT_ORGUNIT_FQN = "currentou.fqn";
    public static final String KEY_CURRENT_TIME = "currenttime";
    public static final String KEY_CURRENT_USER_CITY = "currentuser.city";
    public static final String KEY_CURRENT_USER_COUNTRY = "currentuser.country";
    public static final String KEY_CURRENT_USER_DISPLAYNAME = "currentuser.displayname";
    public static final String KEY_CURRENT_USER_EMAIL = "currentuser.email";
    public static final String KEY_CURRENT_USER_FIRSTNAME = "currentuser.firstname";
    public static final String KEY_CURRENT_USER_FULLNAME = "currentuser.fullname";
    public static final String KEY_CURRENT_USER_INSTITUTION = "currentuser.institution";
    public static final String KEY_CURRENT_USER_LASTLOGIN = "currentuser.lastlogin";
    public static final String KEY_CURRENT_USER_LASTNAME = "currentuser.lastname";
    public static final String KEY_CURRENT_USER_NAME = "currentuser.name";
    public static final String KEY_CURRENT_USER_STREET = "currentuser.street";
    public static final String KEY_CURRENT_USER_ZIP = "currentuser.zip";
    public static final String KEY_LOCALIZED_PREFIX = "key.";
    public static final String KEY_OPENCMS = "opencms.";
    public static final String KEY_PAGE_CONTEXT = "pageContext.";
    public static final String KEY_PARAM = "param:";
    public static final String KEY_PROJECT_ID = "projectid";
    public static final String KEY_PROPERTY = "property.";
    public static final String KEY_PROPERTY_ELEMENT = "elementProperty.";
    public static final String KEY_RANDOM_ID = "randomId";
    public static final String KEY_REQUEST_ENCODING = "request.encoding";
    public static final String KEY_REQUEST_FOLDER = "request.folder";
    public static final String KEY_REQUEST_LOCALE = "request.locale";
    public static final String KEY_REQUEST_PARAM = "param.";
    public static final String KEY_REQUEST_SITEROOT = "request.siteroot";
    public static final String KEY_REQUEST_URI = "request.uri";
    public static final String KEY_VALIDATION_PATH = "validation.path";
    public static final String KEY_VALIDATION_REGEX = "validation.regex";
    public static final String KEY_VALIDATION_VALUE = "validation.value";
    public static final String KEY_SITEMAP_ATTRIBUTE = "attribute:";
    static final String[] VALUE_NAMES_ARRAY = new String[]{"uri", "filename", "folder", "default.encoding", "remoteaddress", "webapp", "webbasepath", "version", "versionid"};
    public static final List<String> VALUE_NAMES = Collections.unmodifiableList(Arrays.asList(VALUE_NAMES_ARRAY));
    private static final Log LOG = CmsLog.getLog(CmsMacroResolver.class);
    protected Map<String, String> m_additionalMacros;
    protected CmsObject m_cms;
    protected PageContext m_jspPageContext;
    protected boolean m_keepEmptyMacros;
    protected CmsMessages m_messages;
    protected Map<String, String[]> m_parameterMap;
    protected String m_resourceName;
    private Map<String, Factory> m_factories;

    public static void copyAndResolveMacro(CmsObject cms, String source, String destination, Map<String, String> keyValue, boolean adjustLinks) throws CmsException {
        CmsMacroResolver.copyAndResolveMacro(cms, source, destination, keyValue, adjustLinks, CmsResource.COPY_AS_NEW);
    }

    public static void copyAndResolveMacro(CmsObject cms, String source, String destination, Map<String, String> keyValue, boolean adjustLinks, CmsResource.CmsResourceCopyMode copyMode) throws CmsException {
        CmsMacroResolver.copyAndResolveMacro(cms, source, destination, keyValue, adjustLinks, copyMode, null);
    }

    public static void copyAndResolveMacro(CmsObject cms, String source, String destination, Map<String, String> keyValue, boolean adjustLinks, CmsResource.CmsResourceCopyMode copyMode, I_CmsReport report) throws CmsException {
        if (report != null) {
            report.println(org.opencms.ui.apps.Messages.get().container("RPT_MACRORESOLVER_COPY_RESOURCES_1", source));
        }
        cms.copyResource(source, destination, copyMode);
        if (report != null) {
            report.println(org.opencms.ui.apps.Messages.get().container("RPT_MACRORESOLVER_LINK_ADJUST_0"));
        }
        if (adjustLinks) {
            cms.adjustLinks(source, destination);
        }
        if (keyValue == null) {
            return;
        }
        if (keyValue.isEmpty()) {
            return;
        }
        if (report != null) {
            report.println(org.opencms.ui.apps.Messages.get().container("RPT_MACRORESOLVER_APPLY_MACROS_0"));
        }
        CmsMacroResolver macroResolver = new CmsMacroResolver();
        macroResolver.setKeepEmptyMacros(true);
        for (String string : keyValue.keySet()) {
            macroResolver.addMacro(string, keyValue.get(string));
        }
        List<CmsResource> resoucesToCopy = cms.readResources(destination, CmsResourceFilter.ALL, true);
        for (CmsResource resource : resoucesToCopy) {
            if (resource.isFile() && resource.getTypeId() != CmsResourceTypeBinary.getStaticTypeId() && resource.getTypeId() != CmsResourceTypeImage.getStaticTypeId()) {
                CmsFile file = cms.readFile(resource);
                CmsMacroResolver.updateFile(cms, file, macroResolver);
            }
            CmsMacroResolver.updateProperties(cms, resource, macroResolver);
        }
        CmsResource cmsResource = cms.readResource(destination, CmsResourceFilter.ALL);
        CmsMacroResolver.updateProperties(cms, cmsResource, macroResolver);
        if (cms.existsResource(CmsMacroResolver.ensureFoldername(destination) + ".macros")) {
            cms.deleteResource(CmsMacroResolver.ensureFoldername(destination) + ".macros", CmsResource.CmsResourceDeleteMode.valueOf(-1));
        }
    }

    public static String formatMacro(String input) {
        StringBuffer result = new StringBuffer(input.length() + 4);
        result.append('%');
        result.append('(');
        result.append(input);
        result.append(')');
        return result.toString();
    }

    public static Map<String, String[]> getBundleMapFromResources(Properties resourceBundle, CmsResource descriptor, CmsObject clonedCms) throws CmsXmlException, CmsException {
        LinkedHashMap<String, String[]> ret = new LinkedHashMap<String, String[]>();
        CmsXmlContent xmlContentDesc = CmsXmlContentFactory.unmarshal(clonedCms, clonedCms.readFile(descriptor));
        CmsXmlContentValueSequence messages = xmlContentDesc.getValueSequence("Message", CmsMessageBundleEditorTypes.Descriptor.LOCALE);
        for (int i = 0; i < messages.getElementCount(); ++i) {
            String prefix = messages.getValue(i).getPath() + "/";
            String key = xmlContentDesc.getValue(prefix + "Key", CmsMessageBundleEditorTypes.Descriptor.LOCALE).getStringValue(clonedCms);
            String label = resourceBundle.getProperty(key);
            String defaultText = xmlContentDesc.getValue(prefix + "Description", CmsMessageBundleEditorTypes.Descriptor.LOCALE).getStringValue(clonedCms);
            ret.put(key, new String[]{label, defaultText});
        }
        return ret;
    }

    public static boolean isMacro(String input) {
        if (CmsStringUtil.isEmpty(input) || input.length() < 3) {
            return false;
        }
        return input.charAt(0) == '$' && input.charAt(1) == '{' && input.charAt(input.length() - 1) == '}' || input.charAt(0) == '%' && input.charAt(1) == '(' && input.charAt(input.length() - 1) == ')';
    }

    public static boolean isMacro(String input, String macroName) {
        if (CmsMacroResolver.isMacro(input)) {
            return input.substring(2, input.length() - 1).equals(macroName);
        }
        return false;
    }

    public static String localizedKeyMacro(String keyName, Object[] params) {
        Object parameters = "";
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) continue;
                parameters = (String)parameters + "|" + params[i].toString();
            }
        }
        return "%(key." + keyName + (String)parameters + ")";
    }

    public static CmsMacroResolver newInstance() {
        return new CmsMacroResolver();
    }

    public static I_CmsMacroResolver newWorkplaceLocaleResolver(CmsObject cms) {
        CmsMacroResolver resolver = new CmsMacroResolver();
        resolver.setCmsObject(cms);
        CmsUserSettings userSettings = new CmsUserSettings(cms.getRequestContext().getCurrentUser());
        CmsMultiMessages multimessages = new CmsMultiMessages(userSettings.getLocale());
        multimessages.addMessages(OpenCms.getWorkplaceManager().getMessages(userSettings.getLocale()));
        resolver.setMessages(multimessages);
        resolver.setKeepEmptyMacros(true);
        return resolver;
    }

    public static String resolveMacros(String input, CmsObject cms, CmsMessages messages) {
        CmsMacroResolver resolver = new CmsMacroResolver();
        resolver.m_cms = cms;
        resolver.m_messages = messages;
        resolver.m_keepEmptyMacros = true;
        return resolver.resolveMacros(input);
    }

    public static String resolveMacros(String input, I_CmsMacroResolver resolver) {
        int np;
        int de;
        int ds;
        int p;
        if (input == null || input.length() < 3) {
            return input;
        }
        int pn = input.indexOf(37);
        int po = input.indexOf(36);
        if (po == -1 && pn == -1) {
            return input;
        }
        int len = input.length();
        StringBuffer result = new StringBuffer(len << 1);
        boolean keep = resolver.isKeepEmptyMacros();
        boolean resolvedNone = true;
        if (po == -1 || pn > -1 && pn < po) {
            p = pn;
            ds = 40;
            de = 41;
        } else {
            p = po;
            ds = 123;
            de = 125;
        }
        result.append(input.substring(0, p));
        do {
            int e;
            int pp1;
            int pp2;
            if ((pp2 = (pp1 = p + 1) + 1) >= len) {
                result.append(input.substring(p, len));
                break;
            }
            if (pn > -1 && pn < pp1) {
                pn = input.indexOf(37, pp1);
            }
            if (po > -1 && po < pp1) {
                po = input.indexOf(36, pp1);
            }
            np = po == -1 && pn == -1 ? len : (po == -1 || pn > -1 && pn < po ? pn : po);
            int st = input.charAt(pp1);
            if (st == ds) {
                e = input.indexOf(de, p);
                if (e > 0 && e < np) {
                    String macro = input.substring(pp2, e);
                    String value = resolver.getMacroValue(macro);
                    ++e;
                    if (value != null) {
                        result.append(value);
                        resolvedNone = false;
                    } else if (keep) {
                        result.append(input.substring(p, e));
                    }
                } else {
                    e = p;
                }
            } else {
                e = p;
            }
            if (np == pn) {
                ds = 40;
                de = 41;
            } else {
                ds = 123;
                de = 125;
            }
            result.append(input.substring(e, np));
        } while ((p = np) < len);
        if (resolvedNone && keep) {
            return input;
        }
        return result.toString();
    }

    public static String stripMacro(String input) {
        if (CmsMacroResolver.isMacro(input)) {
            return input.substring(2, input.length() - 1);
        }
        return null;
    }

    private static String ensureFoldername(String resourcename) throws CmsIllegalArgumentException {
        if (CmsStringUtil.isEmpty(resourcename)) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_BAD_RESOURCENAME_1", resourcename));
        }
        if (!CmsResource.isFolder(resourcename)) {
            resourcename = resourcename.concat("/");
        }
        if (resourcename.charAt(0) == '/') {
            resourcename = resourcename.substring(1);
        }
        return resourcename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateFile(CmsObject cms, CmsFile file, CmsMacroResolver macroResolver) throws CmsException {
        String content;
        String encoding = cms.readPropertyObject(file, "content-encoding", true).getValue(OpenCms.getSystemInfo().getDefaultEncoding());
        try {
            content = macroResolver.resolveMacros(new String(file.getContents(), encoding));
        }
        catch (UnsupportedEncodingException e) {
            try {
                content = macroResolver.resolveMacros(new String(file.getContents(), Charset.defaultCharset().toString()));
            }
            catch (UnsupportedEncodingException e1) {
                content = macroResolver.resolveMacros(new String(file.getContents()));
            }
        }
        try {
            file.setContents(content.getBytes(encoding));
        }
        catch (UnsupportedEncodingException e) {
            try {
                file.setContents(content.getBytes(Charset.defaultCharset().toString()));
            }
            catch (UnsupportedEncodingException e1) {
                file.setContents(content.getBytes());
            }
        }
        cms.getRequestContext().setAttribute(CmsXmlContent.AUTO_CORRECTION_ATTRIBUTE, Boolean.TRUE);
        try {
            cms.writeFile(file);
        }
        finally {
            cms.getRequestContext().removeAttribute(CmsXmlContent.AUTO_CORRECTION_ATTRIBUTE);
        }
    }

    private static void updateProperties(CmsObject cms, CmsResource resource, CmsMacroResolver macroResolver) throws CmsException {
        for (CmsProperty property : cms.readPropertyObjects(resource, false)) {
            String resValue = null;
            if (property.getResourceValue() != null) {
                resValue = macroResolver.resolveMacros(property.getResourceValue());
            }
            String strValue = null;
            if (property.getStructureValue() != null) {
                strValue = macroResolver.resolveMacros(property.getStructureValue());
            }
            CmsProperty newProperty = new CmsProperty(property.getName(), strValue, resValue);
            cms.writePropertyObject(cms.getSitePath(resource), newProperty);
        }
    }

    public void addDynamicMacro(String name, Factory factory) {
        if (this.m_factories == null) {
            this.m_factories = new HashMap<String, Factory>();
        }
        this.m_factories.put(name, factory);
    }

    public void addMacro(String key, String value) {
        if (this.m_additionalMacros == null) {
            this.m_additionalMacros = new HashMap<String, String>();
        }
        this.m_additionalMacros.put(key, value);
    }

    @Override
    public String getMacroValue(String macro) {
        Factory factory;
        if (this.m_messages != null && macro.startsWith(KEY_LOCALIZED_PREFIX)) {
            String keyName = macro.substring(KEY_LOCALIZED_PREFIX.length());
            return this.m_messages.keyWithParams(keyName);
        }
        if (this.m_factories != null && (factory = this.m_factories.get(macro)) != null) {
            String value = (String)factory.create();
            return value;
        }
        if (this.m_jspPageContext != null) {
            block79: {
                if (this.m_jspPageContext.getRequest() != null) {
                    if (macro.startsWith(KEY_REQUEST_PARAM)) {
                        macro = macro.substring(KEY_REQUEST_PARAM.length());
                        String result = null;
                        if (this.m_parameterMap != null) {
                            String[] param = this.m_parameterMap.get(macro);
                            if (param != null && param.length >= 1) {
                                result = param[0];
                            }
                        } else {
                            result = this.m_jspPageContext.getRequest().getParameter(macro);
                        }
                        if (result == null && macro.equals(KEY_PROJECT_ID)) {
                            result = this.m_cms.getRequestContext().getCurrentProject().getUuid().toString();
                        }
                        return result;
                    }
                    if (this.m_cms != null && macro.startsWith(KEY_PROPERTY_ELEMENT)) {
                        macro = macro.substring(KEY_PROPERTY_ELEMENT.length());
                        CmsFlexController controller = CmsFlexController.getController(this.m_jspPageContext.getRequest());
                        try {
                            CmsProperty property = this.m_cms.readPropertyObject(controller.getCurrentRequest().getElementUri(), macro, false);
                            if (property != CmsProperty.getNullProperty()) {
                                return property.getValue();
                            }
                        }
                        catch (CmsException e) {
                            if (!LOG.isWarnEnabled()) break block79;
                            LOG.warn((Object)Messages.get().getBundle().key("LOG_PROPERTY_READING_FAILED_2", macro, controller.getCurrentRequest().getElementUri()), (Throwable)e);
                        }
                    }
                }
            }
            if (macro.startsWith(KEY_PAGE_CONTEXT)) {
                macro = macro.substring(KEY_PAGE_CONTEXT.length());
                int scope = this.m_jspPageContext.getAttributesScope(macro);
                return this.m_jspPageContext.getAttribute(macro, scope).toString();
            }
        }
        if (this.m_cms != null) {
            String remaining;
            if (macro.startsWith(KEY_PROPERTY)) {
                block80: {
                    macro = macro.substring(KEY_PROPERTY.length());
                    try {
                        CmsProperty property = this.m_cms.readPropertyObject(this.m_cms.getRequestContext().getUri(), macro, true);
                        if (property != CmsProperty.getNullProperty()) {
                            return property.getValue();
                        }
                    }
                    catch (CmsException e) {
                        if (!LOG.isWarnEnabled()) break block80;
                        CmsMessageContainer message = Messages.get().container("LOG_PROPERTY_READING_FAILED_2", macro, this.m_cms.getRequestContext().getUri());
                        LOG.warn((Object)message.key(), (Throwable)e);
                    }
                }
                return null;
            }
            if (macro.startsWith(KEY_ATTRIBUTE)) {
                macro = macro.substring(KEY_ATTRIBUTE.length());
                Object attribute = this.m_cms.getRequestContext().getAttribute(macro);
                if (attribute != null) {
                    return attribute.toString();
                }
                return null;
            }
            if (macro.startsWith(KEY_OPENCMS)) {
                String originalKey = macro;
                macro = macro.substring(KEY_OPENCMS.length());
                int index = VALUE_NAMES.indexOf(macro);
                String value = null;
                switch (index) {
                    case 0: {
                        value = this.m_cms.getRequestContext().getUri();
                        break;
                    }
                    case 1: {
                        value = this.m_resourceName;
                        break;
                    }
                    case 2: {
                        value = this.m_cms.getRequestContext().getFolderUri();
                        break;
                    }
                    case 3: {
                        value = OpenCms.getSystemInfo().getDefaultEncoding();
                        break;
                    }
                    case 4: {
                        value = this.m_cms.getRequestContext().getRemoteAddress();
                        break;
                    }
                    case 5: {
                        value = OpenCms.getSystemInfo().getWebApplicationName();
                        break;
                    }
                    case 6: {
                        value = OpenCms.getSystemInfo().getWebApplicationRfsPath();
                        break;
                    }
                    case 7: {
                        value = OpenCms.getSystemInfo().getVersionNumber();
                        break;
                    }
                    case 8: {
                        value = OpenCms.getSystemInfo().getVersionId();
                        break;
                    }
                    default: {
                        value = originalKey;
                    }
                }
                return value;
            }
            if (macro.startsWith(KEY_PARAM)) {
                remaining = macro.substring(KEY_PARAM.length());
                int colPos = remaining.indexOf(":");
                String defaultValue = null;
                String key = null;
                if (colPos > -1) {
                    defaultValue = remaining.substring(colPos + 1);
                    key = remaining.substring(0, colPos);
                } else {
                    key = remaining;
                }
                String val = CmsParameterStore.getInstance().getValue(this.m_cms, key);
                if (val == null) {
                    val = defaultValue;
                }
                if (val == null) {
                    LOG.warn((Object)("Parameter not defined: " + remaining));
                }
                return val;
            }
            if (macro.startsWith(KEY_SITEMAP_ATTRIBUTE)) {
                CmsADEConfigData config;
                String val;
                remaining = macro.substring(KEY_SITEMAP_ATTRIBUTE.length());
                int colPos = remaining.indexOf(":");
                String defaultValue = null;
                String key = null;
                if (colPos > -1) {
                    defaultValue = remaining.substring(colPos + 1);
                    key = remaining.substring(0, colPos);
                } else {
                    key = remaining;
                }
                String adeContext = (String)this.m_cms.getRequestContext().getAttribute(CmsRequestContext.ATTRIBUTE_ADE_CONTEXT_PATH);
                if (adeContext == null) {
                    adeContext = this.m_cms.getRequestContext().getRootUri();
                }
                if ((val = (config = OpenCms.getADEManager().lookupConfigurationWithCache(this.m_cms, adeContext)).getAttribute(key, defaultValue)) == null) {
                    LOG.warn((Object)("Sitemap attribute not defined: " + key));
                }
                return val;
            }
            if (KEY_CURRENT_USER_NAME.equals(macro)) {
                return this.m_cms.getRequestContext().getCurrentUser().getName();
            }
            if (KEY_CURRENT_USER_FIRSTNAME.equals(macro)) {
                return this.m_cms.getRequestContext().getCurrentUser().getFirstname();
            }
            if (KEY_CURRENT_USER_LASTNAME.equals(macro)) {
                return this.m_cms.getRequestContext().getCurrentUser().getLastname();
            }
            if (KEY_CURRENT_USER_DISPLAYNAME.equals(macro)) {
                try {
                    if (this.m_messages != null) {
                        return this.m_cms.getRequestContext().getCurrentUser().getDisplayName(this.m_cms, this.m_messages.getLocale());
                    }
                    return this.m_cms.getRequestContext().getCurrentUser().getDisplayName(this.m_cms, this.m_cms.getRequestContext().getLocale());
                }
                catch (CmsException remaining2) {
                    // empty catch block
                }
            }
            if (KEY_CURRENT_ORGUNIT_FQN.equals(macro)) {
                return this.m_cms.getRequestContext().getOuFqn();
            }
            if (KEY_CURRENT_ORGUNIT_DESCRIPTION.equals(macro)) {
                try {
                    CmsOrganizationalUnit ou = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_cms, this.m_cms.getRequestContext().getOuFqn());
                    if (this.m_messages != null) {
                        return ou.getDescription(this.m_messages.getLocale());
                    }
                    return ou.getDescription(this.m_cms.getRequestContext().getLocale());
                }
                catch (CmsException ou) {
                    // empty catch block
                }
            }
            if (KEY_CURRENT_USER_FULLNAME.equals(macro)) {
                return this.m_cms.getRequestContext().getCurrentUser().getFullName();
            }
            if (KEY_CURRENT_USER_EMAIL.equals(macro)) {
                return this.m_cms.getRequestContext().getCurrentUser().getEmail();
            }
            if (KEY_CURRENT_USER_STREET.equals(macro)) {
                return this.m_cms.getRequestContext().getCurrentUser().getAddress();
            }
            if (KEY_CURRENT_USER_ZIP.equals(macro)) {
                return this.m_cms.getRequestContext().getCurrentUser().getZipcode();
            }
            if (KEY_CURRENT_USER_COUNTRY.equals(macro)) {
                return this.m_cms.getRequestContext().getCurrentUser().getCountry();
            }
            if (KEY_CURRENT_USER_CITY.equals(macro)) {
                return this.m_cms.getRequestContext().getCurrentUser().getCity();
            }
            if (KEY_CURRENT_USER_LASTLOGIN.equals(macro) && this.m_messages != null) {
                return this.m_messages.getDateTime(this.m_cms.getRequestContext().getCurrentUser().getLastlogin());
            }
            if (KEY_REQUEST_SITEROOT.equals(macro)) {
                return this.m_cms.getRequestContext().getSiteRoot();
            }
            if (KEY_REQUEST_URI.equals(macro)) {
                return this.m_cms.getRequestContext().getUri();
            }
            if (KEY_REQUEST_FOLDER.equals(macro)) {
                return CmsResource.getParentFolder(this.m_cms.getRequestContext().getUri());
            }
            if (KEY_REQUEST_ENCODING.equals(macro)) {
                return this.m_cms.getRequestContext().getEncoding();
            }
            if (KEY_REQUEST_LOCALE.equals(macro)) {
                return this.m_cms.getRequestContext().getLocale().toString();
            }
            if (KEY_CONTEXT_PATH.equals(macro)) {
                return OpenCms.getSystemInfo().getContextPath();
            }
            if (KEY_CURRENT_USER_INSTITUTION.equals(macro)) {
                return this.m_cms.getRequestContext().getCurrentUser().getInstitution();
            }
        }
        if (KEY_CURRENT_TIME.equals(macro)) {
            return String.valueOf(System.currentTimeMillis());
        }
        if (macro.startsWith(KEY_CURRENT_TIME)) {
            macro = macro.substring(KEY_CURRENT_TIME.length()).trim();
            char operator = macro.charAt(0);
            macro = macro.substring(1).trim();
            long delta = 0L;
            try {
                delta = Long.parseLong(macro);
            }
            catch (NumberFormatException key) {
                // empty catch block
            }
            long resultTime = System.currentTimeMillis();
            switch (operator) {
                case '+': {
                    resultTime += delta;
                    break;
                }
                case '-': {
                    resultTime -= delta;
                    break;
                }
            }
            return String.valueOf(resultTime);
        }
        if (KEY_RANDOM_ID.equals(macro)) {
            String id = CmsUUID.getConstantUUID("randomId." + Math.random()).toString();
            return id.substring(0, id.indexOf(45));
        }
        if (this.m_additionalMacros != null) {
            return this.m_additionalMacros.get(macro);
        }
        return null;
    }

    @Override
    public boolean isKeepEmptyMacros() {
        return this.m_keepEmptyMacros;
    }

    @Override
    public String resolveMacros(String input) {
        String result = input;
        if (input != null) {
            String lastResult;
            int count = 0;
            do {
                lastResult = result;
                result = CmsMacroResolver.resolveMacros(result, this);
                if (++count < 1000 || !LOG.isErrorEnabled()) continue;
                LOG.error((Object)("Terminated macro resolution after 1000 iterations. Last substitution is \"" + lastResult + "\" to \"" + result + "\"."));
            } while (!result.equals(lastResult) && count < 1000);
        }
        return result;
    }

    public CmsMacroResolver setAdditionalMacros(Map<String, String> additionalMacros) {
        this.m_additionalMacros = additionalMacros;
        return this;
    }

    public CmsMacroResolver setCmsObject(CmsObject cms) {
        this.m_cms = cms;
        return this;
    }

    public CmsMacroResolver setJspPageContext(PageContext jspPageContext) {
        this.m_jspPageContext = jspPageContext;
        return this;
    }

    public CmsMacroResolver setKeepEmptyMacros(boolean keepEmptyMacros) {
        this.m_keepEmptyMacros = keepEmptyMacros;
        return this;
    }

    public CmsMacroResolver setMessages(CmsMessages messages) {
        this.m_messages = messages;
        return this;
    }

    public void setParameterMap(Map<String, String[]> parameterMap) {
        this.m_parameterMap = parameterMap;
    }

    public CmsMacroResolver setResourceName(String resourceName) {
        this.m_resourceName = resourceName;
        return this;
    }

    public Function<String, String> toFunction() {
        return new Function<String, String>(){

            public String apply(String input) {
                return CmsMacroResolver.this.resolveMacros(input);
            }
        };
    }
}

