/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public final class CmsColorContrastCalculator {
    public static final String INVALID_FOREGROUND = "#ff0000";
    private static final Map<String, int[]> NAMED_COLORS = Map.ofEntries(Map.entry("black", new int[]{0, 0, 0}), Map.entry("white", new int[]{255, 255, 255}), Map.entry("red", new int[]{255, 0, 0}), Map.entry("green", new int[]{0, 128, 0}), Map.entry("blue", new int[]{0, 0, 255}), Map.entry("yellow", new int[]{255, 255, 0}), Map.entry("cyan", new int[]{0, 255, 255}), Map.entry("magenta", new int[]{255, 0, 255}), Map.entry("gray", new int[]{128, 128, 128}), Map.entry("grey", new int[]{128, 128, 128}), Map.entry("transparent", new int[]{255, 255, 255, 0}), Map.entry("aliceblue", new int[]{240, 248, 255}), Map.entry("antiquewhite", new int[]{250, 235, 215}), Map.entry("aqua", new int[]{0, 255, 255}), Map.entry("aquamarine", new int[]{127, 255, 212}), Map.entry("azure", new int[]{240, 255, 255}), Map.entry("beige", new int[]{245, 245, 220}), Map.entry("bisque", new int[]{255, 228, 196}), Map.entry("blanchedalmond", new int[]{255, 235, 205}), Map.entry("blueviolet", new int[]{138, 43, 226}), Map.entry("brown", new int[]{165, 42, 42}), Map.entry("burlywood", new int[]{222, 184, 135}), Map.entry("cadetblue", new int[]{95, 158, 160}), Map.entry("chartreuse", new int[]{127, 255, 0}), Map.entry("chocolate", new int[]{210, 105, 30}), Map.entry("coral", new int[]{255, 127, 80}), Map.entry("cornflowerblue", new int[]{100, 149, 237}), Map.entry("cornsilk", new int[]{255, 248, 220}), Map.entry("crimson", new int[]{220, 20, 60}), Map.entry("darkblue", new int[]{0, 0, 139}), Map.entry("darkcyan", new int[]{0, 139, 139}), Map.entry("darkgoldenrod", new int[]{184, 134, 11}), Map.entry("darkgray", new int[]{169, 169, 169}), Map.entry("darkgreen", new int[]{0, 100, 0}), Map.entry("darkgrey", new int[]{169, 169, 169}), Map.entry("darkkhaki", new int[]{189, 183, 107}), Map.entry("darkmagenta", new int[]{139, 0, 139}), Map.entry("darkolivegreen", new int[]{85, 107, 47}), Map.entry("darkorange", new int[]{255, 140, 0}), Map.entry("darkorchid", new int[]{153, 50, 204}), Map.entry("darkred", new int[]{139, 0, 0}), Map.entry("darksalmon", new int[]{233, 150, 122}), Map.entry("darkseagreen", new int[]{143, 188, 143}), Map.entry("darkslateblue", new int[]{72, 61, 139}), Map.entry("darkslategray", new int[]{47, 79, 79}), Map.entry("darkslategrey", new int[]{47, 79, 79}), Map.entry("darkturquoise", new int[]{0, 206, 209}), Map.entry("darkviolet", new int[]{148, 0, 211}), Map.entry("deeppink", new int[]{255, 20, 147}), Map.entry("deepskyblue", new int[]{0, 191, 255}), Map.entry("dimgray", new int[]{105, 105, 105}), Map.entry("dimgrey", new int[]{105, 105, 105}), Map.entry("dodgerblue", new int[]{30, 144, 255}), Map.entry("firebrick", new int[]{178, 34, 34}), Map.entry("floralwhite", new int[]{255, 250, 240}), Map.entry("forestgreen", new int[]{34, 139, 34}), Map.entry("fuchsia", new int[]{255, 0, 255}), Map.entry("gainsboro", new int[]{220, 220, 220}), Map.entry("ghostwhite", new int[]{248, 248, 255}), Map.entry("gold", new int[]{255, 215, 0}), Map.entry("goldenrod", new int[]{218, 165, 32}), Map.entry("greenyellow", new int[]{173, 255, 47}), Map.entry("honeydew", new int[]{240, 255, 240}), Map.entry("hotpink", new int[]{255, 105, 180}), Map.entry("indianred", new int[]{205, 92, 92}), Map.entry("indigo", new int[]{75, 0, 130}), Map.entry("ivory", new int[]{255, 255, 240}), Map.entry("khaki", new int[]{240, 230, 140}), Map.entry("lavender", new int[]{230, 230, 250}), Map.entry("lavenderblush", new int[]{255, 240, 245}), Map.entry("lawngreen", new int[]{124, 252, 0}), Map.entry("lemonchiffon", new int[]{255, 250, 205}), Map.entry("lightblue", new int[]{173, 216, 230}), Map.entry("lightcoral", new int[]{240, 128, 128}), Map.entry("lightcyan", new int[]{224, 255, 255}), Map.entry("lightgoldenrodyellow", new int[]{250, 250, 210}), Map.entry("lightgray", new int[]{211, 211, 211}), Map.entry("lightgreen", new int[]{144, 238, 144}), Map.entry("lightgrey", new int[]{211, 211, 211}), Map.entry("lightpink", new int[]{255, 182, 193}), Map.entry("lightsalmon", new int[]{255, 160, 122}), Map.entry("lightseagreen", new int[]{32, 178, 170}), Map.entry("lightskyblue", new int[]{135, 206, 250}), Map.entry("lightslategray", new int[]{119, 136, 153}), Map.entry("lightslategrey", new int[]{119, 136, 153}), Map.entry("lightsteelblue", new int[]{176, 196, 222}), Map.entry("lightyellow", new int[]{255, 255, 224}), Map.entry("lime", new int[]{0, 255, 0}), Map.entry("limegreen", new int[]{50, 205, 50}), Map.entry("linen", new int[]{250, 240, 230}), Map.entry("maroon", new int[]{128, 0, 0}), Map.entry("mediumaquamarine", new int[]{102, 205, 170}), Map.entry("mediumblue", new int[]{0, 0, 205}), Map.entry("mediumorchid", new int[]{186, 85, 211}), Map.entry("mediumpurple", new int[]{147, 112, 219}), Map.entry("mediumseagreen", new int[]{60, 179, 113}), Map.entry("mediumslateblue", new int[]{123, 104, 238}), Map.entry("mediumspringgreen", new int[]{0, 250, 154}), Map.entry("mediumturquoise", new int[]{72, 209, 204}), Map.entry("mediumvioletred", new int[]{199, 21, 133}), Map.entry("midnightblue", new int[]{25, 25, 112}), Map.entry("mintcream", new int[]{245, 255, 250}), Map.entry("mistyrose", new int[]{255, 228, 225}), Map.entry("moccasin", new int[]{255, 228, 181}), Map.entry("navajowhite", new int[]{255, 222, 173}), Map.entry("navy", new int[]{0, 0, 128}), Map.entry("oldlace", new int[]{253, 245, 230}), Map.entry("olive", new int[]{128, 128, 0}), Map.entry("olivedrab", new int[]{107, 142, 35}), Map.entry("opencms", new int[]{179, 27, 52}), Map.entry("orange", new int[]{255, 165, 0}), Map.entry("orangered", new int[]{255, 69, 0}), Map.entry("orchid", new int[]{218, 112, 214}), Map.entry("palegoldenrod", new int[]{238, 232, 170}), Map.entry("palegreen", new int[]{152, 251, 152}), Map.entry("paleturquoise", new int[]{175, 238, 238}), Map.entry("palevioletred", new int[]{219, 112, 147}), Map.entry("papayawhip", new int[]{255, 239, 213}), Map.entry("peachpuff", new int[]{255, 218, 185}), Map.entry("peru", new int[]{205, 133, 63}), Map.entry("pink", new int[]{255, 192, 203}), Map.entry("plum", new int[]{221, 160, 221}), Map.entry("powderblue", new int[]{176, 224, 230}), Map.entry("purple", new int[]{128, 0, 128}), Map.entry("rebeccapurple", new int[]{102, 51, 153}), Map.entry("rosybrown", new int[]{188, 143, 143}), Map.entry("royalblue", new int[]{65, 105, 225}), Map.entry("saddlebrown", new int[]{139, 69, 19}), Map.entry("salmon", new int[]{250, 128, 114}), Map.entry("sandybrown", new int[]{244, 164, 96}), Map.entry("seagreen", new int[]{46, 139, 87}), Map.entry("seashell", new int[]{255, 245, 238}), Map.entry("sienna", new int[]{160, 82, 45}), Map.entry("silver", new int[]{192, 192, 192}), Map.entry("skyblue", new int[]{135, 206, 235}), Map.entry("slateblue", new int[]{106, 90, 205}), Map.entry("slategray", new int[]{112, 128, 144}), Map.entry("slategrey", new int[]{112, 128, 144}), Map.entry("snow", new int[]{255, 250, 250}), Map.entry("springgreen", new int[]{0, 255, 127}), Map.entry("steelblue", new int[]{70, 130, 180}), Map.entry("tan", new int[]{210, 180, 140}), Map.entry("teal", new int[]{0, 128, 128}), Map.entry("thistle", new int[]{216, 191, 216}), Map.entry("tomato", new int[]{255, 99, 71}), Map.entry("turquoise", new int[]{64, 224, 208}), Map.entry("violet", new int[]{238, 130, 238}), Map.entry("wheat", new int[]{245, 222, 179}), Map.entry("whitesmoke", new int[]{245, 245, 245}), Map.entry("yellowgreen", new int[]{154, 205, 50}));
    private Map<String, Double> m_luminanceCache = new ConcurrentHashMap<String, Double>();

    public String checkForeground(String bgColor, String fgColor) {
        try {
            return this.checkForegroundRgb(this.toRgbArray(bgColor, true, false), this.toRgbArray(fgColor, true, false));
        }
        catch (IllegalArgumentException e) {
            return INVALID_FOREGROUND;
        }
    }

    public String checkForegroundList(String bgColor, List<String> fgColorList) {
        return this.checkForegroundListRgb(this.toRgbArray(bgColor, true, false), this.colorListToRgbList(fgColorList));
    }

    public double getContrast(String bgColor, String fgColor) {
        return this.getContrastRgb(this.toRgbArray(bgColor, true, false), this.toRgbArray(fgColor, true, false));
    }

    public String getForeground(String bgColor) {
        try {
            return this.getForegroundRgb(this.toRgbArray(bgColor, true, false));
        }
        catch (IllegalArgumentException e) {
            return INVALID_FOREGROUND;
        }
    }

    public boolean hasSufficientContrast(String bgColor, String fgColor) {
        return this.hasSufficientContrastRgb(this.toRgbArray(bgColor, true, false), this.toRgbArray(fgColor, true, false));
    }

    public boolean isValid(String color) {
        return null != this.toRgbArray(color);
    }

    public String normalize(String color) {
        String result = this.toHex(color);
        if (result == null) {
            result = INVALID_FOREGROUND;
        }
        return result;
    }

    public String suggestForeground(String bgColor, String fgColor) {
        try {
            return this.suggestForegroundRgb(this.toRgbArray(bgColor, true, false), this.toRgbArray(fgColor, true, false));
        }
        catch (IllegalArgumentException e) {
            return INVALID_FOREGROUND;
        }
    }

    public String toHex(String color) {
        String result = null;
        if (color != null && color.length() != 0 && this.isValid(color)) {
            return this.rgbToHex(this.toRgbArray(color));
        }
        return result;
    }

    public int[] toRgbArray(String color) {
        return this.toRgbArray(color, true, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int[] toRgbArray(String color, boolean supportNames, boolean supportAlpha) {
        int[] result = null;
        if (color == null) return result;
        if ((color = color.toLowerCase().trim()).startsWith("#")) {
            try {
                color = this.normalizeHex(color, supportAlpha);
                int length = color.length();
                if (!supportAlpha) {
                    if (length != 7) return result;
                }
                result = new int[length == 7 ? 3 : 4];
                int i = 0;
                while (i < result.length) {
                    result[i] = Integer.parseInt(color.substring(1 + i * 2, 3 + i * 2), 16);
                    ++i;
                }
                return result;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        if (!supportNames) return result;
        return NAMED_COLORS.get(color);
    }

    public String toRgb(String color) {
        String result = null;
        int[] rgb = this.toRgbArray(color, true, true);
        if (rgb != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < rgb.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(rgb[i]);
            }
            result = sb.toString();
        }
        return result;
    }

    private double calculateContrastRatio(int[] color1, int[] color2) {
        double l1 = this.getCachedLuminance(color1);
        double l2 = this.getCachedLuminance(color2);
        double lighter = Math.max(l1, l2);
        double darker = Math.min(l1, l2);
        return (lighter + 0.05) / (darker + 0.05);
    }

    private double calculateRelativeLuminance(int[] rgb) {
        double r = this.normalizeChannel(rgb[0]);
        double g = this.normalizeChannel(rgb[1]);
        double b = this.normalizeChannel(rgb[2]);
        return 0.2126 * r + 0.7152 * g + 0.0722 * b;
    }

    private String checkForegroundListRgb(int[] bgRgb, List<int[]> fgRgbList) {
        if (fgRgbList == null || fgRgbList.isEmpty()) {
            return INVALID_FOREGROUND;
        }
        try {
            this.validateRgb(bgRgb);
        }
        catch (IllegalArgumentException e) {
            return INVALID_FOREGROUND;
        }
        boolean hasValidColor = false;
        for (int[] fgRgb : fgRgbList) {
            try {
                this.validateRgb(fgRgb);
                if (this.hasSufficientContrastRgb(bgRgb, fgRgb)) {
                    return this.rgbToHex(fgRgb);
                }
                hasValidColor = true;
            }
            catch (IllegalArgumentException e) {}
        }
        return hasValidColor ? this.getForegroundRgb(bgRgb) : INVALID_FOREGROUND;
    }

    private String checkForegroundRgb(int[] bgRgb, int[] fgRgb) {
        try {
            this.validateRgb(bgRgb);
            this.validateRgb(fgRgb);
        }
        catch (IllegalArgumentException e) {
            return INVALID_FOREGROUND;
        }
        return this.hasSufficientContrastRgb(bgRgb, fgRgb) ? this.rgbToHex(fgRgb) : this.getForegroundRgb(bgRgb);
    }

    private List<int[]> colorListToRgbList(List<String> colorList) {
        if (colorList == null) {
            return null;
        }
        return colorList.stream().map(color -> this.toRgbArray((String)color, true, false)).collect(Collectors.toList());
    }

    private double getCachedLuminance(int[] rgb) {
        String hex = this.rgbToHex(rgb);
        return this.m_luminanceCache.computeIfAbsent(hex, k -> this.calculateRelativeLuminance(rgb));
    }

    private String getClosestCompliantColor(int[] bgRgb, int[] fgRgb) {
        int step = 5;
        int[] originalFgRgb = (int[])fgRgb.clone();
        for (int i = 0; i <= 255; i += step) {
            int[] nArray = new int[]{Math.min(originalFgRgb[0] + i, 255), Math.min(originalFgRgb[1] + i, 255), Math.min(originalFgRgb[2] + i, 255)};
            int[] lighterRgb = nArray;
            if (this.calculateContrastRatio(bgRgb, lighterRgb) >= 4.5) {
                return this.rgbToHex(lighterRgb);
            }
            int[] nArray2 = new int[]{Math.max(originalFgRgb[0] - i, 0), Math.max(originalFgRgb[1] - i, 0), Math.max(originalFgRgb[2] - i, 0)};
            int[] darkerRgb = nArray2;
            if (!(this.calculateContrastRatio(bgRgb, darkerRgb) >= 4.5)) continue;
            return this.rgbToHex(darkerRgb);
        }
        return this.getForegroundRgb(bgRgb);
    }

    private double getContrastRgb(int[] bgRgb, int[] fgRgb) {
        try {
            this.validateRgb(bgRgb);
            this.validateRgb(fgRgb);
        }
        catch (IllegalArgumentException e) {
            return 0.0;
        }
        return this.calculateContrastRatio(bgRgb, fgRgb);
    }

    private String getForegroundRgb(int[] bgRgb) {
        try {
            this.validateRgb(bgRgb);
        }
        catch (IllegalArgumentException e) {
            return INVALID_FOREGROUND;
        }
        return this.getCachedLuminance(bgRgb) > 0.179 ? "#000000" : "#ffffff";
    }

    private boolean hasSufficientContrastRgb(int[] bgRgb, int[] fgRgb) {
        return this.getContrastRgb(bgRgb, fgRgb) >= 4.5;
    }

    private double normalizeChannel(int value) {
        double srgb = (double)value / 255.0;
        if (srgb <= 0.03928) {
            return srgb / 12.92;
        }
        return Math.pow((srgb + 0.055) / 1.055, 2.4);
    }

    private String normalizeHex(String hex, boolean supportAlpha) {
        if (hex == null || ((String)hex).length() == 0) {
            throw new IllegalArgumentException("Invalid empty hex color value");
        }
        if (!((String)(hex = ((String)hex).toLowerCase().trim())).startsWith("#")) {
            throw new IllegalArgumentException("Invalid hex color, value must start with '#'");
        }
        if (((String)(hex = ((String)hex).substring(1))).length() != 3 && ((String)hex).length() != 6 && ((String)hex).length() != 8) {
            throw new IllegalArgumentException("Invalid hex color value: " + (String)hex);
        }
        if (((String)hex).length() == 3) {
            hex = "" + ((String)hex).charAt(0) + ((String)hex).charAt(0) + ((String)hex).charAt(1) + ((String)hex).charAt(1) + ((String)hex).charAt(2) + ((String)hex).charAt(2);
        } else if (!supportAlpha && ((String)hex).length() == 8 && ((String)hex).endsWith("ff")) {
            hex = ((String)hex).substring(0, 6);
        }
        return "#" + (String)hex;
    }

    private String rgbToHex(int[] rgb) {
        char[] hexChars = new char[rgb.length == 4 ? 9 : 7];
        hexChars[0] = 35;
        for (int i = 0; i < rgb.length; ++i) {
            int value = rgb[i];
            hexChars[1 + i * 2] = this.toHexChar(value >> 4 & 0xF);
            hexChars[2 + i * 2] = this.toHexChar(value & 0xF);
        }
        return new String(hexChars);
    }

    private String suggestForegroundRgb(int[] bgRgb, int[] possibleFgRgb) {
        try {
            this.validateRgb(bgRgb);
            this.validateRgb(possibleFgRgb);
        }
        catch (IllegalArgumentException e) {
            return INVALID_FOREGROUND;
        }
        return this.hasSufficientContrastRgb(bgRgb, possibleFgRgb) ? this.rgbToHex(possibleFgRgb) : this.getClosestCompliantColor(bgRgb, possibleFgRgb);
    }

    private char toHexChar(int value) {
        return (char)(value < 10 ? 48 + value : 97 + (value - 10));
    }

    private void validateRgb(int[] rgb) {
        this.validateRgb(rgb, false);
    }

    private void validateRgb(int[] rgb, boolean supportsAlpha) {
        if (rgb == null) {
            throw new IllegalArgumentException("Invalid RGB value: " + String.valueOf(rgb));
        }
        if (rgb.length == 4 && rgb[3] == 255) {
            rgb = new int[]{rgb[0], rgb[1], rgb[2]};
        }
        if (rgb.length != 3 && (!supportsAlpha || rgb.length != 4) || rgb[0] < 0 || rgb[0] > 255 || rgb[1] < 0 || rgb[1] > 255 || rgb[2] < 0 || rgb[2] > 255 || supportsAlpha && rgb.length == 4 && (rgb[3] < 0 || rgb[3] > 255)) {
            throw new IllegalArgumentException("Invalid RGB value: [" + rgb[0] + ", " + rgb[1] + ", " + rgb[2] + (String)(supportsAlpha && rgb.length == 4 ? ", " + rgb[3] : "") + "]. Each value must be an integer between 0 and 255.");
        }
    }
}

