/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.util;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsCssIcon;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.explorer.CmsResourceUtil;

public final class CmsGalleryFilePreview {
    public static final int IMAGE_HEIGHT = 170;
    public static final int IMAGE_WIDTH = 200;

    public static Component createClickableFile(CmsResource resource) {
        CmsResourceUtil resourceUtil = new CmsResourceUtil(resource);
        return CmsGalleryFilePreview.createClickableFile(resource, resourceUtil);
    }

    public static Component createClickableFile(CmsResource resource, CmsResourceUtil resourceUtil) {
        Label preview = resource == null || CmsGalleryFilePreview.isTypeImage(resource) ? CmsGalleryFilePreview.createClickableImage(resource) : CmsGalleryFilePreview.createClickableOther(resource, resourceUtil);
        preview.setWidth("200px");
        preview.setHeight("170px");
        return preview;
    }

    public static String getScaleQueryString(boolean highres) {
        return "?__scale=" + CmsGalleryFilePreview.getScaleParameter(highres);
    }

    private static Label createClickableImage(CmsResource resource) {
        String scaleUri = resource == null ? "#" : CmsGalleryFilePreview.getScaleUri(resource, false);
        String permanentUri = resource == null ? "#" : CmsGalleryFilePreview.getPermanentUri(resource);
        String image = "<img width=\"200px\" height=\"170px\" src=\"" + scaleUri + "\" srcset=\"" + scaleUri + " 2x\"  onerror='cmsJsFunctions.handleBrokenImage(this)'  >";
        String a = "<a target=\"_blank\" href=\"" + permanentUri + "\">" + image + "</a>";
        String div = "<div class=\"o-gallery-preview-image\" style=\"width:200px;height:170px;\">" + a + "</div>";
        Label label = new Label(div);
        label.setContentMode(ContentMode.HTML);
        return label;
    }

    private static Link createClickableOther(CmsResource resource, CmsResourceUtil resourceUtil) {
        CmsCssIcon cssIcon = (CmsCssIcon)resourceUtil.getSmallIconResource();
        String caption = "<div style=\"width:200px;height:170px;display: flex; justify-content: center; align-items: center;\"><span class=\"" + cssIcon.getStyleName() + "\" style=\"transform: scale(4);\"></span></div>";
        Link link = new Link(caption, (Resource)new ExternalResource(CmsGalleryFilePreview.getPermanentUri(resource)));
        link.setCaptionAsHtml(true);
        link.setTargetName("_blank");
        return link;
    }

    private static String getPermanentUri(CmsResource resource) {
        String structureId = resource.getStructureId().toString();
        String extension = CmsResource.getExtension(resource.getRootPath());
        Object suffix = extension != null ? "." + extension : "";
        String permalink = CmsStringUtil.joinPaths(OpenCms.getSystemInfo().getOpenCmsContext(), "/permalink/", structureId) + (String)suffix;
        return permalink;
    }

    private static String getScaleParameter(boolean highres) {
        int m = highres ? 2 : 1;
        String suffix = highres ? ",q:85" : "";
        return "t:9,w:" + m * 200 + ",h:" + m * 170 + suffix;
    }

    private static String getScaleUri(CmsResource resource, boolean highres) {
        String paramTimestamp = "&timestamp=" + System.currentTimeMillis();
        return CmsGalleryFilePreview.getPermanentUri(resource) + CmsGalleryFilePreview.getScaleQueryString(highres) + paramTimestamp;
    }

    private static boolean isTypeImage(CmsResource resource) {
        return OpenCms.getResourceManager().getResourceType(resource) instanceof CmsResourceTypeImage;
    }
}

