/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.sitemap;

import java.util.Collection;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.ade.sitemap.shared.CmsClientSitemapEntry;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.i18n.CmsLocaleGroup;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.ui.sitemap.CmsSitemapTreeController;
import org.opencms.util.CmsUUID;

public class CmsSitemapTreeNodeData {
    private static final Log LOG = CmsLog.getLog(CmsSitemapTreeNodeData.class);
    private CmsClientSitemapEntry m_entry;
    private boolean m_hasNoChildren;
    private boolean m_isCopyable;
    private boolean m_isDirectLink;
    private CmsResource m_linkedEntryResource;
    private CmsResource m_linkedResource;
    private String m_noTranslation;
    private Locale m_otherLocale;
    private CmsResource m_resource;

    public CmsSitemapTreeNodeData(Locale mainLocale, Locale otherLocale) {
        this.m_otherLocale = otherLocale;
    }

    public CmsClientSitemapEntry getClientEntry() {
        return this.m_entry;
    }

    public CmsResource getLinkedEntryResource() {
        return this.m_linkedEntryResource;
    }

    public CmsResource getLinkedResource() {
        return this.m_linkedResource;
    }

    public CmsResource getResource() {
        return this.m_resource;
    }

    public boolean hasNoChildren() {
        return this.m_hasNoChildren;
    }

    public void initialize(CmsObject cms) throws CmsException {
        CmsResource resource;
        CmsUUID id = this.m_entry.getId();
        this.m_resource = resource = cms.readResource(id, CmsResourceFilter.IGNORE_EXPIRATION);
        CmsResource defaultFile = resource;
        if (resource.isFolder()) {
            defaultFile = cms.readDefaultFile(resource, CmsResourceFilter.IGNORE_EXPIRATION);
        }
        CmsLocaleGroup localeGroup = cms.getLocaleGroupService().readLocaleGroup(defaultFile);
        CmsResource primary = localeGroup.getPrimaryResource();
        CmsProperty noTranslationProp = cms.readPropertyObject(primary, "locale.notranslation", false);
        this.m_noTranslation = noTranslationProp.getValue();
        CmsUUID defaultFileId = defaultFile != null ? defaultFile.getStructureId() : null;
        this.m_isCopyable = defaultFile != null && CmsResourceTypeXmlContainerPage.isContainerPage(defaultFile);
        Collection<CmsResource> resourcesForTargetLocale = localeGroup.getResourcesForLocale(this.m_otherLocale);
        if (!resourcesForTargetLocale.isEmpty()) {
            this.m_linkedResource = resourcesForTargetLocale.iterator().next();
            this.m_linkedEntryResource = CmsSitemapTreeController.readSitemapEntryFolderIfPossible(this.m_linkedResource);
            if (primary.getStructureId().equals(this.m_resource.getStructureId()) || primary.getStructureId().equals(defaultFileId) || primary.getStructureId().equals(this.m_linkedResource.getStructureId())) {
                this.m_isDirectLink = true;
            }
        }
    }

    public boolean isCopyable() {
        return this.m_isCopyable;
    }

    public boolean isDirectLink() {
        return this.m_isDirectLink;
    }

    public boolean isLinked() {
        return this.m_linkedResource != null;
    }

    public boolean isMarkedNoTranslation(Locale locale) {
        if (this.m_noTranslation != null) {
            return CmsLocaleManager.getLocales(this.m_noTranslation).contains(locale);
        }
        return false;
    }

    public void setClientEntry(CmsClientSitemapEntry entry) {
        this.m_entry = entry;
    }

    public void setHasNoChildren(boolean b) {
        this.m_hasNoChildren = b;
    }
}

