/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.sitemap;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.sitemap.CmsVfsSitemapService;
import org.opencms.ade.sitemap.shared.CmsClientSitemapEntry;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.gwt.CmsRpcException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.sitemap.CmsSitemapTreeNodeData;
import org.opencms.ui.sitemap.I_CmsLocaleCompareContext;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsSitemapTreeDataProvider {
    private static final Log LOG = CmsLog.getLog(CmsSitemapTreeDataProvider.class);
    private CmsObject m_cms;
    private Set<CmsUUID> m_foldersWithNoChildFolders;
    private I_CmsLocaleCompareContext m_localeContext;
    private CmsResource m_root;

    public CmsSitemapTreeDataProvider(CmsObject cms, CmsResource root, I_CmsLocaleCompareContext context) {
        this.m_root = root;
        this.m_localeContext = context;
        try {
            this.m_cms = OpenCms.initCmsObject(cms);
            List<CmsResource> folders = this.m_cms.readResources(root, CmsResourceFilter.IGNORE_EXPIRATION.addRequireFolder(), true);
            Collections.sort(folders, new Comparator<CmsResource>(){

                @Override
                public int compare(CmsResource arg0, CmsResource arg1) {
                    return arg0.getRootPath().compareTo(arg1.getRootPath());
                }
            });
            CmsResource lastFolder = null;
            HashSet foldersWithNoChildFolders = Sets.newHashSet();
            folders.add(null);
            for (CmsResource folder : folders) {
                if (!(lastFolder == null || folder != null && CmsStringUtil.isPrefixPath(lastFolder.getRootPath(), folder.getRootPath()))) {
                    foldersWithNoChildFolders.add(lastFolder.getStructureId());
                }
                lastFolder = folder;
            }
            this.m_foldersWithNoChildFolders = foldersWithNoChildFolders;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public List<CmsSitemapTreeNodeData> getChildren(CmsSitemapTreeNodeData nodeData) {
        CmsClientSitemapEntry entry = nodeData.getClientEntry();
        ArrayList result = Lists.newArrayList();
        try {
            CmsVfsSitemapService svc = this.getSitemapService();
            CmsClientSitemapEntry ent = svc.getChildren(this.m_root.getRootPath(), entry.getId(), 1);
            for (CmsClientSitemapEntry subEnt : ent.getSubEntries()) {
                if (!subEnt.isInNavigation() || subEnt.getDefaultFileId() == null && !subEnt.isNavigationLevelType()) continue;
                try {
                    Locale l2;
                    Locale l1;
                    CmsUUID idToRead = subEnt.getId();
                    if (subEnt.getDefaultFileId() != null) {
                        idToRead = subEnt.getDefaultFileId();
                    }
                    if (!(l1 = OpenCms.getLocaleManager().getDefaultLocale(svc.getCmsObject(), svc.getCmsObject().readResource(idToRead))).equals(l2 = OpenCms.getLocaleManager().getDefaultLocale(svc.getCmsObject(), svc.getCmsObject().readResource(ent.getId(), CmsResourceFilter.IGNORE_EXPIRATION)))) {
                        continue;
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                CmsSitemapTreeNodeData data = new CmsSitemapTreeNodeData(this.m_localeContext.getRootLocale(), this.m_localeContext.getComparisonLocale());
                if (this.m_foldersWithNoChildFolders.contains(subEnt.getId())) {
                    data.setHasNoChildren(true);
                }
                data.setClientEntry(subEnt);
                try {
                    data.initialize(this.m_cms);
                    result.add(data);
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage());
                }
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CmsRpcException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    public CmsSitemapTreeNodeData getData(CmsResource resource) {
        try {
            CmsVfsSitemapService svc = new CmsVfsSitemapService();
            CmsObject cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
            cms.getRequestContext().setSiteRoot("");
            svc.setCms(cms);
            CmsClientSitemapEntry ent = svc.getChildren(resource.getRootPath(), resource.getStructureId(), 0);
            CmsSitemapTreeNodeData data = new CmsSitemapTreeNodeData(this.m_localeContext.getRootLocale(), this.m_localeContext.getComparisonLocale());
            data.setClientEntry(ent);
            data.initialize(cms);
            return data;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public CmsSitemapTreeNodeData getRoot() {
        return this.getData(this.m_root);
    }

    public CmsVfsSitemapService getSitemapService() throws CmsException {
        CmsVfsSitemapService svc = new CmsVfsSitemapService();
        CmsObject cms = OpenCms.initCmsObject(this.m_cms);
        cms.getRequestContext().setSiteRoot("");
        svc.setCms(cms);
        return svc;
    }
}

