/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.sitemap;

import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.AbstractExtension;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsExternalLayout;
import org.opencms.ui.shared.rpc.I_CmsEmbeddedDialogClientRPC;
import org.opencms.ui.shared.rpc.I_CmsSitemapClientRpc;
import org.opencms.ui.shared.rpc.I_CmsSitemapServerRpc;
import org.opencms.ui.sitemap.CmsCopyPageDialog;
import org.opencms.ui.sitemap.CmsLocaleComparePanel;
import org.opencms.ui.sitemap.CmsSitemapTreeController;
import org.opencms.ui.sitemap.CmsSitemapUI;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsSitemapExtension
extends AbstractExtension
implements I_CmsSitemapServerRpc {
    private static final Log LOG = CmsLog.getLog(CmsSitemapExtension.class);
    private static final long serialVersionUID = 1L;
    private VerticalLayout m_localeCompareContainer;
    private CmsSitemapTreeController m_sitemapTreeController;
    private CmsSitemapUI m_ui;

    public CmsSitemapExtension(CmsSitemapUI ui) {
        this.extend((AbstractClientConnector)ui);
        this.m_ui = ui;
        this.registerRpc(this, I_CmsSitemapServerRpc.class);
    }

    @Override
    public void handleChangedProperties(String id) {
        if (this.m_sitemapTreeController != null) {
            this.m_sitemapTreeController.updateNodeForId(new CmsUUID(id));
        }
    }

    @Override
    public void openPageCopyDialog(final String callId, String structureId) {
        CmsObject cms = A_CmsUI.getCmsObject();
        try {
            CmsResource resource = cms.readResource(new CmsUUID(structureId), CmsResourceFilter.IGNORE_EXPIRATION);
            DialogContext context = new DialogContext(null, Arrays.asList(resource)){

                @Override
                public void finish(Collection<CmsUUID> result) {
                    this.closeWindow();
                    String response = result.isEmpty() ? "" : CmsStringUtil.listAsString(new ArrayList<CmsUUID>(result), "|");
                    ((I_CmsSitemapClientRpc)CmsSitemapExtension.this.getRpcProxy(I_CmsSitemapClientRpc.class)).finishPageCopyDialog(callId, response);
                }
            };
            CmsCopyPageDialog dialog = new CmsCopyPageDialog(context);
            String title = CmsVaadinUtils.getMessageText("GUI_COPYPAGE_DIALOG_TITLE_0", new Object[0]);
            context.start(title, (Component)dialog);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    public void openPropertyDialog(CmsUUID sitemapEntryId, CmsUUID rootId) {
        ((I_CmsSitemapClientRpc)this.getRpcProxy(I_CmsSitemapClientRpc.class)).openPropertyDialog(String.valueOf(sitemapEntryId), String.valueOf(rootId));
    }

    public void setSitemapTreeController(CmsSitemapTreeController controller) {
        this.m_sitemapTreeController = controller;
    }

    public void showInfoHeader(String title, String description, String path, String locale, String iconClass) {
        ((I_CmsSitemapClientRpc)this.getRpcProxy(I_CmsSitemapClientRpc.class)).showInfoHeader(title, description, path, locale, iconClass);
    }

    @Override
    public void showLocaleComparison(String id) {
        if (this.m_localeCompareContainer == null) {
            this.m_localeCompareContainer = new VerticalLayout();
            CmsExternalLayout layout = new CmsExternalLayout("cmsLocaleComparison", (Component)this.m_localeCompareContainer);
            this.m_ui.getContent().addComponent((Component)layout);
        }
        this.m_localeCompareContainer.removeAllComponents();
        this.m_localeCompareContainer.addComponent((Component)new CmsLocaleComparePanel(id));
    }

    abstract class DialogContext
    implements I_CmsDialogContext {
        private I_CmsDialogContext.ContextType m_contextType;
        private List<CmsResource> m_resources;
        private Window m_window;

        public DialogContext(I_CmsDialogContext.ContextType contextType, List<CmsResource> resources) {
            this.m_contextType = contextType;
            this.m_resources = resources != null ? resources : Collections.emptyList();
        }

        public void closeWindow() {
            if (this.m_window != null) {
                this.m_window.close();
                this.m_window = null;
            }
        }

        @Override
        public void error(Throwable error) {
            this.closeWindow();
            LOG.error((Object)error.getLocalizedMessage(), error);
            CmsErrorDialog.showErrorDialog(error, new Runnable(){

                @Override
                public void run() {
                }
            });
        }

        @Override
        public void finish(CmsProject project, String siteRoot) {
            throw new RuntimeException("NOT INPLEMENTED");
        }

        @Override
        public void focus(CmsUUID structureId) {
        }

        @Override
        public List<CmsUUID> getAllStructureIdsInView() {
            return Collections.emptyList();
        }

        @Override
        public String getAppId() {
            return "sitemapeditor";
        }

        @Override
        public CmsObject getCms() {
            return A_CmsUI.getCmsObject();
        }

        @Override
        public I_CmsDialogContext.ContextType getContextType() {
            return this.m_contextType;
        }

        @Override
        public List<CmsResource> getResources() {
            return this.m_resources;
        }

        @Override
        public void navigateTo(String appId) {
            throw new RuntimeException("NOT IMPLEMENTED");
        }

        @Override
        public void onViewChange() {
            throw new RuntimeException("NOT IMPLEMENTED");
        }

        @Override
        public void reload() {
            throw new RuntimeException("NOT IMPLEMENTED");
        }

        @Override
        public void setWindow(Window window) {
            this.m_window = window;
        }

        @Override
        public void start(String title, Component dialog) {
            this.start(title, dialog, CmsBasicDialog.DialogWidth.narrow);
        }

        @Override
        public void start(String title, Component dialog, CmsBasicDialog.DialogWidth width) {
            if (dialog != null) {
                this.m_window = CmsBasicDialog.prepareWindow(width);
                this.m_window.setCaption(title);
                this.m_window.setContent(dialog);
                UI.getCurrent().addWindow(this.m_window);
                this.m_window.addCloseListener(new Window.CloseListener(){
                    private static final long serialVersionUID = 1L;

                    public void windowClose(Window.CloseEvent e) {
                        DialogContext.this.handleWindowClose();
                    }
                });
                if (dialog instanceof CmsBasicDialog) {
                    ((CmsBasicDialog)dialog).initActionHandler(this.m_window);
                }
            }
        }

        @Override
        public void updateUserInfo() {
        }

        protected I_CmsEmbeddedDialogClientRPC getClientRPC() {
            return (I_CmsEmbeddedDialogClientRPC)CmsSitemapExtension.this.getRpcProxy(I_CmsEmbeddedDialogClientRPC.class);
        }

        void handleWindowClose() {
        }
    }
}

