/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.shared;

import com.vaadin.shared.AbstractComponentState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CmsContextMenuState
extends AbstractComponentState {
    private static final long serialVersionUID = -247856391284942254L;
    private boolean m_hideAutomatically;
    private boolean m_openAutomatically;
    private List<ContextMenuItemState> m_rootItems = new ArrayList<ContextMenuItemState>();

    public ContextMenuItemState addChild(String itemCaption, String itemId) {
        ContextMenuItemState rootItem = new ContextMenuItemState();
        rootItem.setCaption(itemCaption);
        rootItem.setId(itemId);
        this.m_rootItems.add(rootItem);
        return rootItem;
    }

    public List<ContextMenuItemState> getRootItems() {
        return this.m_rootItems;
    }

    public boolean isHideAutomatically() {
        return this.m_hideAutomatically;
    }

    public boolean isOpenAutomatically() {
        return this.m_openAutomatically;
    }

    public void setHideAutomatically(boolean hideAutomatically) {
        this.m_hideAutomatically = hideAutomatically;
    }

    public void setOpenAutomatically(boolean openAutomatically) {
        this.m_openAutomatically = openAutomatically;
    }

    public void setRootItems(List<ContextMenuItemState> rootItems) {
        this.m_rootItems = rootItems;
    }

    public static class ContextMenuItemState
    implements Serializable {
        private static final long serialVersionUID = 3836772122928080543L;
        private String m_caption;
        private List<ContextMenuItemState> m_children = new ArrayList<ContextMenuItemState>();
        private String m_description;
        private boolean m_enabled = true;
        private String m_id;
        private boolean m_separator;
        private Set<String> m_styles = new HashSet<String>();

        public ContextMenuItemState addChild(String caption, String id) {
            ContextMenuItemState child = new ContextMenuItemState();
            child.setCaption(caption);
            child.m_id = id;
            this.m_children.add(child);
            return child;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ContextMenuItemState) {
                return this.m_id.equals(((ContextMenuItemState)obj).m_id);
            }
            return false;
        }

        public String getCaption() {
            return this.m_caption;
        }

        public List<ContextMenuItemState> getChildren() {
            return this.m_children;
        }

        public String getDescription() {
            return this.m_description;
        }

        public String getId() {
            return this.m_id;
        }

        public Set<String> getStyles() {
            return this.m_styles;
        }

        public int hashCode() {
            return this.m_id.hashCode();
        }

        public boolean isSeparator() {
            return this.m_separator;
        }

        public boolean isEnabled() {
            return this.m_enabled;
        }

        public void removeChild(ContextMenuItemState child) {
            this.m_children.remove(child);
        }

        public void setCaption(String caption) {
            this.m_caption = caption;
        }

        public void setChildren(List<ContextMenuItemState> children) {
            this.m_children = children;
        }

        public void setDescription(String description) {
            this.m_description = description;
        }

        public void setEnabled(boolean enabled) {
            this.m_enabled = enabled;
        }

        public void setId(String id) {
            this.m_id = id;
        }

        public void setSeparator(boolean separator) {
            this.m_separator = separator;
        }

        public void setStyles(Set<String> styleNames) {
            this.m_styles = styleNames;
        }
    }
}

