/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.login;

import com.vaadin.event.ShortcutListener;
import com.vaadin.server.ClientConnector;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.JavaScript;
import com.vaadin.ui.TextField;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsLog;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsSecondFactorDialog
extends CmsBasicDialog {
    public static final String CLASS_VERIFICATION_CODE_FIELD = "o-verification-code-field";
    private static final Log LOG = CmsLog.getLog(CmsSecondFactorDialog.class);
    private static final long serialVersionUID = 1L;
    private Button m_okButton;
    private TextField m_verification;
    private Consumer<String> m_verificationCodeHandler;

    public CmsSecondFactorDialog(CmsUser user, Consumer<String> verificationCodeHandler) {
        CmsResourceInfo userInfo = CmsAccountsApp.getPrincipalInfo(user);
        userInfo.setTopLineText(user.getFullName());
        this.displayResourceInfoDirectly(Collections.singletonList(userInfo));
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), new HashMap<String, String>());
        this.m_verificationCodeHandler = verificationCodeHandler;
        this.m_okButton.addClickListener((Button.ClickListener & Serializable)event -> this.submit());
        this.m_verification.addShortcutListener(new ShortcutListener(null, 13, null){
            private static final long serialVersionUID = 1L;

            public void handleAction(Object sender, Object target) {
                CmsSecondFactorDialog.this.submit();
            }
        });
        this.m_verification.addStyleName(CLASS_VERIFICATION_CODE_FIELD);
        this.addAttachListener((ClientConnector.AttachListener & Serializable)event -> {
            this.m_verification.focus();
            CmsSecondFactorDialog.initVerificationField();
        });
    }

    public static String getCaption(CmsUser user) {
        return CmsVaadinUtils.getMessageText("GUI_LOGIN_2FA_VERIFICATION_0", new Object[0]);
    }

    public static void initVerificationField() {
        try {
            byte[] jsSnippetBytes = CmsFileUtil.readFully(CmsSecondFactorDialog.class.getResourceAsStream("init-verification-field.js"), true);
            String jsSnippet = new String(jsSnippetBytes, StandardCharsets.UTF_8);
            JavaScript.getCurrent().execute(jsSnippet);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected void submit() {
        String otp = this.m_verification.getValue().trim();
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(otp)) {
            CmsVaadinUtils.getWindow((Component)this).close();
            this.m_verificationCodeHandler.accept(otp);
        }
    }
}

