/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.login;

import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.AbstractExtension;
import com.vaadin.ui.UI;
import org.apache.commons.logging.Log;
import org.opencms.crypto.CmsEncryptionException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.shared.login.I_CmsLoginTargetRpc;

public class CmsLoginTargetOpener
extends AbstractExtension {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = CmsLog.getLog(CmsLoginTargetOpener.class);

    public CmsLoginTargetOpener(UI ui) {
        this.extend((AbstractClientConnector)ui);
    }

    public void openTarget(String target, boolean isPublicPC) {
        if (isPublicPC) {
            ((I_CmsLoginTargetRpc)this.getRpcProxy(I_CmsLoginTargetRpc.class)).openTargetForPublicPc(target);
        } else {
            try {
                String encryptedTarget = OpenCms.getDefaultTextEncryption().encrypt(target);
                ((I_CmsLoginTargetRpc)this.getRpcProxy(I_CmsLoginTargetRpc.class)).openTargetForPrivatePc(encryptedTarget);
            }
            catch (CmsEncryptionException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                ((I_CmsLoginTargetRpc)this.getRpcProxy(I_CmsLoginTargetRpc.class)).openTargetForPublicPc(target);
            }
        }
    }
}

