/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.favorites;

import com.vaadin.ui.Component;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsExtendedSiteSelector;
import org.opencms.ui.dialogs.CmsEmbeddedDialogContext;
import org.opencms.ui.dialogs.CmsSiteSelectDialog;
import org.opencms.ui.favorites.CmsFavoriteEntry;
import org.opencms.ui.favorites.I_CmsFavoriteContext;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsPageEditorFavoriteContext
implements I_CmsFavoriteContext {
    private static final Log LOG = CmsLog.getLog(CmsPageEditorFavoriteContext.class);
    private CmsEmbeddedDialogContext m_dialogContext;
    private CmsFavoriteEntry m_entry;

    public CmsPageEditorFavoriteContext(CmsEmbeddedDialogContext context) {
        CmsUUID detailId = CmsPageEditorFavoriteContext.toUuid(context.getParameters().get("detail"));
        CmsUUID pageId = CmsPageEditorFavoriteContext.toUuid(context.getParameters().get("page"));
        CmsUUID project = CmsPageEditorFavoriteContext.toUuid(context.getParameters().get("project"));
        String siteRoot = context.getParameters().get("site");
        CmsFavoriteEntry entry = new CmsFavoriteEntry();
        entry.setDetailId(detailId);
        entry.setProjectId(project);
        entry.setSiteRoot(siteRoot);
        entry.setStructureId(pageId);
        entry.setType(CmsFavoriteEntry.Type.page);
        this.m_entry = entry;
        this.m_dialogContext = context;
    }

    private static CmsUUID toUuid(String uuid) {
        if ("null".equals(uuid) || CmsStringUtil.isEmpty(uuid)) {
            return null;
        }
        return new CmsUUID(uuid);
    }

    @Override
    public void changeProject(CmsUUID value) {
        CmsObject cms = A_CmsUI.getCmsObject();
        try {
            CmsProject project = cms.readProject(value);
            this.close();
            A_CmsUI.get().changeProject(project);
            this.m_dialogContext.finish(project, null);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    @Override
    public void changeSite(CmsExtendedSiteSelector.SiteSelectorOption value) {
        CmsSiteSelectDialog.changeSite(this.m_dialogContext, value);
    }

    @Override
    public void close() {
        this.m_dialogContext.finish(new ArrayList<CmsUUID>());
    }

    @Override
    public Optional<CmsFavoriteEntry> getFavoriteForCurrentLocation() {
        return Optional.ofNullable(this.m_entry);
    }

    @Override
    public void openFavorite(CmsFavoriteEntry entry) {
        try {
            String url = entry.updateContextAndGetFavoriteUrl(A_CmsUI.getCmsObject());
            this.m_dialogContext.leavePage(url);
        }
        catch (CmsException e) {
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    @Override
    public void setDialog(Component component) {
    }
}

