/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.favorites;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.favorites.CmsFavoriteEntry;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsFavoriteDAO {
    public static final String ADDINFO_KEY = "favLocations";
    public static final String BASE_KEY = "f";
    private static final Log LOG = CmsLog.getLog(CmsFavoriteDAO.class);
    private CmsObject m_cms;
    private Set<CmsUUID> m_okProjects = new HashSet<CmsUUID>();
    private Set<String> m_okSiteRoots = new HashSet<String>();
    private Set<CmsUUID> m_okStructureIds = new HashSet<CmsUUID>();
    private CmsObject m_rootCms;
    private String m_userName;

    public CmsFavoriteDAO(CmsObject cms) throws CmsException {
        this(cms, cms.getRequestContext().getCurrentUser().getName());
    }

    public CmsFavoriteDAO(CmsObject cms, String userName) throws CmsException {
        this.m_cms = cms;
        this.m_rootCms = OpenCms.initCmsObject(this.m_cms);
        this.m_rootCms.getRequestContext().setSiteRoot("");
        this.m_userName = userName;
    }

    public List<CmsFavoriteEntry> loadFavorites() throws CmsException {
        ArrayList<CmsFavoriteEntry> result = new ArrayList<CmsFavoriteEntry>();
        try {
            CmsUser user = this.readUser();
            String data = (String)user.getAdditionalInfo(ADDINFO_KEY);
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(data)) {
                return new ArrayList<CmsFavoriteEntry>();
            }
            JSONObject json = new JSONObject(data);
            JSONArray array = json.getJSONArray(BASE_KEY);
            for (int i = 0; i < array.length(); ++i) {
                JSONObject fav = array.getJSONObject(i);
                try {
                    CmsFavoriteEntry entry = new CmsFavoriteEntry(fav);
                    if (!this.validate(entry)) continue;
                    result.add(entry);
                    continue;
                }
                catch (Exception e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        catch (JSONException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    public void saveFavorites(List<CmsFavoriteEntry> favorites) throws CmsException {
        try {
            JSONObject json = new JSONObject();
            JSONArray array = new JSONArray();
            for (CmsFavoriteEntry entry : favorites) {
                array.put(entry.toJson());
            }
            json.put(BASE_KEY, array);
            String data = json.toString();
            CmsUser user = this.readUser();
            user.setAdditionalInfo(ADDINFO_KEY, data);
            this.m_cms.writeUser(user);
        }
        catch (JSONException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private CmsUser readUser() throws CmsException {
        return this.m_cms.readUser(this.m_userName);
    }

    private boolean validate(CmsFavoriteEntry entry) {
        try {
            CmsUUID project;
            String siteRoot = entry.getSiteRoot();
            if (!this.m_okSiteRoots.contains(siteRoot)) {
                this.m_rootCms.readResource(siteRoot);
                this.m_okSiteRoots.add(siteRoot);
            }
            if (!this.m_okProjects.contains(project = entry.getProjectId())) {
                this.m_cms.readProject(project);
                this.m_okProjects.add(project);
            }
            for (CmsUUID id : Arrays.asList(entry.getDetailId(), entry.getStructureId())) {
                if (id == null || this.m_okStructureIds.contains(id)) continue;
                this.m_cms.readResource(id, CmsResourceFilter.IGNORE_EXPIRATION.addRequireVisible());
                this.m_okStructureIds.add(id);
            }
            return true;
        }
        catch (Exception e) {
            LOG.info((Object)("Favorite entry validation failed: " + e.getLocalizedMessage()), (Throwable)e);
            return false;
        }
    }
}

