/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.favorites;

import com.vaadin.ui.Component;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsLog;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.apps.CmsExplorerDialogContext;
import org.opencms.ui.apps.CmsFileExplorer;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsExtendedSiteSelector;
import org.opencms.ui.dialogs.CmsProjectSelectDialog;
import org.opencms.ui.favorites.CmsFavoriteEntry;
import org.opencms.ui.favorites.I_CmsFavoriteContext;
import org.opencms.util.CmsUUID;

public class CmsExplorerFavoriteContext
implements I_CmsFavoriteContext {
    private static final Log LOG = CmsLog.getLog(CmsExplorerFavoriteContext.class);
    private Component m_dialog;
    private CmsFavoriteEntry m_entry;
    private CmsFileExplorer m_explorer;

    public CmsExplorerFavoriteContext(CmsObject cms, CmsFileExplorer explorer) {
        if (explorer != null) {
            this.m_explorer = explorer;
            CmsUUID currentFolder = explorer.getCurrentFolder();
            String siteRoot = cms.getRequestContext().getSiteRoot();
            CmsUUID project = cms.getRequestContext().getCurrentProject().getId();
            CmsFavoriteEntry entry = new CmsFavoriteEntry();
            entry.setType(CmsFavoriteEntry.Type.explorerFolder);
            entry.setSiteRoot(siteRoot);
            entry.setStructureId(currentFolder);
            entry.setProjectId(project);
            this.m_entry = entry;
        }
    }

    @Override
    public void changeProject(CmsUUID value) {
        this.close();
        CmsExplorerDialogContext context = new CmsExplorerDialogContext(I_CmsDialogContext.ContextType.fileTable, null, this.m_explorer, new ArrayList<CmsResource>());
        CmsProjectSelectDialog.changeSiteOrProject(context, value, null);
    }

    @Override
    public void changeSite(CmsExtendedSiteSelector.SiteSelectorOption value) {
        this.close();
        CmsExplorerDialogContext context = new CmsExplorerDialogContext(I_CmsDialogContext.ContextType.fileTable, null, this.m_explorer, new ArrayList<CmsResource>());
        CmsProjectSelectDialog.changeSiteOrProject(context, null, value);
    }

    @Override
    public void close() {
        CmsVaadinUtils.getWindow(this.m_dialog).close();
    }

    @Override
    public Optional<CmsFavoriteEntry> getFavoriteForCurrentLocation() {
        return Optional.ofNullable(this.m_entry);
    }

    @Override
    public void openFavorite(CmsFavoriteEntry entry) {
        try {
            String url = entry.updateContextAndGetFavoriteUrl(A_CmsUI.getCmsObject());
            this.close();
            A_CmsUI.get().getPage().open(url, null);
        }
        catch (Exception e) {
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    @Override
    public void setDialog(Component component) {
        this.m_dialog = component;
    }
}

