/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.favorites;

import com.vaadin.data.HasValue;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.TextField;
import java.io.Serializable;
import java.util.Collections;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.opencms.json.JSONException;
import org.opencms.main.CmsLog;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.favorites.CmsFavInfo;
import org.opencms.ui.favorites.CmsFavoriteEntry;
import org.opencms.util.CmsStringUtil;

public class CmsEditFavoriteDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = CmsLog.getLog(CmsEditFavoriteDialog.class);
    private Consumer<CmsFavoriteEntry> m_callback;
    private Button m_cancelButton;
    private boolean m_changed;
    private CmsFavoriteEntry m_entry;
    private Button m_okButton;
    private TextField m_title;

    public CmsEditFavoriteDialog(CmsFavInfo info, Consumer<CmsFavoriteEntry> callback) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        CmsFavoriteEntry entry = info.getEntry();
        this.m_callback = callback;
        this.m_okButton.addClickListener((Button.ClickListener & Serializable)evt -> this.onClickOk());
        String customTitle = entry.getCustomTitle();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(customTitle)) {
            customTitle = info.getTopLine().getValue();
        }
        this.m_entry = entry;
        this.m_title.setValue(customTitle);
        if (info.getResource() != null) {
            this.displayResourceInfo(Collections.singletonList(info.getResource()));
        }
        this.m_cancelButton.addClickListener((Button.ClickListener & Serializable)evt -> CmsVaadinUtils.closeWindow((Component)this));
        this.m_title.addValueChangeListener((HasValue.ValueChangeListener & Serializable)evt -> {
            this.m_changed = true;
        });
    }

    protected void onClickOk() {
        if (!this.m_changed) {
            CmsVaadinUtils.closeWindow((Component)this);
            return;
        }
        String value = this.m_title.getValue();
        try {
            CmsFavoriteEntry result = new CmsFavoriteEntry(this.m_entry.toJson());
            result.setCustomTitle(value);
            this.m_callback.accept(result);
            CmsVaadinUtils.closeWindow((Component)this);
        }
        catch (JSONException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            CmsErrorDialog.showErrorDialog(e);
        }
    }
}

