/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.editors;

import com.vaadin.event.Action;
import com.vaadin.event.ShortcutAction;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.ui.ComboBox;
import java.util.HashMap;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeBinary;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsMessages;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.CmsEditor;
import org.opencms.ui.apps.I_CmsAppSettings;
import org.opencms.ui.apps.I_CmsAppUIContext;
import org.opencms.ui.apps.I_CmsHasShortcutActions;
import org.opencms.ui.components.CmsConfirmationDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsToolBar;
import org.opencms.ui.components.I_CmsWindowCloseListener;
import org.opencms.ui.components.codemirror.CmsCodeMirror;
import org.opencms.ui.editors.I_CmsEditor;
import org.opencms.ui.editors.Messages;
import org.opencms.xml.content.CmsXmlContent;

public class CmsSourceEditor
implements I_CmsEditor,
I_CmsWindowCloseListener,
ViewChangeListener,
I_CmsHasShortcutActions {
    private static final Action ACTION_EXIT = new ShortcutAction("Ctrl+Shift+X", 88, new int[]{17, 16});
    private static final Action ACTION_EXIT_CMD = new ShortcutAction("CMD+Shift+X", 88, new int[]{91, 16});
    private static final Action ACTION_SAVE = new ShortcutAction("Ctrl+S", 83, new int[]{17});
    private static final Action ACTION_SAVE_AND_EXIT = new ShortcutAction("Ctrl+Shift+S", 83, new int[]{17, 16});
    private static final Action ACTION_SAVE_AND_EXIT_CMD = new ShortcutAction("CMD+Shift+S", 83, new int[]{91, 16});
    private static final Action ACTION_SAVE_CMD = new ShortcutAction("CMD+S", 83, new int[]{91});
    private static final String[] FONT_SIZES = new String[]{"8px", "10px", "12px", "14px", "16px", "18px", "20px"};
    private static final long serialVersionUID = 726920483145397926L;
    String m_backLink;
    CmsCodeMirror m_codeMirror;
    Map<Action, Runnable> m_shortcutActions = new HashMap<Action, Runnable>();
    private boolean m_changed;
    private boolean m_cleared;
    private Button m_exit;
    private CmsLockUtil.LockedFile m_file;
    private Button m_save;
    private Button m_saveAndExit;

    public CmsSourceEditor() {
        Runnable save = new Runnable(){

            @Override
            public void run() {
                CmsSourceEditor.this.save();
            }
        };
        this.m_shortcutActions.put(ACTION_SAVE, save);
        this.m_shortcutActions.put(ACTION_SAVE_CMD, save);
        Runnable saveExit = new Runnable(){

            @Override
            public void run() {
                CmsSourceEditor.this.saveAndExit();
            }
        };
        this.m_shortcutActions.put(ACTION_SAVE_AND_EXIT, saveExit);
        this.m_shortcutActions.put(ACTION_SAVE_AND_EXIT_CMD, saveExit);
        Runnable exit = new Runnable(){

            @Override
            public void run() {
                CmsSourceEditor.this.exit();
            }
        };
        this.m_shortcutActions.put(ACTION_EXIT, exit);
        this.m_shortcutActions.put(ACTION_EXIT_CMD, exit);
    }

    public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
    }

    public boolean beforeViewChange(final ViewChangeListener.ViewChangeEvent event) {
        if (this.m_changed) {
            CmsConfirmationDialog.show(CmsVaadinUtils.getMessageText("GUI_EDITOR_CLOSE_CAPTION_0", new Object[0]), CmsVaadinUtils.getMessageText("GUI_EDITOR_CLOSE_TEXT_0", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    CmsSourceEditor.this.clear();
                    event.getNavigator().navigateTo(event.getViewName());
                }
            });
            return false;
        }
        if (!this.m_cleared) {
            this.clear();
        }
        return true;
    }

    public CmsCodeMirror.CodeMirrorLanguage getHighlightMode(CmsResource resource) {
        if (resource != null) {
            int type = resource.getTypeId();
            if (CmsResourceTypeJsp.isJspTypeId(type)) {
                return CmsCodeMirror.CodeMirrorLanguage.JSP;
            }
            if (CmsResourceTypeXmlContent.isXmlContent(resource) || CmsResourceTypeXmlPage.isXmlPage(resource)) {
                return CmsCodeMirror.CodeMirrorLanguage.XML;
            }
            int dotIndex = resource.getName().lastIndexOf(46);
            if (dotIndex != -1) {
                String suffix = resource.getName().substring(dotIndex + 1).toLowerCase();
                for (CmsCodeMirror.CodeMirrorLanguage lang : CmsCodeMirror.CodeMirrorLanguage.values()) {
                    if (!lang.isSupportedFileType(suffix)) continue;
                    return lang;
                }
            }
        }
        return CmsCodeMirror.CodeMirrorLanguage.HTML;
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public Map<Action, Runnable> getShortcutActions() {
        return this.m_shortcutActions;
    }

    @Override
    public void initUI(I_CmsAppUIContext context, CmsResource resource, String backLink, Map<String, String> params) {
        EditorSettings settings;
        CmsObject cms = A_CmsUI.getCmsObject();
        if (OpenCms.getADEManager().isEditorRestricted(cms, resource)) {
            throw new CmsRuntimeException(org.opencms.ade.contenteditor.Messages.get().container("ERR_EDITOR_RESTRICTED_0"));
        }
        CmsMessages messages = Messages.get().getBundle(UI.getCurrent().getLocale());
        context.showInfoArea(false);
        context.setAppTitle(messages.key("GUI_SOURCE_EDITOR_TITLE_0"));
        CmsAppWorkplaceUi.setWindowTitle(CmsVaadinUtils.getMessageText("GUI_CONTENT_EDITOR_TITLE_2", resource.getName(), CmsResource.getParentFolder(A_CmsUI.getCmsObject().getSitePath(resource))));
        this.m_backLink = backLink;
        this.m_codeMirror = new CmsCodeMirror();
        this.m_codeMirror.setSizeFull();
        context.setAppContent((Component)this.m_codeMirror);
        context.enableDefaultToolbarButtons(false);
        this.m_saveAndExit = CmsToolBar.createButton((Resource)FontOpenCms.SAVE_EXIT, messages.key("GUI_BUTTON_SAVE_AND_EXIT_0"), true);
        this.m_saveAndExit.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsSourceEditor.this.saveAndExit();
            }
        });
        this.m_saveAndExit.setEnabled(false);
        context.addToolbarButton((Component)this.m_saveAndExit);
        this.m_save = CmsToolBar.createButton((Resource)FontOpenCms.SAVE, messages.key("GUI_BUTTON_SAVE_0"), true);
        this.m_save.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsSourceEditor.this.save();
            }
        });
        this.m_save.setEnabled(false);
        context.addToolbarButton((Component)this.m_save);
        Button undo = CmsToolBar.createButton((Resource)FontOpenCms.UNDO, messages.key("GUI_BUTTON_UNDO_0"), true);
        context.addToolbarButton((Component)undo);
        Button redo = CmsToolBar.createButton((Resource)FontOpenCms.REDO, messages.key("GUI_BUTTON_REDO_0"), true);
        context.addToolbarButton((Component)redo);
        this.m_codeMirror.registerUndoRedo(undo, redo);
        Button search = CmsToolBar.createButton((Resource)FontOpenCms.SEARCH, messages.key("GUI_BUTTON_SEARCH_0"), true);
        context.addToolbarButton((Component)search);
        Button replace = CmsToolBar.createButton((Resource)FontOpenCms.SEARCH_REPLACE, messages.key("GUI_BUTTON_REPLACE_0"), true);
        context.addToolbarButton((Component)replace);
        this.m_codeMirror.registerSearchReplace(search, replace);
        try {
            settings = OpenCms.getWorkplaceAppManager().getAppSettings(A_CmsUI.getCmsObject(), EditorSettings.class);
        }
        catch (Exception e) {
            settings = new EditorSettings();
        }
        Button toggleHighlight = CmsToolBar.createButton((Resource)FontOpenCms.HIGHLIGHT, messages.key("GUI_BUTTON_TOGGLE_HIGHLIGHTING_0"));
        toggleHighlight.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                Button b = event.getButton();
                boolean pressed = b.getStyleName().contains("o-button-pressed");
                if (pressed) {
                    b.removeStyleName("o-button-pressed");
                } else {
                    b.addStyleName("o-button-pressed");
                }
                CmsSourceEditor.this.m_codeMirror.setHighlighting(!pressed);
            }
        });
        if (settings.m_highlighting) {
            this.m_codeMirror.setHighlighting(true);
            toggleHighlight.addStyleName("o-button-pressed");
        } else {
            this.m_codeMirror.setHighlighting(false);
        }
        context.addToolbarButtonRight((Component)toggleHighlight);
        Button toggleLineWrap = CmsToolBar.createButton((Resource)FontOpenCms.WRAP_LINES, messages.key("GUI_BUTTON_TOGGLE_LINE_WRAPPING_0"));
        toggleLineWrap.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                Button b = event.getButton();
                boolean pressed = b.getStyleName().contains("o-button-pressed");
                if (pressed) {
                    b.removeStyleName("o-button-pressed");
                } else {
                    b.addStyleName("o-button-pressed");
                }
                CmsSourceEditor.this.m_codeMirror.setLineWrapping(!pressed);
            }
        });
        if (settings.m_lineWrapping) {
            this.m_codeMirror.setLineWrapping(true);
            toggleLineWrap.addStyleName("o-button-pressed");
        } else {
            this.m_codeMirror.setLineWrapping(false);
        }
        context.addToolbarButtonRight((Component)toggleLineWrap);
        Button toggleBrackets = CmsToolBar.createButton((Resource)FontOpenCms.BRACKETS, messages.key("GUI_BUTTON_TOBBLE_BRACKET_AUTOCLOSE_0"));
        toggleBrackets.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                Button b = event.getButton();
                boolean pressed = b.getStyleName().contains("o-button-pressed");
                if (pressed) {
                    b.removeStyleName("o-button-pressed");
                } else {
                    b.addStyleName("o-button-pressed");
                }
                CmsSourceEditor.this.m_codeMirror.setCloseBrackets(!pressed);
            }
        });
        if (settings.m_closeBrackets) {
            this.m_codeMirror.setCloseBrackets(true);
            toggleBrackets.addStyleName("o-button-pressed");
        } else {
            this.m_codeMirror.setCloseBrackets(false);
        }
        context.addToolbarButtonRight((Component)toggleBrackets);
        Button toggleTabs = CmsToolBar.createButton((Resource)FontOpenCms.INVISIBLE_CHARS, messages.key("GUI_BUTTON_TOGGLE_TAB_VISIBILITY_0"));
        toggleTabs.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                Button b = event.getButton();
                boolean pressed = b.getStyleName().contains("o-button-pressed");
                if (pressed) {
                    b.removeStyleName("o-button-pressed");
                } else {
                    b.addStyleName("o-button-pressed");
                }
                CmsSourceEditor.this.m_codeMirror.setTabsVisible(!pressed);
            }
        });
        if (settings.m_tabsVisible) {
            this.m_codeMirror.setTabsVisible(true);
            toggleTabs.addStyleName("o-button-pressed");
        } else {
            this.m_codeMirror.setTabsVisible(false);
        }
        context.addToolbarButtonRight((Component)toggleTabs);
        ComboBox modeSelect = new ComboBox();
        modeSelect.setWidth("115px");
        modeSelect.addStyleName("o-toolbar-field");
        modeSelect.addStyleName("o-required-button");
        modeSelect.setNullSelectionAllowed(false);
        modeSelect.setImmediate(true);
        modeSelect.setNewItemsAllowed(false);
        for (CmsCodeMirror.CodeMirrorLanguage lang : CmsCodeMirror.CodeMirrorLanguage.values()) {
            modeSelect.addItem((Object)lang);
            modeSelect.setItemCaption((Object)lang, lang.name());
        }
        CmsCodeMirror.CodeMirrorLanguage lang = this.getHighlightMode(resource);
        modeSelect.setValue((Object)lang);
        this.m_codeMirror.setLanguage(lang);
        modeSelect.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsSourceEditor.this.m_codeMirror.setLanguage((CmsCodeMirror.CodeMirrorLanguage)((Object)event.getProperty().getValue()));
            }
        });
        context.addToolbarButtonRight((Component)modeSelect);
        ComboBox fontSizeSelect = new ComboBox();
        fontSizeSelect.setWidth("75px");
        fontSizeSelect.addStyleName("o-toolbar-field");
        fontSizeSelect.addStyleName("o-required-button");
        fontSizeSelect.setNullSelectionAllowed(false);
        fontSizeSelect.setImmediate(true);
        fontSizeSelect.setNewItemsAllowed(false);
        for (int i = 0; i < FONT_SIZES.length; ++i) {
            fontSizeSelect.addItem((Object)FONT_SIZES[i]);
        }
        fontSizeSelect.setValue((Object)settings.m_fontSize);
        fontSizeSelect.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsSourceEditor.this.m_codeMirror.setFontSize((String)event.getProperty().getValue());
            }
        });
        context.addToolbarButtonRight((Component)fontSizeSelect);
        this.m_codeMirror.setFontSize(settings.m_fontSize);
        this.m_exit = CmsToolBar.createButton((Resource)FontOpenCms.EXIT, messages.key("GUI_BUTTON_CANCEL_0"), true);
        this.m_exit.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsSourceEditor.this.exit();
            }
        });
        context.addToolbarButtonRight((Component)this.m_exit);
        try {
            this.m_file = CmsLockUtil.LockedFile.lockResource(A_CmsUI.getCmsObject(), resource);
            String content = new String(this.m_file.getFile().getContents(), this.m_file.getEncoding());
            this.m_codeMirror.setValue(content);
        }
        catch (Exception e) {
            CmsErrorDialog.showErrorDialog(e);
        }
        this.m_codeMirror.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsSourceEditor.this.onChange((String)event.getProperty().getValue());
            }
        });
    }

    @Override
    public boolean matchesResource(CmsObject cms, CmsResource resource, boolean plainText) {
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(resource);
        return this.matchesType(type, plainText);
    }

    @Override
    public boolean matchesType(I_CmsResourceType type, boolean plainText) {
        return !(type instanceof CmsResourceTypeBinary) && !(type instanceof CmsResourceTypeImage);
    }

    @Override
    public I_CmsEditor newInstance() {
        return new CmsSourceEditor();
    }

    @Override
    public void onWindowClose() {
        this.clear();
    }

    void clear() {
        this.m_cleared = true;
        this.m_changed = false;
        this.m_file.tryUnlock();
        OpenCms.getWorkplaceAppManager().storeAppSettings(A_CmsUI.getCmsObject(), EditorSettings.class, this.getCurrentSettings());
    }

    void exit() {
        if (this.m_changed) {
            CmsConfirmationDialog.show(CmsVaadinUtils.getMessageText("GUI_EDITOR_CLOSE_CAPTION_0", new Object[0]), CmsVaadinUtils.getMessageText("GUI_EDITOR_CLOSE_TEXT_0", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    CmsSourceEditor.this.exitInternal();
                }
            });
        } else {
            this.exitInternal();
        }
    }

    void exitInternal() {
        this.clear();
        CmsEditor.openBackLink(this.m_backLink);
    }

    void onChange(String value) {
        this.m_changed = true;
        this.m_save.setEnabled(true);
        this.m_saveAndExit.setEnabled(true);
    }

    void save() {
        CmsObject cms = A_CmsUI.getCmsObject();
        try {
            byte[] content = this.m_codeMirror.getValue().getBytes(this.m_file.getEncoding());
            this.m_file.getFile().setContents(content);
            cms.getRequestContext().setAttribute(CmsXmlContent.AUTO_CORRECTION_ATTRIBUTE, Boolean.TRUE);
            cms.writeFile(this.m_file.getFile());
            this.m_changed = false;
            this.m_save.setEnabled(false);
            this.m_saveAndExit.setEnabled(false);
        }
        catch (Exception e) {
            CmsErrorDialog.showErrorDialog(e);
        }
        finally {
            cms.getRequestContext().removeAttribute(CmsXmlContent.AUTO_CORRECTION_ATTRIBUTE);
        }
    }

    void saveAndExit() {
        this.save();
        this.exit();
    }

    private EditorSettings getCurrentSettings() {
        EditorSettings result = new EditorSettings();
        result.m_closeBrackets = this.m_codeMirror.isCloseBrackets();
        result.m_lineWrapping = this.m_codeMirror.isLineWrapping();
        result.m_highlighting = this.m_codeMirror.isHighlighting();
        result.m_tabsVisible = this.m_codeMirror.isTabsVisible();
        result.m_fontSize = this.m_codeMirror.getFontSize();
        return result;
    }

    public static class EditorSettings
    implements I_CmsAppSettings {
        private static final String BRACKETS = "brackets";
        private static final String FONTSIZE = "fontsize";
        private static final String HIGHLIGHTING = "highlighting";
        private static final String TABS = "tabs";
        private static final String WRAPPING = "wrapping";
        boolean m_closeBrackets = true;
        String m_fontSize = "16px";
        boolean m_highlighting = true;
        boolean m_lineWrapping;
        boolean m_tabsVisible = true;

        public String getFontSize() {
            return this.m_fontSize;
        }

        @Override
        public String getSettingsString() {
            JSONObject json = new JSONObject();
            try {
                json.put(BRACKETS, this.m_closeBrackets);
                json.put(HIGHLIGHTING, this.m_highlighting);
                json.put(WRAPPING, this.m_lineWrapping);
                json.put(FONTSIZE, this.m_fontSize);
                json.put(TABS, this.m_tabsVisible);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return json.toString();
        }

        public boolean isCloseBracketsActive() {
            return this.m_closeBrackets;
        }

        public boolean isHighlightingActive() {
            return this.m_highlighting;
        }

        public boolean isLineWrappingActive() {
            return this.m_lineWrapping;
        }

        public boolean isTabsVisibleActive() {
            return this.m_tabsVisible;
        }

        @Override
        public void restoreSettings(String storedSettings) {
            try {
                JSONObject json = new JSONObject(storedSettings);
                if (json.has(BRACKETS)) {
                    this.m_closeBrackets = json.getBoolean(BRACKETS);
                }
                if (json.has(HIGHLIGHTING)) {
                    this.m_highlighting = json.getBoolean(HIGHLIGHTING);
                }
                if (json.has(WRAPPING)) {
                    this.m_lineWrapping = json.getBoolean(WRAPPING);
                }
                if (json.has(TABS)) {
                    this.m_tabsVisible = json.getBoolean(TABS);
                }
                if (json.has(FONTSIZE)) {
                    this.m_fontSize = json.getString(FONTSIZE);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }
}

