/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs.permissions;

import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.filter.Or;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.Table;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.ui.dialogs.permissions.CmsPrincipalSelectDialog;
import org.opencms.util.CmsStringUtil;

public class CmsPrincipalTable
extends Table {
    private static final long serialVersionUID = -6291109098461446195L;
    private static String PROP_CAPTION;
    private static String PROP_ICON;
    private static String PROP_OU;
    private static String PROP_DESCRIPTION;
    private IndexedContainer m_container;

    public CmsPrincipalTable(final CmsPrincipalSelectDialog dialog, IndexedContainer container, String iconProp, String captionProp, String descProp, String ouProp) {
        this.setHeight("500px");
        this.m_container = container;
        PROP_CAPTION = captionProp;
        PROP_DESCRIPTION = descProp;
        PROP_ICON = iconProp;
        PROP_OU = ouProp;
        this.setContainerDataSource((Container)this.m_container);
        this.setItemIconPropertyId(iconProp);
        this.setColumnWidth(null, 40);
        this.setColumnWidth(ouProp, 300);
        this.setSelectable(true);
        this.setWidth("100%");
        this.setRowHeaderMode(Table.RowHeaderMode.ICON_ONLY);
        this.setVisibleColumns(new Object[]{PROP_CAPTION, PROP_DESCRIPTION, PROP_OU});
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){
            private static final long serialVersionUID = -4593704069277393664L;

            public void itemClick(ItemClickEvent event) {
                dialog.select((I_CmsPrincipal)event.getItemId());
            }
        });
    }

    public void updateContainer(IndexedContainer data) {
        this.m_container.removeAllItems();
        this.m_container = data;
        this.setContainerDataSource((Container)this.m_container);
        this.setItemIconPropertyId(PROP_ICON);
        this.setRowHeaderMode(Table.RowHeaderMode.ICON_ONLY);
        this.setVisibleColumns(new Object[]{PROP_CAPTION, PROP_DESCRIPTION, PROP_OU});
        this.setColumnWidth(null, 40);
        this.refreshRowCache();
    }

    protected void filterTable(String search) {
        this.m_container.removeAllContainerFilters();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(search)) {
            this.m_container.addContainerFilter((Container.Filter)new Or(new Container.Filter[]{new SimpleStringFilter((Object)PROP_CAPTION, search, true, false), new SimpleStringFilter((Object)PROP_DESCRIPTION, search, true, false)}));
        }
    }
}

