/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs.permissions;

import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.DefaultFieldFactory;
import com.vaadin.v7.ui.Field;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.TableFieldFactory;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.history.CmsHistoryPrincipal;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsPrincipal;
import org.opencms.security.CmsRole;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.dialogs.permissions.CmsPermissionBean;
import org.opencms.ui.dialogs.permissions.CmsPermissionDialog;
import org.opencms.workplace.commons.Messages;

public class CmsPermissionView
extends CssLayout {
    private static final Log LOG = CmsLog.getLog(CmsPermissionView.class);
    private static final String PROPERTY_ALLOWED = "allowed";
    private static final String PROPERTY_DENIED = "denied";
    private static final String PROPERTY_DISPLAY_ALLOWED = "display_allowed";
    private static final String PROPERTY_DISPLAY_DENIED = "display_denied";
    private static final String PROPERTY_LABEL = "label";
    private static final String PROPERTY_VALUE = "value";
    private static final long serialVersionUID = 3440901877277200393L;
    private static final String UNKNOWN_TYPE = "Unknown";
    final Property.ValueChangeListener m_valueChangeListener = new Property.ValueChangeListener(){
        private static final long serialVersionUID = 3923093753370151014L;

        public void valueChange(Property.ValueChangeEvent event) {
            CmsPermissionView.this.setPermissions();
        }
    };
    private VerticalLayout m_buttonBar;
    private PermissionChangeHandler m_changeHandler;
    private boolean m_editable;
    private CmsAccessControlEntry m_entry;
    private final TableFieldFactory m_fieldFactory = new DefaultFieldFactory(){
        private static final long serialVersionUID = 1L;

        public Field<?> createField(Container container, Object itemId, Object propertyId, Component uiContext) {
            Field result = null;
            if (CmsPermissionView.PROPERTY_ALLOWED.equals(propertyId) || CmsPermissionView.PROPERTY_DENIED.equals(propertyId)) {
                result = super.createField(container, itemId, propertyId, uiContext);
                result.addValueChangeListener(CmsPermissionView.this.m_valueChangeListener);
                result.setCaption("");
            }
            return result;
        }
    };
    private CheckBox m_inheritCheckbox;
    private CheckBox m_overwriteCheckbox;
    private Table m_permissions;
    private String m_principalName;
    private String m_principalType;
    private CheckBox m_responsibleCheckbox;

    public CmsPermissionView(CmsAccessControlEntry entry, boolean editable, boolean isFolder, String inheritedFrom, PermissionChangeHandler changeHandler) {
        I_CmsPrincipal principal;
        this.m_changeHandler = changeHandler;
        this.m_editable = editable;
        this.m_entry = entry;
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        CmsObject cms = A_CmsUI.getCmsObject();
        this.m_responsibleCheckbox.addValueChangeListener(this.m_valueChangeListener);
        this.m_overwriteCheckbox.addValueChangeListener(this.m_valueChangeListener);
        this.m_inheritCheckbox.addValueChangeListener(this.m_valueChangeListener);
        try {
            principal = CmsPrincipal.readPrincipalIncludingHistory(cms, entry.getPrincipal());
        }
        catch (CmsException e) {
            principal = null;
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        this.m_principalName = principal != null ? principal.getName() : entry.getPrincipal().toString();
        int flags = 0;
        if (principal != null && principal instanceof CmsHistoryPrincipal) {
            flags = principal.isGroup() ? 32 : 16;
        } else if (principal != null && principal.isGroup()) {
            flags = 32;
        } else if (principal != null && principal.isUser()) {
            flags = 16;
        } else if (this.m_principalName != null && this.m_principalName.equals(CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID.toString())) {
            this.m_principalName = "ALL_OTHERS";
            this.m_responsibleCheckbox.setVisible(false);
            flags = 128;
        } else if (this.m_principalName != null && this.m_principalName.equals(CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID.toString())) {
            this.m_principalName = "OVERWRITE_ALL";
            flags = 256;
        } else {
            CmsRole role = CmsRole.valueOfId(entry.getPrincipal());
            if (role != null) {
                this.m_principalName = role.getRoleName();
                flags = 512;
            }
        }
        if (flags > 0 && (entry.getFlags() & flags) == 0) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle(A_CmsUI.get().getLocale()).key("ERR_INVALID_ACE_1", entry.toString()));
            }
            entry = new CmsAccessControlEntry(entry.getResource(), entry.getPrincipal(), entry.getAllowedPermissions(), entry.getDeniedPermissions(), entry.getFlags() | flags);
        } else if (entry.getFlags() < 16) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle(A_CmsUI.get().getLocale()).key("ERR_INVALID_ACE_1", entry.toString()));
            }
            entry = new CmsAccessControlEntry(entry.getResource(), entry.getPrincipal(), entry.getAllowedPermissions(), entry.getDeniedPermissions(), entry.getFlags() | 0x20);
        }
        this.m_principalType = this.getEntryType(entry.getFlags(), false);
        if (this.m_principalName == null) {
            this.m_principalName = "";
        }
        boolean isOverwriteAll = false;
        if (flags == 256) {
            isOverwriteAll = true;
        }
        if (!isOverwriteAll) {
            CmsPermissionSet permissions = entry.getPermissions();
            IndexedContainer container = this.getPermissionContainer(permissions);
            this.m_permissions.setContainerDataSource((Container)container);
            this.m_permissions.setColumnReorderingAllowed(false);
            this.m_permissions.setColumnHeader((Object)PROPERTY_LABEL, CmsVaadinUtils.getMessageText("GUI_PERMISSION_0", new Object[0]));
            this.m_permissions.setColumnHeader((Object)PROPERTY_ALLOWED, CmsVaadinUtils.getMessageText("GUI_PERMISSION_ALLOWED_0", new Object[0]));
            this.m_permissions.setColumnHeader((Object)PROPERTY_DISPLAY_ALLOWED, CmsVaadinUtils.getMessageText("GUI_PERMISSION_ALLOWED_0", new Object[0]));
            this.m_permissions.setColumnHeader((Object)PROPERTY_DENIED, CmsVaadinUtils.getMessageText("GUI_PERMISSION_DENIED_0", new Object[0]));
            this.m_permissions.setColumnHeader((Object)PROPERTY_DISPLAY_DENIED, CmsVaadinUtils.getMessageText("GUI_PERMISSION_DENIED_0", new Object[0]));
            this.m_permissions.setPageLength(5);
            this.m_permissions.setSortEnabled(false);
            this.m_permissions.setVisible(true);
            if (this.m_editable) {
                this.m_permissions.setVisibleColumns(new Object[]{PROPERTY_LABEL, PROPERTY_ALLOWED, PROPERTY_DENIED});
                this.m_permissions.setTableFieldFactory(this.m_fieldFactory);
                this.m_permissions.setEditable(this.m_editable);
                this.m_responsibleCheckbox.setValue((Object)this.isResponsible(entry.getFlags()));
                this.m_overwriteCheckbox.setValue((Object)this.isOverWritingInherited(entry.getFlags()));
                this.m_inheritCheckbox.setVisible(isFolder);
                this.m_inheritCheckbox.setValue((Object)this.m_entry.isInheriting());
                this.m_buttonBar.setVisible(true);
            } else {
                this.m_permissions.setVisibleColumns(new Object[]{PROPERTY_LABEL, PROPERTY_DISPLAY_ALLOWED, PROPERTY_DISPLAY_DENIED});
            }
        }
    }

    public String getPrincipalName() {
        return this.m_principalName;
    }

    public void hideDeniedColumn() {
        if (this.m_editable) {
            this.m_permissions.setVisibleColumns(new Object[]{PROPERTY_LABEL, PROPERTY_ALLOWED});
        } else {
            this.m_permissions.setVisibleColumns(new Object[]{PROPERTY_LABEL, PROPERTY_DISPLAY_ALLOWED});
        }
    }

    public boolean isEditable() {
        return this.m_editable;
    }

    protected String getEntryType(int flags, boolean all) {
        for (int i = 0; i < this.getTypes(all).length; ++i) {
            if ((flags & this.getTypesInt()[i]) <= 0) continue;
            return this.getTypes(all)[i];
        }
        return UNKNOWN_TYPE;
    }

    protected String[] getTypes(boolean all) {
        if (!all) {
            String[] array = new String[3];
            return Arrays.asList(CmsPermissionDialog.PRINCIPAL_TYPES).subList(0, 3).toArray(array);
        }
        return CmsPermissionDialog.PRINCIPAL_TYPES;
    }

    protected int[] getTypesInt() {
        return CmsPermissionDialog.PRINCIPAL_TYPES_INT;
    }

    protected Boolean isAllowed(CmsPermissionSet p, int value) {
        if ((p.getAllowedPermissions() & value) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected Boolean isDenied(CmsPermissionSet p, int value) {
        if ((p.getDeniedPermissions() & value) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected Boolean isOverWritingInherited(int flags) {
        if ((flags & 4) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected Boolean isResponsible(int flags) {
        if ((flags & 0x40) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    void deletePermissionSet() {
        this.m_changeHandler.deletePermissionSet(this.m_principalType, this.m_principalName);
    }

    IndexedContainer getPermissionContainer(CmsPermissionSet permissions) {
        IndexedContainer result = new IndexedContainer();
        result.addContainerProperty((Object)PROPERTY_LABEL, String.class, (Object)"");
        result.addContainerProperty((Object)PROPERTY_VALUE, Integer.class, null);
        result.addContainerProperty((Object)PROPERTY_ALLOWED, Boolean.class, (Object)Boolean.FALSE);
        result.addContainerProperty((Object)PROPERTY_DISPLAY_ALLOWED, Label.class, null);
        result.addContainerProperty((Object)PROPERTY_DENIED, Boolean.class, (Object)Boolean.FALSE);
        result.addContainerProperty((Object)PROPERTY_DISPLAY_DENIED, Label.class, null);
        for (String key : CmsPermissionSet.getPermissionKeys()) {
            int flag = CmsPermissionSet.getPermissionValue(key);
            Item entry = result.addItem((Object)key);
            entry.getItemProperty((Object)PROPERTY_LABEL).setValue((Object)CmsVaadinUtils.getMessageText(key, new Object[0]));
            entry.getItemProperty((Object)PROPERTY_ALLOWED).setValue((Object)this.isAllowed(permissions, flag));
            entry.getItemProperty((Object)PROPERTY_DISPLAY_ALLOWED).setValue((Object)this.getCheckBoxLabel(this.isAllowed(permissions, flag)));
            entry.getItemProperty((Object)PROPERTY_DENIED).setValue((Object)this.isDenied(permissions, flag));
            entry.getItemProperty((Object)PROPERTY_DISPLAY_DENIED).setValue((Object)this.getCheckBoxLabel(this.isDenied(permissions, flag)));
            entry.getItemProperty((Object)PROPERTY_VALUE).setValue((Object)flag);
        }
        return result;
    }

    void setPermissions() {
        IndexedContainer container = (IndexedContainer)this.m_permissions.getContainerDataSource();
        int allowed = 0;
        int denied = 0;
        for (Object itemId : container.getItemIds()) {
            Item item = container.getItem(itemId);
            Integer value = (Integer)item.getItemProperty((Object)PROPERTY_VALUE).getValue();
            if (((Boolean)item.getItemProperty((Object)PROPERTY_ALLOWED).getValue()).booleanValue()) {
                allowed |= value.intValue();
            }
            if (!((Boolean)item.getItemProperty((Object)PROPERTY_DENIED).getValue()).booleanValue()) continue;
            denied |= value.intValue();
        }
        int flags = this.m_entry.getFlags();
        flags = ((Boolean)this.m_inheritCheckbox.getValue()).booleanValue() ? (flags |= 2) : (flags &= 0xFFFFFFFD);
        flags = ((Boolean)this.m_overwriteCheckbox.getValue()).booleanValue() ? (flags |= 4) : (flags &= 0xFFFFFFFB);
        flags = ((Boolean)this.m_responsibleCheckbox.getValue()).booleanValue() ? (flags |= 0x40) : (flags &= 0xFFFFFFBF);
        this.m_changeHandler.setPermissions(new CmsPermissionBean(this.m_principalType, this.m_principalName, allowed, denied, flags));
    }

    private Label getCheckBoxLabel(Boolean value) {
        String content = value != false ? "<input type='checkbox' disabled='true' checked='true' />" : "<input type='checkbox' disabled='true' />";
        return new Label(content, ContentMode.HTML);
    }

    public static interface PermissionChangeHandler {
        public void deletePermissionSet(String var1, String var2);

        public void onViewChange();

        public void setPermissions(CmsPermissionBean var1);
    }
}

