/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs.permissions;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.ui.BrowserFrame;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import java.io.Serializable;
import java.util.HashMap;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.security.CmsRole;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsBasicDialog;

public class CmsPermissionUserListDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = 1L;
    Button m_closeButton;
    BrowserFrame m_frame;

    public CmsPermissionUserListDialog(CmsObject cms, CmsGroup group) {
        this.init(this.getFrameUrlForGroup(group));
    }

    public CmsPermissionUserListDialog(CmsObject cms, CmsRole role) {
        this.init(this.getFrameUrlForRole(role));
    }

    private String getFrameUrlForGroup(CmsGroup group) {
        String id = String.valueOf(group.getId());
        String prefix = "g";
        if (0 != (group.getFlags() & 0x20000)) {
            prefix = "G";
        }
        String t = prefix + "!!" + group.getOuFqn() + "!!" + id + "!!";
        String target = CmsVaadinUtils.getWorkplaceLink("accounts") + "/" + t;
        return target;
    }

    private String getFrameUrlForRole(CmsRole role) {
        String id = String.valueOf(role.getId());
        String prefix = "r";
        String t = prefix + "!!!!" + id + "!!";
        String target = CmsVaadinUtils.getWorkplaceLink("accounts") + "/" + t;
        return target;
    }

    private void init(String target) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), new HashMap<String, String>());
        this.m_closeButton.addClickListener((Button.ClickListener & Serializable)event -> CmsVaadinUtils.closeWindow((Component)this));
        this.m_frame.setWidth("100%");
        int height = A_CmsUI.get().getPage().getBrowserWindowHeight();
        height = Math.max(200, height - 150);
        this.m_frame.setHeight(height + "px");
        this.m_frame.setSource((Resource)new ExternalResource(target));
    }
}

