/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs.permissions;

import java.util.Set;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsPrincipal;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsUUID;

public class CmsPermissionBean {
    private static final Log LOG = CmsLog.getLog(CmsPermissionBean.class);
    private String m_principalType;
    private String m_principalName;
    private int m_allowed;
    private int m_denied;
    private int m_flags;
    private String m_permissionString;
    private boolean m_delete;

    public CmsPermissionBean(String principalType, String principalName) {
        this.m_principalName = principalName;
        this.m_principalType = principalType;
        this.m_delete = true;
    }

    public CmsPermissionBean(String principalType, String principalName, int allowed, int denied, int flags) {
        this.m_principalName = principalName;
        this.m_principalType = principalType;
        this.m_allowed = allowed;
        this.m_denied = denied;
        this.m_flags = flags;
        this.m_delete = false;
    }

    public CmsPermissionBean(String principalType, String principalName, String permissionString) {
        this.m_principalName = principalName;
        this.m_principalType = principalType;
        this.m_permissionString = permissionString;
    }

    public static CmsPermissionBean getBeanForPrincipal(Set<CmsPermissionBean> beans, String principalName) {
        for (CmsPermissionBean bean : beans) {
            if (!bean.getPrincipalName().equals(principalName)) continue;
            return bean;
        }
        return null;
    }

    public static String getPrincipalNameFromACE(CmsObject cms, CmsAccessControlEntry entry) {
        if (entry.isAllOthers()) {
            return "ALL_OTHERS";
        }
        if (entry.isOverwriteAll()) {
            return "OVERWRITE_ALL";
        }
        CmsRole role = CmsRole.valueOfId(entry.getPrincipal());
        if (role != null) {
            return role.getRoleName();
        }
        try {
            return CmsPrincipal.readPrincipal(cms, entry.getPrincipal()).getName();
        }
        catch (CmsException cmsException) {
            return "";
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof CmsPermissionBean) && !(o instanceof String)) {
            return false;
        }
        if (o instanceof String) {
            return this.m_principalName.equals(o);
        }
        CmsPermissionBean bean = (CmsPermissionBean)o;
        return bean.getPrincipalName().equals(this.m_principalName) && bean.getPrincipalType().equals(this.m_principalType);
    }

    public int getAllowed() {
        return this.m_allowed;
    }

    public int getDenied() {
        return this.m_denied;
    }

    public int getFlags() {
        return this.m_flags;
    }

    public String getPermissionString() {
        return this.m_permissionString;
    }

    public String getPrincipalName() {
        return this.m_principalName;
    }

    public String getPrincipalType() {
        return this.m_principalType;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.m_principalName).toHashCode();
    }

    public boolean isDeleted() {
        return this.m_delete;
    }

    public boolean isRealPrinciple() {
        return !("ALL_OTHERS".equals(this.m_principalName) | "OVERWRITE_ALL".equals(this.m_principalName));
    }

    public void setFlags(int flags) {
        this.m_flags |= flags;
    }

    public CmsAccessControlEntry toAccessControlEntry(CmsObject cms, CmsUUID resID) {
        CmsUUID id = null;
        if (this.isRealPrinciple()) {
            if ("ROLE".equals(this.m_principalType)) {
                CmsRole role = CmsRole.valueOfRoleName(this.m_principalName);
                if (role != null) {
                    id = role.getId();
                }
            } else {
                try {
                    if ("GROUP".equals(this.m_principalType)) {
                        id = cms.readGroup(this.m_principalName).getId();
                    } else if ("USER".equals(this.m_principalType)) {
                        id = cms.readUser(this.m_principalName).getId();
                    }
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        } else {
            if (this.m_principalName.equals("ALL_OTHERS")) {
                id = CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID;
            }
            if (this.m_principalName.equals("OVERWRITE_ALL")) {
                id = CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID;
            }
        }
        if (id == null) {
            return null;
        }
        if (this.m_permissionString == null) {
            return new CmsAccessControlEntry(resID, id, this.m_allowed, this.m_denied, this.m_flags);
        }
        CmsAccessControlEntry entry = new CmsAccessControlEntry(resID, id, this.m_permissionString);
        return entry;
    }
}

