/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs.history;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Window;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.CmsVfsService;
import org.opencms.gwt.shared.CmsHistoryResourceBean;
import org.opencms.gwt.shared.CmsHistoryResourceCollection;
import org.opencms.gwt.shared.CmsHistoryVersion;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.I_CmsUpdateListener;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsConfirmationDialog;
import org.opencms.ui.components.extensions.CmsGwtDialogExtension;
import org.opencms.ui.dialogs.history.CmsHistoryRow;
import org.opencms.ui.dialogs.history.diff.CmsAttributeDiff;
import org.opencms.ui.dialogs.history.diff.CmsImageDiff;
import org.opencms.ui.dialogs.history.diff.CmsPropertyDiff;
import org.opencms.ui.dialogs.history.diff.CmsShowVersionButtons;
import org.opencms.ui.dialogs.history.diff.CmsTextDiff;
import org.opencms.ui.dialogs.history.diff.CmsValueDiff;
import org.opencms.ui.dialogs.history.diff.I_CmsDiffProvider;
import org.opencms.ui.util.CmsComponentField;
import org.opencms.ui.util.CmsLogicalCheckboxGroup;
import org.opencms.ui.util.table.CmsBeanTableBuilder;
import org.opencms.util.CmsUUID;

public class CmsHistoryDialog
extends CmsBasicDialog {
    private static final Log LOG = CmsLog.getLog(CmsHistoryDialog.class);
    private static final long serialVersionUID = 1L;
    protected I_CmsDialogContext m_context;
    private CmsComponentField<Button> m_compareButton = CmsComponentField.newInstance();
    private List<I_CmsDiffProvider> m_diffs = Arrays.asList(new CmsShowVersionButtons(), new CmsPropertyDiff(), new CmsAttributeDiff(), new CmsImageDiff(), new CmsTextDiff(), new CmsValueDiff());
    private CmsLogicalCheckboxGroup m_group1 = new CmsLogicalCheckboxGroup();
    private CmsLogicalCheckboxGroup m_group2 = new CmsLogicalCheckboxGroup();
    private VerticalLayout m_listContainer;
    private CmsResource m_resource;
    private CmsComponentField<CheckBox> m_selected1 = CmsComponentField.newInstance();
    private CmsComponentField<CheckBox> m_selected2 = CmsComponentField.newInstance();

    public CmsHistoryDialog(I_CmsDialogContext context) {
        this.m_context = context;
        this.m_resource = context.getResources().get(0);
        this.setWidth("100%");
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, OpenCms.getWorkplaceManager().getMessages(A_CmsUI.get().getLocale()), null);
        CmsResource resource = context.getResources().get(0);
        CmsVfsService vfsService = new CmsVfsService();
        vfsService.setCms(context.getCms());
        try {
            CmsHistoryResourceCollection historyList = vfsService.getResourceHistoryInternal(resource.getStructureId());
            Table historyTable = this.buildHistoryTable(historyList);
            historyTable.setWidth("100%");
            this.m_listContainer.setWidth("100%");
            Button compareButton = new Button(CmsVaadinUtils.getMessageText("GUI_HISTORY_DIALOG_COMPARE_0", new Object[0]));
            this.m_listContainer.addComponent((Component)compareButton);
            this.m_listContainer.setComponentAlignment((Component)compareButton, Alignment.MIDDLE_RIGHT);
            compareButton.addClickListener(new Button.ClickListener(){
                private static final long serialVersionUID = 1L;

                public void buttonClick(Button.ClickEvent event) {
                    try {
                        CmsHistoryDialog.this.tryCompare();
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        CmsHistoryDialog.this.m_context.error(e);
                    }
                }
            });
            this.m_compareButton.set(compareButton);
            this.m_group1.setChangeListener(new CmsLogicalCheckboxGroup.I_ChangeListener(){

                @Override
                public void onSelect(CheckBox box) {
                    CmsHistoryDialog.this.m_selected1.set(box);
                    CmsHistoryDialog.this.m_compareButton.get().setEnabled(CmsHistoryDialog.this.canCompare(CmsHistoryDialog.this.m_selected1.get(), CmsHistoryDialog.this.m_selected2.get()));
                }
            });
            this.m_group2.setChangeListener(new CmsLogicalCheckboxGroup.I_ChangeListener(){

                @Override
                public void onSelect(CheckBox box) {
                    CmsHistoryDialog.this.m_selected2.set(box);
                    CmsHistoryDialog.this.m_compareButton.get().setEnabled(CmsHistoryDialog.this.canCompare(CmsHistoryDialog.this.m_selected1.get(), CmsHistoryDialog.this.m_selected2.get()));
                }
            });
            this.m_compareButton.get().setEnabled(false);
            this.m_listContainer.addComponent((Component)historyTable);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        this.addButton((Component)this.createCloseButton());
        this.displayResourceInfo(this.m_context.getResources());
    }

    public static void openChildDialog(Component currentComponent, Component newView, String newCaption) {
        final Window window = CmsVaadinUtils.getWindow(currentComponent);
        final String oldCaption = window.getCaption();
        CmsBasicDialog dialog = new CmsBasicDialog();
        VerticalLayout vl = new VerticalLayout();
        dialog.setContent((Component)vl);
        Button backButton = new Button(CmsVaadinUtils.getMessageText("GUI_CHILD_DIALOG_GO_BACK_0", new Object[0]));
        HorizontalLayout buttonBar = new HorizontalLayout();
        buttonBar.addComponent((Component)backButton);
        buttonBar.setMargin(true);
        vl.addComponent((Component)buttonBar);
        vl.addComponent(newView);
        final Component oldContent = window.getContent();
        if (oldContent instanceof CmsBasicDialog) {
            List<CmsResource> infoResources = ((CmsBasicDialog)oldContent).getInfoResources();
            dialog.displayResourceInfo(infoResources);
            if (oldContent instanceof CmsHistoryDialog) {
                dialog.addButton((Component)((CmsHistoryDialog)oldContent).createCloseButton());
            }
        }
        backButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                window.setContent(oldContent);
                window.setCaption(oldCaption);
                window.center();
            }
        });
        window.setContent((Component)dialog);
        window.setCaption(newCaption);
        window.center();
    }

    public void actionRestore(final CmsObject cms, final CmsUUID structureId, final Integer version) {
        String title = CmsVaadinUtils.getMessageText("GUI_HISTORY_DIALOG_CONFIRM_RESTORE_TITLE_0", new Object[0]);
        String message = CmsVaadinUtils.getMessageText("GUI_HISTORY_DIALOG_CONFIRM_RESTORE_0", new Object[0]);
        CmsConfirmationDialog.show(title, message, new Runnable(){

            @Override
            public void run() {
                CmsVfsService svc = new CmsVfsService();
                svc.setCms(cms);
                try {
                    svc.restoreResource(structureId, version);
                    CmsHistoryDialog.this.m_context.finish(Arrays.asList(CmsHistoryDialog.this.m_resource.getStructureId()));
                }
                catch (CmsRpcException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    CmsHistoryDialog.this.m_context.error(e);
                }
            }
        });
    }

    public Button createCloseButton() {
        Button button = new Button(CmsVaadinUtils.getMessageText("GUI_BUTTON_CLOSE_DIALOG_0", new Object[0]));
        button.setWidth("150px");
        button.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsHistoryDialog.this.m_context.finish(Lists.newArrayList((Object[])new CmsUUID[]{CmsHistoryDialog.this.m_context.getResources().get(0).getStructureId()}));
            }
        });
        return button;
    }

    public void tryCompare() throws CmsException {
        CheckBox check2;
        CmsObject cms = A_CmsUI.getCmsObject();
        CheckBox check1 = this.m_group1.getSelected();
        if (!this.canCompare(check1, check2 = this.m_group2.getSelected())) {
            Notification.show((String)CmsVaadinUtils.getMessageText("GUI_HISTORY_DIALOG_SELECT_TWO_DIFFERENT_VERSIONS_0", new Object[0]));
        } else {
            CmsHistoryResourceBean bean1 = (CmsHistoryResourceBean)check1.getData();
            CmsHistoryResourceBean bean2 = (CmsHistoryResourceBean)check2.getData();
            VerticalLayout diffContainer = new VerticalLayout();
            diffContainer.setSpacing(true);
            for (I_CmsDiffProvider diff : this.m_diffs) {
                Optional<Component> optionalDiff = diff.diff(cms, bean1, bean2);
                if (!optionalDiff.isPresent()) continue;
                diffContainer.addComponent((Component)optionalDiff.get());
            }
            Panel panel = new Panel();
            panel.setSizeFull();
            diffContainer.setWidth("100%");
            diffContainer.setMargin(true);
            panel.addStyleName("borderless");
            panel.setContent((Component)diffContainer);
            CmsHistoryDialog.openChildDialog((Component)this, (Component)panel, CmsVaadinUtils.getMessageText("GUI_HISTORY_DIALOG_COMPARE_0", new Object[0]));
        }
    }

    private void actionPreview(CmsHistoryResourceBean bean) {
        CmsGwtDialogExtension ext = new CmsGwtDialogExtension(A_CmsUI.get(), new I_CmsUpdateListener<String>(){

            @Override
            public void onUpdate(List<String> updatedItems) {
            }
        });
        CmsHistoryVersion.OfflineOnline offOnline = null;
        if (bean.getVersion().isOffline()) {
            offOnline = CmsHistoryVersion.OfflineOnline.offline;
        }
        if (bean.getVersion().isOnline()) {
            offOnline = CmsHistoryVersion.OfflineOnline.online;
        }
        ext.showPreview(bean.getStructureId(), bean.getVersion().getVersionNumber(), offOnline);
    }

    private Table buildHistoryTable(CmsHistoryResourceCollection historyList) {
        final CmsObject cms = A_CmsUI.getCmsObject();
        try {
            CmsBeanTableBuilder<CmsHistoryRow> builder = CmsBeanTableBuilder.newInstance(CmsHistoryRow.class, A_CmsUI.get().getDisplayType().toString());
            ArrayList rows = Lists.newArrayList();
            Iterator<CmsHistoryResourceBean> iterator = historyList.getResources().iterator();
            while (iterator.hasNext()) {
                CmsHistoryResourceBean bean;
                final CmsHistoryResourceBean beanFinal = bean = iterator.next();
                final CmsUUID structureId = bean.getStructureId();
                CmsHistoryRow row = new CmsHistoryRow(bean);
                rows.add(row);
                this.m_group1.add(row.getCheckBoxV1());
                this.m_group2.add(row.getCheckBoxV2());
                final Integer version = bean.getVersion().getVersionNumber();
                if (version != null) {
                    row.getRestoreButton().addClickListener(new Button.ClickListener(){
                        private static final long serialVersionUID = 1L;

                        public void buttonClick(Button.ClickEvent event) {
                            CmsHistoryDialog.this.actionRestore(cms, structureId, version);
                        }
                    });
                }
                row.getPreviewButton().addClickListener(new Button.ClickListener(){
                    private static final long serialVersionUID = 1L;

                    public void buttonClick(Button.ClickEvent event) {
                        CmsHistoryDialog.this.actionPreview(beanFinal);
                    }
                });
                for (CheckBox checkBox : Arrays.asList(row.getCheckBoxV1(), row.getCheckBoxV2())) {
                    checkBox.setData((Object)bean);
                }
            }
            Table result = builder.buildTable(rows);
            result.setPageLength(Math.min(rows.size(), 12));
            result.setSortEnabled(false);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean canCompare(CheckBox check1, CheckBox check2) {
        return check1 != null && check2 != null && check1.getData() != check2.getData();
    }
}

