/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs.availability;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.shared.CmsPrincipalBean;
import org.opencms.loader.CmsLoaderException;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockException;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsDateField;
import org.opencms.ui.components.CmsOkCancelActionHandler;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.ui.dialogs.availability.CmsAvailabilityInfoBean;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;

public class CmsAvailabilityDialog
extends CmsBasicDialog {
    public static final String PREF_AVAILABILITY_INCLUDE_CHILDREN_DEFAULT = "availabilityIncludeChildrenDefault";
    private static final Log LOG = CmsLog.getLog(CmsAvailabilityDialog.class);
    private static final long serialVersionUID = 1L;
    private CmsAvailabilityInfoBean m_availabilityInfo;
    private Button m_cancelButton;
    private I_CmsDialogContext m_dialogContext;
    private CmsDateField m_expiredField;
    private Boolean m_initialNotificationEnabled = Boolean.FALSE;
    private String m_initialNotificationInterval = "";
    private CheckBox m_modifySiblingsField;
    private CheckBox m_notificationEnabledField;
    private TextField m_notificationIntervalField;
    private Panel m_notificationPanel;
    private Button m_okButton;
    private CmsDateField m_releasedField;
    private CheckBox m_resetExpired;
    private CheckBox m_resetReleased;
    private VerticalLayout m_responsiblesContainer;
    private Panel m_responsiblesPanel;
    private CheckBox m_subresourceModificationField;

    public CmsAvailabilityDialog(I_CmsDialogContext dialogContext) {
        this.m_dialogContext = dialogContext;
        CmsObject cms = dialogContext.getCms();
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, OpenCms.getWorkplaceManager().getMessages(A_CmsUI.get().getLocale()), null);
        List<CmsResource> resources = dialogContext.getResources();
        this.m_notificationIntervalField.addValidator(new Validator(){
            private static final long serialVersionUID = 1L;

            public void validate(Object value) throws Validator.InvalidValueException {
                String strValue = ((String)value).trim();
                if (!strValue.matches("[0-9]*")) {
                    throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_VALIDATOR_EMPTY_OR_NUMBER_0", new Object[0]));
                }
            }
        });
        boolean hasSiblings = false;
        for (CmsResource resource : this.m_dialogContext.getResources()) {
            if (hasSiblings |= resource.getSiblingCount() > 1) break;
        }
        this.m_modifySiblingsField.setVisible(hasSiblings);
        if (resources.size() == 1) {
            CmsResource onlyResource = resources.get(0);
            if (onlyResource.getDateReleased() != 0L) {
                this.m_releasedField.setDate(new Date(onlyResource.getDateReleased()));
            }
            if (onlyResource.getDateExpired() != Long.MAX_VALUE) {
                this.m_expiredField.setDate(new Date(onlyResource.getDateExpired()));
            }
            this.initNotification();
            Iterator<CmsResource> responsibles = this.m_availabilityInfo.getResponsibles();
            if (!responsibles.isEmpty()) {
                this.m_responsiblesPanel.setVisible(true);
                this.m_notificationPanel.setVisible(true);
                for (Map.Entry entry : responsibles.entrySet()) {
                    CmsPrincipalBean principal = (CmsPrincipalBean)entry.getKey();
                    String icon = principal.isGroup() ? CmsWorkplace.getResourceUri("buttons/group.png") : CmsWorkplace.getResourceUri("buttons/user.png");
                    String subtitle = "";
                    if (entry.getValue() != null) {
                        subtitle = cms.getRequestContext().removeSiteRoot((String)entry.getValue());
                    }
                    CmsResourceInfo infoWidget = new CmsResourceInfo(((CmsPrincipalBean)entry.getKey()).getName(), subtitle, icon);
                    this.m_responsiblesContainer.addComponent((Component)infoWidget);
                }
            }
        } else {
            boolean showNotification = false;
            block4: for (CmsResource resource : resources) {
                try {
                    List<CmsAccessControlEntry> aces = cms.getAccessControlEntries(cms.getSitePath(resource));
                    for (CmsAccessControlEntry ace : aces) {
                        if (!ace.isResponsible()) continue;
                        showNotification = true;
                        break block4;
                    }
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            this.m_notificationPanel.setVisible(showNotification);
        }
        this.m_notificationEnabledField.setValue((Object)this.m_initialNotificationEnabled);
        this.m_notificationIntervalField.setValue(this.m_initialNotificationInterval);
        boolean hasFolders = false;
        for (CmsResource resource : resources) {
            if (!resource.isFolder()) continue;
            hasFolders = true;
        }
        CmsWorkplaceSettings wpSettings = A_CmsUI.get().getWorkplaceSettings();
        boolean includeChildren = Boolean.parseBoolean(wpSettings.getUserSettings().getAdditionalPreference(PREF_AVAILABILITY_INCLUDE_CHILDREN_DEFAULT, true));
        this.m_subresourceModificationField.setVisible(hasFolders);
        this.m_subresourceModificationField.setValue((Object)includeChildren);
        this.initResetCheckbox(this.m_resetReleased, this.m_releasedField);
        this.initResetCheckbox(this.m_resetExpired, this.m_expiredField);
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsAvailabilityDialog.this.submit();
            }
        });
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsAvailabilityDialog.this.cancel();
            }
        });
        this.displayResourceInfo(this.m_dialogContext.getResources());
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                CmsAvailabilityDialog.this.cancel();
            }

            @Override
            protected void ok() {
                CmsAvailabilityDialog.this.submit();
            }
        });
    }

    public void initNotification() {
        if (this.m_dialogContext.getResources().size() == 1) {
            CmsResource resource = this.m_dialogContext.getResources().get(0);
            try {
                this.m_availabilityInfo = this.getAvailabilityInfo(A_CmsUI.getCmsObject(), resource);
                this.m_initialNotificationInterval = "" + this.m_availabilityInfo.getNotificationInterval();
                this.m_initialNotificationEnabled = this.m_availabilityInfo.isNotificationEnabled();
            }
            catch (CmsLoaderException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected List<CmsUUID> changeAvailability() throws CmsException {
        Date released = this.m_releasedField.getDate();
        Date expired = this.m_expiredField.getDate();
        boolean resetReleased = (Boolean)this.m_resetReleased.getValue();
        boolean resetExpired = (Boolean)this.m_resetExpired.getValue();
        boolean modifySubresources = (Boolean)this.m_subresourceModificationField.getValue();
        ArrayList<CmsUUID> changedIds = new ArrayList<CmsUUID>();
        for (CmsResource resource : this.m_dialogContext.getResources()) {
            this.changeAvailability(resource, released, resetReleased, expired, resetExpired, modifySubresources);
            changedIds.add(resource.getStructureId());
        }
        String notificationInterval = ((String)this.m_notificationIntervalField.getValue()).trim();
        int notificationIntervalInt = 0;
        try {
            notificationIntervalInt = Integer.parseInt(notificationInterval);
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        Boolean notificationEnabled = (Boolean)this.m_notificationEnabledField.getValue();
        boolean notificationSettingsUnchanged = notificationInterval.equals(this.m_initialNotificationInterval) && notificationEnabled.equals(this.m_initialNotificationEnabled);
        CmsObject cms = A_CmsUI.getCmsObject();
        if (!notificationSettingsUnchanged) {
            for (CmsResource resource : this.m_dialogContext.getResources()) {
                this.performSingleResourceNotification(A_CmsUI.getCmsObject(), cms.getSitePath(resource), notificationEnabled, notificationIntervalInt, (Boolean)this.m_modifySiblingsField.getValue());
            }
        }
        return changedIds;
    }

    void cancel() {
        this.m_dialogContext.finish(new ArrayList<CmsUUID>());
    }

    CmsAvailabilityInfoBean getAvailabilityInfo(CmsObject cms, CmsResource res) throws CmsException {
        String notificationEnabled;
        CmsAvailabilityInfoBean result = new CmsAvailabilityInfoBean();
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(res.getTypeId());
        result.setResType(type.getTypeName());
        result.setDateReleased(res.getDateReleased());
        result.setDateExpired(res.getDateExpired());
        String notificationInterval = cms.readPropertyObject(res, "notification-interval", false).getValue();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(notificationInterval)) {
            result.setNotificationInterval(Integer.valueOf(notificationInterval));
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(notificationEnabled = cms.readPropertyObject(res, "enable-notification", false).getValue())) {
            result.setNotificationEnabled(Boolean.valueOf(notificationEnabled));
        }
        result.setHasSiblings(cms.readSiblings(res, CmsResourceFilter.ALL).size() > 1);
        result.setResponsibles(this.getResponsibles(cms, res));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<CmsPrincipalBean, String> getResponsibles(CmsObject cms, CmsResource res) {
        HashMap<CmsPrincipalBean, String> result = new HashMap<CmsPrincipalBean, String>();
        List<Object> parentResources = new ArrayList();
        try {
            parentResources = cms.readPath(res, CmsResourceFilter.IGNORE_EXPIRATION);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        for (CmsResource cmsResource : parentResources) {
            String storedSiteRoot = cms.getRequestContext().getSiteRoot();
            String sitePath = cms.getRequestContext().removeSiteRoot(cmsResource.getRootPath());
            try {
                cms.getRequestContext().setSiteRoot("/");
                List<CmsAccessControlEntry> entries = cms.getAccessControlEntries(cmsResource.getRootPath(), false);
                for (CmsAccessControlEntry ace : entries) {
                    I_CmsPrincipal principal;
                    if (!ace.isResponsible() || (principal = cms.lookupPrincipal(ace.getPrincipal())) == null) continue;
                    CmsPrincipalBean prinBean = new CmsPrincipalBean(principal.getName(), principal.getDescription(), principal.isGroup());
                    if (!cmsResource.getRootPath().equals(res.getRootPath())) {
                        if (cmsResource.getRootPath().startsWith(storedSiteRoot)) {
                            result.put(prinBean, sitePath);
                            continue;
                        }
                        result.put(prinBean, cmsResource.getRootPath());
                        continue;
                    }
                    result.put(prinBean, null);
                }
            }
            catch (CmsException e) {
                LOG.info((Object)("Problem with reading responsible users for " + cmsResource.getName() + " : " + e.getLocalizedMessage()), (Throwable)e);
            }
            finally {
                cms.getRequestContext().setSiteRoot(storedSiteRoot);
            }
        }
        return result;
    }

    void submit() {
        try {
            this.m_dialogContext.finish(this.changeAvailability());
        }
        catch (Throwable t) {
            this.m_dialogContext.error(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeAvailability(CmsResource resource, Date released, boolean resetReleased, Date expired, boolean resetExpired, boolean modifySubresources) throws CmsException {
        CmsObject cms = this.m_dialogContext.getCms();
        CmsLockActionRecord lockActionRecord = CmsLockUtil.ensureLock(cms, resource);
        try {
            cms.getRequestContext().setAttribute("REVERSE_AVAILABILITY_MAPPING", Boolean.TRUE);
            if (resetReleased || released != null) {
                long newDateReleased = released != null ? released.getTime() : 0L;
                cms.setDateReleased(resource, newDateReleased, modifySubresources);
            }
            if (resetExpired || expired != null) {
                long newDateExpired = expired != null ? expired.getTime() : Long.MAX_VALUE;
                cms.setDateExpired(resource, newDateExpired, modifySubresources);
            }
        }
        finally {
            cms.getRequestContext().removeAttribute("REVERSE_AVAILABILITY_MAPPING");
            if (lockActionRecord.getChange() == CmsLockActionRecord.LockChange.locked) {
                try {
                    cms.unlockResource(resource);
                }
                catch (CmsLockException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    private void initResetCheckbox(CheckBox box, final CmsDateField field) {
        box.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                Boolean value = (Boolean)event.getProperty().getValue();
                if (value.booleanValue()) {
                    field.clear();
                    field.setEnabled(false);
                } else {
                    field.setEnabled(true);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSingleResourceNotification(CmsObject cms, String resName, boolean enableNotification, int notificationInterval, boolean modifySiblings) throws CmsException {
        List<Object> resources = new ArrayList<CmsResource>();
        if (modifySiblings) {
            resources = cms.readSiblings(resName, CmsResourceFilter.IGNORE_EXPIRATION);
        } else {
            resources.add(cms.readResource(resName, CmsResourceFilter.IGNORE_EXPIRATION));
        }
        for (CmsResource cmsResource : resources) {
            CmsLockActionRecord lockRecord = CmsLockUtil.ensureLock(cms, cmsResource);
            try {
                this.writeProperty(cms, cmsResource, "notification-interval", String.valueOf(notificationInterval));
                this.writeProperty(cms, cmsResource, "enable-notification", String.valueOf(enableNotification));
            }
            finally {
                if (lockRecord.getChange() != CmsLockActionRecord.LockChange.locked) continue;
                cms.unlockResource(cmsResource);
            }
        }
    }

    private void writeProperty(CmsObject cms, CmsResource resource, String propertyName, String propertyValue) throws CmsException {
        if (CmsStringUtil.isEmpty(propertyValue)) {
            propertyValue = "";
        }
        CmsProperty newProp = new CmsProperty();
        newProp.setName(propertyName);
        CmsProperty oldProp = cms.readPropertyObject(resource, propertyName, false);
        if (oldProp.isNullProperty()) {
            if (OpenCms.getWorkplaceManager().isDefaultPropertiesOnStructure()) {
                newProp.setStructureValue(propertyValue);
            } else {
                newProp.setResourceValue(propertyValue);
            }
        } else if (oldProp.getStructureValue() != null) {
            newProp.setStructureValue(propertyValue);
            newProp.setResourceValue(oldProp.getResourceValue());
        } else {
            newProp.setResourceValue(propertyValue);
        }
        newProp.setAutoCreatePropertyDefinition(true);
        String oldStructureValue = oldProp.getStructureValue();
        String newStructureValue = newProp.getStructureValue();
        if (CmsStringUtil.isEmpty(oldStructureValue)) {
            oldStructureValue = "";
        }
        if (CmsStringUtil.isEmpty(newStructureValue)) {
            newStructureValue = "";
        }
        String oldResourceValue = oldProp.getResourceValue();
        String newResourceValue = newProp.getResourceValue();
        if (CmsStringUtil.isEmpty(oldResourceValue)) {
            oldResourceValue = "";
        }
        if (CmsStringUtil.isEmpty(newResourceValue)) {
            newResourceValue = "";
        }
        if (!oldResourceValue.equals(newResourceValue) || !oldStructureValue.equals(newStructureValue)) {
            cms.writePropertyObjects(resource, Collections.singletonList(newProp));
        }
    }
}

