/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.vaadin.data.HasValue;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.server.Page;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.ItemCaptionGenerator;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.gwt.CmsCoreService;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsExtendedSiteSelector;
import org.opencms.ui.components.CmsOkCancelActionHandler;
import org.opencms.ui.dialogs.CmsEmbeddedDialogContext;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsSiteSelectDialog
extends CmsBasicDialog {
    static final Log LOG = CmsLog.getLog(CmsSiteSelectDialog.class);
    private static final long serialVersionUID = 4455901453008760434L;
    private Button m_cancelButton;
    private I_CmsDialogContext m_context;
    private CmsExtendedSiteSelector m_siteComboBox;
    private ComboBox<CmsUUID> m_projectSelector;

    public CmsSiteSelectDialog(CmsEmbeddedDialogContext context) {
        this.m_context = context;
        this.setContent((Component)this.initForm());
        this.m_cancelButton = this.createButtonCancel();
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsSiteSelectDialog.this.cancel();
            }
        });
        this.addButton((Component)this.m_cancelButton);
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                CmsSiteSelectDialog.this.cancel();
            }

            @Override
            protected void ok() {
                CmsSiteSelectDialog.this.changeSite();
            }
        });
    }

    public static void changeSite(CmsEmbeddedDialogContext context, CmsExtendedSiteSelector.SiteSelectorOption option) {
        if (option.getPath() != null || !CmsStringUtil.comparePaths(context.getCms().getRequestContext().getSiteRoot(), option.getSite())) {
            String siteRoot = option.getSite();
            A_CmsUI.get().changeSite(option.getSite());
            if (CmsStringUtil.comparePaths(siteRoot, "/") || OpenCms.getSiteManager().isSharedFolder(siteRoot)) {
                Page.getCurrent().open(CmsCoreService.getFileExplorerLink(A_CmsUI.getCmsObject(), siteRoot), "_top");
                return;
            }
            context.finish(option);
        } else {
            context.finish(null, null);
        }
    }

    void cancel() {
        this.m_context.finish(Collections.emptyList());
    }

    void changeSite() {
        CmsExtendedSiteSelector.SiteSelectorOption option = (CmsExtendedSiteSelector.SiteSelectorOption)this.m_siteComboBox.getValue();
        I_CmsDialogContext context = this.m_context;
        CmsSiteSelectDialog.changeSite((CmsEmbeddedDialogContext)context, option);
    }

    private FormLayout initForm() {
        FormLayout form = new FormLayout();
        form.setWidth("100%");
        CmsObject cms = A_CmsUI.getCmsObject();
        this.m_siteComboBox = this.prepareSiteSelector("GUI_LABEL_SITE_0");
        CmsExtendedSiteSelector.SiteSelectorOption optionForCurrentSite = this.m_siteComboBox.getOptionForSiteRoot(cms.getRequestContext().getSiteRoot());
        if (optionForCurrentSite != null) {
            this.m_siteComboBox.setValue(optionForCurrentSite);
        }
        form.addComponent((Component)this.m_siteComboBox);
        this.m_siteComboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)evt -> this.changeSite());
        LinkedHashMap<CmsUUID, String> projects = CmsVaadinUtils.getProjectsMap(A_CmsUI.getCmsObject());
        projects.remove(CmsProject.ONLINE_PROJECT_ID);
        ListDataProvider projectsProvider = new ListDataProvider(projects.keySet());
        this.m_projectSelector = new ComboBox();
        this.m_projectSelector.setDataProvider(projectsProvider);
        this.m_projectSelector.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)item -> (String)projects.get(item));
        this.m_projectSelector.setWidth("100%");
        this.m_projectSelector.setEmptySelectionAllowed(false);
        this.m_projectSelector.setCaption(CmsVaadinUtils.getMessageText("GUI_LABEL_PROJECT_0", new Object[0]));
        CmsUUID currentProjectId = this.m_context.getCms().getRequestContext().getCurrentProject().getUuid();
        if (projects.containsKey(currentProjectId)) {
            this.m_projectSelector.setValue((Object)currentProjectId);
        } else {
            try {
                CmsUUID ouProject = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_context.getCms(), this.m_context.getCms().getRequestContext().getOuFqn()).getProjectId();
                if (projects.containsKey(ouProject)) {
                    this.m_projectSelector.setValue((Object)ouProject);
                }
            }
            catch (CmsException e) {
                LOG.error((Object)"Error while reading current OU.", (Throwable)e);
            }
        }
        form.addComponent(this.m_projectSelector);
        this.m_projectSelector.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            try {
                A_CmsUI.get().changeProject(cms.readProject((CmsUUID)event.getValue()));
                this.m_context.finish(Arrays.asList(CmsUUID.getNullUUID()));
            }
            catch (Exception e) {
                CmsErrorDialog.showErrorDialog(e, () -> this.m_context.finish(null));
            }
        });
        return form;
    }

    private CmsExtendedSiteSelector prepareSiteSelector(String captionKey) {
        CmsExtendedSiteSelector result = new CmsExtendedSiteSelector();
        String caption = CmsVaadinUtils.getWpMessagesForCurrentLocale().key(captionKey);
        result.setCaption(caption);
        result.initOptions(this.m_context.getCms(), true);
        result.setPageLength(20);
        result.setWidth("100%");
        result.setPlaceholder(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_CLICK_TO_EDIT_0"));
        return result;
    }
}

