/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.google.common.collect.Lists;
import com.vaadin.annotations.DesignRoot;
import com.vaadin.ui.Button;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.galleries.shared.CmsResourceTypeBean;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.components.extensions.CmsPropertyDialogExtension;
import org.opencms.ui.dialogs.A_CmsSelectResourceTypeDialog;
import org.opencms.ui.util.CmsNewResourceBuilder;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

@DesignRoot
public class CmsNewDialog
extends A_CmsSelectResourceTypeDialog {
    protected ComboBox m_viewSelector;
    protected VerticalLayout m_typeContainer;
    protected CheckBox m_defaultLocationCheckbox;
    protected Button m_cancelButton;
    protected Button m_modeToggle;

    public CmsNewDialog(CmsResource folderResource, I_CmsDialogContext context) {
        super(folderResource, context);
        this.m_defaultLocationCheckbox.setValue((Object)this.getInitialValueForUseDefaultLocationOption(folderResource));
        this.m_defaultLocationCheckbox.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                try {
                    CmsNewDialog.this.init(CmsNewDialog.this.m_currentView, (Boolean)event.getProperty().getValue(), CmsNewDialog.this.m_filterString);
                }
                catch (Exception e) {
                    CmsNewDialog.this.m_dialogContext.error(e);
                }
            }
        });
    }

    @Override
    public Button getCancelButton() {
        return this.m_cancelButton;
    }

    @Override
    public Button getModeToggle() {
        return this.m_modeToggle;
    }

    @Override
    public VerticalLayout getVerticalLayout() {
        return this.m_typeContainer;
    }

    @Override
    public ComboBox getViewSelector() {
        return this.m_viewSelector;
    }

    @Override
    public void handleSelection(CmsResourceTypeBean selectedType) {
        CmsObject cms = A_CmsUI.getCmsObject();
        this.m_selectedType = selectedType;
        try {
            CmsNewResourceBuilder builder = new CmsNewResourceBuilder(cms);
            builder.addCallback(new CmsNewResourceBuilder.I_Callback(){

                @Override
                public void onError(Exception e) {
                    CmsNewDialog.this.m_dialogContext.error(e);
                }

                @Override
                public void onResourceCreated(CmsNewResourceBuilder builderParam) {
                    CmsNewDialog.this.finish(Lists.newArrayList((Object[])new CmsUUID[]{builderParam.getCreatedResource().getStructureId()}));
                }
            });
            this.m_selectedType = selectedType;
            Boolean useDefaultLocation = (Boolean)this.m_defaultLocationCheckbox.getValue();
            if (useDefaultLocation.booleanValue() && this.m_selectedType.getCreatePath() != null) {
                try {
                    CmsADEConfigData configData = OpenCms.getADEManager().lookupConfiguration(cms, this.m_folderResource.getRootPath());
                    CmsResourceTypeConfig typeConfig = configData.getResourceType(this.m_selectedType.getType());
                    if (typeConfig != null) {
                        typeConfig.configureCreateNewElement(cms, this.m_folderResource.getRootPath(), builder);
                    }
                }
                catch (Exception e) {
                    this.m_dialogContext.error(e);
                }
            } else {
                boolean explorerNameGenerationMode = false;
                String sitePath = cms.getRequestContext().removeSiteRoot(this.m_folderResource.getRootPath());
                String namePattern = this.m_selectedType.getNamePattern();
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(namePattern)) {
                    namePattern = OpenCms.getWorkplaceManager().getDefaultNamePattern(this.m_selectedType.getType());
                    explorerNameGenerationMode = true;
                }
                String fileName = CmsStringUtil.joinPaths(sitePath, namePattern);
                builder.setPatternPath(fileName);
                builder.setType(this.m_selectedType.getType());
                builder.setExplorerNameGeneration(explorerNameGenerationMode);
            }
            CmsPropertyDialogExtension ext = new CmsPropertyDialogExtension(A_CmsUI.get(), null);
            CmsAppWorkplaceUi.get().disableGlobalShortcuts();
            ext.editPropertiesForNewResource(builder);
            this.finish(new ArrayList<CmsUUID>());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean useDefault() {
        return (Boolean)this.m_defaultLocationCheckbox.getValue();
    }

    private Boolean getInitialValueForUseDefaultLocationOption(CmsResource folderResource) {
        String rootPath = folderResource.getRootPath();
        return OpenCms.getSiteManager().getSiteForRootPath(rootPath) != null;
    }
}

