/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.google.web.bindery.autobean.vm.AutoBeanFactorySource;
import com.vaadin.annotations.Theme;
import com.vaadin.server.VaadinRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.gwt.shared.I_CmsAutoBeanFactory;
import org.opencms.gwt.shared.I_CmsEmbeddedDialogInfo;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.I_CmsWorkplaceAction;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.extensions.CmsEmbeddedDialogExtension;
import org.opencms.ui.dialogs.CmsEmbeddedDialogContext;
import org.opencms.ui.dialogs.permissions.CmsPrincipalSelectDialog;
import org.opencms.ui.shared.rpc.I_CmsEmbeddingServerRpc;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

@Theme(value="opencms")
public class CmsEmbeddedDialogsUI
extends A_CmsUI
implements I_CmsEmbeddingServerRpc {
    public static final String DIALOGS_PATH = "dialogs/";
    private static final Log LOG = CmsLog.getLog(CmsEmbeddedDialogsUI.class);
    private static final long serialVersionUID = 1201184887611215370L;
    private static I_CmsAutoBeanFactory m_beanFactory = (I_CmsAutoBeanFactory)AutoBeanFactorySource.create(I_CmsAutoBeanFactory.class);
    CmsEmbeddedDialogContext m_currentContext;
    protected CmsEmbeddedDialogExtension m_extension;

    public static String getEmbeddedDialogsContextPath() {
        return CmsStringUtil.joinPaths(OpenCms.getSystemInfo().getWorkplaceContext(), DIALOGS_PATH);
    }

    public Locale getLocale() {
        CmsObject cms = CmsEmbeddedDialogsUI.getCmsObject();
        return OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
    }

    @Override
    public void loadDialog(String dialogInfo) {
        I_CmsEmbeddedDialogInfo info;
        String errorMessage;
        Throwable t;
        block15: {
            t = null;
            errorMessage = null;
            info = (I_CmsEmbeddedDialogInfo)AutoBeanCodex.decode((AutoBeanFactory)m_beanFactory, I_CmsEmbeddedDialogInfo.class, (String)dialogInfo).as();
            try {
                OpenCms.getRoleManager().checkRole(CmsEmbeddedDialogsUI.getCmsObject(), CmsRole.ELEMENT_AUTHOR);
                if ("principalselect".equals(info.getDialogId())) {
                    this.m_currentContext = new CmsEmbeddedDialogContext("principalselect", this.m_extension, null, null, info.getParameters());
                    CmsPrincipalSelectDialog.openEmbeddedDialogV2(this.m_currentContext, info.getParameters(), true);
                    break block15;
                }
                try {
                    I_CmsDialogContext.ContextType type;
                    List<String> resources = info.getStructureIds();
                    ArrayList<CmsResource> resourceList = new ArrayList<CmsResource>();
                    for (String uuid : resources) {
                        if (!CmsUUID.isValidUUID(uuid)) continue;
                        resourceList.add(CmsEmbeddedDialogsUI.getCmsObject().readResource(new CmsUUID(uuid), CmsResourceFilter.ALL));
                    }
                    String typeParam = info.getContextType();
                    boolean isEditor = Boolean.parseBoolean(info.getParameters().get("editor"));
                    String appId = "";
                    try {
                        type = I_CmsDialogContext.ContextType.valueOf(typeParam);
                        if (I_CmsDialogContext.ContextType.containerpageToolbar.equals((Object)type)) {
                            appId = "pageeditor";
                        } else if (I_CmsDialogContext.ContextType.sitemapToolbar.equals((Object)type)) {
                            appId = "sitemapeditor";
                        } else if (isEditor) {
                            appId = "editor";
                        }
                    }
                    catch (Exception e) {
                        type = I_CmsDialogContext.ContextType.appToolbar;
                        LOG.error((Object)("Could not parse context type parameter " + typeParam));
                    }
                    this.m_currentContext = new CmsEmbeddedDialogContext(appId, this.m_extension, type, resourceList, info.getParameters());
                    I_CmsWorkplaceAction action = this.getAction(info.getDialogId());
                    if (action.isActive(this.m_currentContext)) {
                        action.executeAction(this.m_currentContext);
                        break block15;
                    }
                    errorMessage = CmsVaadinUtils.getMessageText("GUI_WORKPLACE_ACCESS_DENIED_TITLE_0", new Object[0]);
                }
                catch (Throwable e) {
                    t = e;
                    errorMessage = CmsVaadinUtils.getMessageText("ERR_DAILOG_INSTANTIATION_FAILED_1", info.getDialogId());
                }
            }
            catch (CmsRoleViolationException ex) {
                t = ex;
                errorMessage = CmsVaadinUtils.getMessageText("GUI_WORKPLACE_ACCESS_DENIED_TITLE_0", new Object[0]);
            }
        }
        if (errorMessage != null) {
            CmsErrorDialog.showErrorDialog(errorMessage, t, new Runnable(){

                @Override
                public void run() {
                    CmsEmbeddedDialogsUI.this.m_currentContext = new CmsEmbeddedDialogContext("", CmsEmbeddedDialogsUI.this.m_extension, null, Collections.emptyList(), info.getParameters());
                    CmsEmbeddedDialogsUI.this.m_currentContext.finish((Collection<CmsUUID>)null);
                }
            });
        }
    }

    @Override
    public void reload() {
        if (this.m_currentContext != null) {
            this.m_currentContext.reload();
        }
    }

    @Override
    protected void init(VaadinRequest request) {
        super.init(request);
        try {
            OpenCms.getRoleManager().checkRole(CmsEmbeddedDialogsUI.getCmsObject(), CmsRole.ELEMENT_AUTHOR);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.m_extension = new CmsEmbeddedDialogExtension(this);
        this.m_extension.getClientRPC().initServerRpc();
    }

    private I_CmsWorkplaceAction getAction(String dialogId) throws Exception {
        Class<?> actionClass = this.getClass().getClassLoader().loadClass(dialogId);
        return (I_CmsWorkplaceAction)actionClass.newInstance();
    }
}

