/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.containerpage.CmsAddDialogTypeHelper;
import org.opencms.ade.galleries.shared.CmsResourceTypeBean;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.dialogs.CmsNewDialog;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;

public class CmsChangeTypeDialog
extends CmsNewDialog {
    static final Log LOG = CmsLog.getLog(CmsChangeTypeDialog.class);
    private static final long serialVersionUID = 1L;

    public CmsChangeTypeDialog(I_CmsDialogContext context) throws CmsException {
        super(A_CmsUI.getCmsObject().readParentFolder(context.getResources().get(0).getStructureId()), context);
        this.displayResourceInfo(context.getResources());
        HorizontalLayout layout = (HorizontalLayout)this.m_defaultLocationCheckbox.getParent();
        Label l = new Label();
        l.setWidth("100%");
        layout.replaceComponent((Component)this.m_defaultLocationCheckbox, (Component)l);
        layout.setExpandRatio((Component)l, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleSelection(CmsResourceTypeBean typeBean) {
        CmsResource changeRes = this.m_dialogContext.getResources().get(0);
        CmsObject cms = A_CmsUI.getCmsObject();
        CmsLockActionRecord lockRecord = null;
        lockRecord = CmsLockUtil.ensureLock(cms, changeRes);
        cms.chtype(cms.getSitePath(changeRes), OpenCms.getResourceManager().getResourceType(typeBean.getType()));
        this.m_dialogContext.finish(Arrays.asList(changeRes.getStructureId()));
        if (lockRecord == null || lockRecord.getChange() != CmsLockActionRecord.LockChange.locked) return;
        try {
            cms.unlockResource(changeRes);
            this.m_dialogContext.finish(Arrays.asList(changeRes.getStructureId()));
            return;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage());
        }
        return;
        catch (CmsException e) {
            try {
                this.m_dialogContext.error(e);
                if (lockRecord == null || lockRecord.getChange() != CmsLockActionRecord.LockChange.locked) return;
            }
            catch (Throwable throwable) {
                if (lockRecord == null || lockRecord.getChange() != CmsLockActionRecord.LockChange.locked) throw throwable;
                try {
                    cms.unlockResource(changeRes);
                    this.m_dialogContext.finish(Arrays.asList(changeRes.getStructureId()));
                    throw throwable;
                }
                catch (CmsException e2) {
                    LOG.error((Object)e2.getLocalizedMessage());
                }
                throw throwable;
            }
            try {
                cms.unlockResource(changeRes);
                this.m_dialogContext.finish(Arrays.asList(changeRes.getStructureId()));
                return;
            }
            catch (CmsException e3) {
                LOG.error((Object)e3.getLocalizedMessage());
            }
            return;
        }
    }

    @Override
    protected CmsAddDialogTypeHelper createTypeHelper() {
        return new CmsAddDialogTypeHelper(CmsResourceTypeConfig.AddMenuType.workplace){

            @Override
            protected boolean exclude(CmsResourceTypeBean type) {
                boolean sameType = OpenCms.getResourceManager().matchResourceType(type.getType(), CmsChangeTypeDialog.this.m_dialogContext.getResources().get(0).getTypeId());
                if (sameType) {
                    return true;
                }
                String typeName = type.getType();
                try {
                    boolean isFolder = CmsChangeTypeDialog.this.m_dialogContext.getResources().get(0).isFolder();
                    boolean identicalTypeGroup = OpenCms.getResourceManager().getResourceType(typeName).isFolder() == isFolder;
                    return !identicalTypeGroup;
                }
                catch (Exception e) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    return false;
                }
            }
        };
    }

    @Override
    protected String getSubtitle(CmsResourceTypeBean type, boolean useDefault) {
        String explorerInfo;
        CmsExplorerTypeSettings explorerType = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type.getType());
        if (explorerType != null && (explorerInfo = explorerType.getInfo()) != null) {
            return CmsVaadinUtils.getMessageText(explorerInfo, new Object[0]);
        }
        return "";
    }
}

