/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.contextmenu;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.CmsContextMenuActionItem;
import org.opencms.ui.actions.I_CmsDefaultAction;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.I_CmsContextMenuItem;
import org.opencms.util.CmsTreeNode;

public class CmsContextMenuTreeBuilder {
    private static final Log LOG = CmsLog.getLog(CmsContextMenuTreeBuilder.class);
    private I_CmsDialogContext m_context;
    private I_CmsContextMenuItem m_defaultActionItem;
    private IdentityHashMap<I_CmsContextMenuItem, CmsMenuItemVisibilityMode> m_visiblities = new IdentityHashMap();

    public CmsContextMenuTreeBuilder(I_CmsDialogContext context) {
        this.m_context = context;
    }

    public CmsTreeNode<I_CmsContextMenuItem> buildAll(List<I_CmsContextMenuItem> availableItems) {
        CmsTreeNode<I_CmsContextMenuItem> result = this.buildTree(availableItems);
        this.removeEmptySubtrees(result);
        return result;
    }

    public CmsTreeNode<I_CmsContextMenuItem> buildTree(List<I_CmsContextMenuItem> items) {
        items = new ArrayList<I_CmsContextMenuItem>(items);
        Map<String, List<I_CmsContextMenuItem>> itemsById = items.stream().collect(Collectors.groupingBy(item -> item.getId()));
        List<I_CmsContextMenuItem> uniqueItems = itemsById.values().stream().map(itemsForCurrentId -> {
            CmsMenuItemVisibilityMode visibility;
            int i;
            Collections.sort(itemsForCurrentId, Comparator.comparing(item -> -item.getPriority()));
            for (i = 0; i < itemsForCurrentId.size() - 1 && (visibility = this.getVisibility((I_CmsContextMenuItem)itemsForCurrentId.get(i))).isUseNext(); ++i) {
            }
            return (I_CmsContextMenuItem)itemsForCurrentId.get(i);
        }).filter(item -> !this.getVisibility((I_CmsContextMenuItem)item).isInVisible()).collect(Collectors.toList());
        if (this.m_context.getResources().size() == 1) {
            this.m_defaultActionItem = this.findDefaultAction(uniqueItems);
        }
        Collections.sort(uniqueItems, new Comparator<I_CmsContextMenuItem>(){

            @Override
            public int compare(I_CmsContextMenuItem a, I_CmsContextMenuItem b) {
                return Float.compare(a.getOrder(), b.getOrder());
            }
        });
        HashSet processedIds = Sets.newHashSet();
        boolean changed = true;
        HashMap treesById = Maps.newHashMap();
        for (I_CmsContextMenuItem item2 : uniqueItems) {
            CmsTreeNode<I_CmsContextMenuItem> node = new CmsTreeNode<I_CmsContextMenuItem>();
            node.setData(item2);
            treesById.put(item2.getId(), node);
        }
        CmsTreeNode<I_CmsContextMenuItem> root = new CmsTreeNode<I_CmsContextMenuItem>();
        treesById.put(null, root);
        while (changed) {
            changed = false;
            Iterator<I_CmsContextMenuItem> iterator = uniqueItems.iterator();
            HashSet currentLevel = Sets.newHashSet();
            while (iterator.hasNext()) {
                I_CmsContextMenuItem currentItem = iterator.next();
                String parentId = currentItem.getParentId();
                if (parentId != null && !processedIds.contains(parentId)) continue;
                changed = true;
                iterator.remove();
                currentLevel.add(currentItem.getId());
                ((CmsTreeNode)treesById.get(parentId)).addChild((CmsTreeNode)treesById.get(currentItem.getId()));
            }
            processedIds.addAll(currentLevel);
        }
        return root;
    }

    public I_CmsContextMenuItem getDefaultActionItem() {
        return this.m_defaultActionItem;
    }

    public CmsMenuItemVisibilityMode getVisibility(I_CmsContextMenuItem item) {
        CmsMenuItemVisibilityMode result = this.m_visiblities.get(item);
        if (result == null) {
            result = item.getVisibility(this.m_context);
            this.m_visiblities.put(item, result);
        }
        return result;
    }

    public void removeEmptySubtrees(CmsTreeNode<I_CmsContextMenuItem> root) {
        List<CmsTreeNode<I_CmsContextMenuItem>> children = root.getChildren();
        if (root.getData() != null && root.getData().isLeafItem()) {
            children.clear();
        } else {
            Iterator<CmsTreeNode<I_CmsContextMenuItem>> iter = children.iterator();
            while (iter.hasNext()) {
                CmsTreeNode<I_CmsContextMenuItem> node = iter.next();
                this.removeEmptySubtrees(node);
                if (node.getData() == null || node.getData().isLeafItem() || node.getChildren().size() != 0) continue;
                iter.remove();
            }
        }
    }

    private I_CmsContextMenuItem findDefaultAction(Collection<I_CmsContextMenuItem> items) {
        I_CmsContextMenuItem result = null;
        int resultRank = -1;
        for (I_CmsContextMenuItem menuItem : items) {
            if (!(menuItem instanceof CmsContextMenuActionItem) || !(((CmsContextMenuActionItem)menuItem).getWorkplaceAction() instanceof I_CmsDefaultAction)) continue;
            I_CmsDefaultAction action = (I_CmsDefaultAction)((CmsContextMenuActionItem)menuItem).getWorkplaceAction();
            if (!this.getVisibility(menuItem).isActive()) continue;
            if (result == null) {
                result = menuItem;
                resultRank = action.getDefaultActionRank(this.m_context);
                continue;
            }
            int rank = action.getDefaultActionRank(this.m_context);
            if (rank <= resultRank) continue;
            result = menuItem;
            resultRank = rank;
        }
        return result;
    }
}

