/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.contextmenu;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.Lists;
import com.google.common.collect.MutableClassToInstanceMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.ui.contextmenu.I_CmsContextMenuItem;
import org.opencms.ui.contextmenu.I_CmsContextMenuItemProvider;

public class CmsContextMenuItemProviderGroup
implements I_CmsContextMenuItemProvider {
    private static final Log LOG = CmsLog.getLog(CmsContextMenuItemProviderGroup.class);
    ClassToInstanceMap<I_CmsContextMenuItemProvider> m_providerMap = MutableClassToInstanceMap.create();
    private List<I_CmsContextMenuItem> m_itemCache = Lists.newArrayList();

    public CmsContextMenuItemProviderGroup() {
        Iterator<I_CmsContextMenuItemProvider> providersIt = ServiceLoader.load(I_CmsContextMenuItemProvider.class).iterator();
        while (providersIt.hasNext()) {
            try {
                this.addProvider(providersIt.next());
            }
            catch (Throwable t) {
                LOG.error((Object)"Error loading context menu provider from classpath.", t);
            }
        }
    }

    public void addProvider(Class<? extends I_CmsContextMenuItemProvider> providerClass) {
        try {
            this.m_providerMap.put(providerClass, (Object)providerClass.newInstance());
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void addProvider(I_CmsContextMenuItemProvider instance) {
        this.m_providerMap.put(instance.getClass(), (Object)instance);
    }

    @Override
    public List<I_CmsContextMenuItem> getMenuItems() {
        return Collections.unmodifiableList(this.m_itemCache);
    }

    public synchronized void initialize() {
        ArrayList result = Lists.newArrayList();
        for (I_CmsContextMenuItemProvider provider : this.m_providerMap.values()) {
            result.addAll(provider.getMenuItems());
        }
        this.m_itemCache = result;
    }
}

