/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.contextmenu;

import com.google.common.collect.Lists;
import com.vaadin.ui.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.components.CmsLockedResourcesList;
import org.opencms.ui.contextmenu.I_CmsContextMenuAction;
import org.opencms.util.CmsUUID;

public class CmsBlockingLockCheck
implements I_CmsContextMenuAction {
    private static final Log LOG = CmsLog.getLog(CmsBlockingLockCheck.class);
    private I_CmsContextMenuAction m_nextAction;

    public CmsBlockingLockCheck(I_CmsContextMenuAction nextAction) {
        this.m_nextAction = nextAction;
    }

    @Override
    public void executeAction(final I_CmsDialogContext context) {
        CmsObject cms = context.getCms();
        List<CmsResource> resources = context.getResources();
        ArrayList blocked = Lists.newArrayList();
        for (CmsResource resource : resources) {
            try {
                blocked.addAll(cms.getBlockingLockedResources(resource));
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (blocked.isEmpty()) {
            this.m_nextAction.executeAction(context);
        } else {
            CmsLockedResourcesList dialog = new CmsLockedResourcesList(cms, blocked, CmsVaadinUtils.getMessageText("GUI_CANT_PERFORM_OPERATION_BECAUSE_OF_LOCKED_RESOURCES_0", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    List<CmsUUID> noStructureIds = Collections.emptyList();
                    context.finish(noStructureIds);
                }
            }, null);
            context.start(CmsVaadinUtils.getMessageText("GUI_EXPLORER_CONTEXT_LOCKS_0", new Object[0]), (Component)dialog);
        }
    }

    public String toString() {
        return "CmsBlockingLockCheck[" + this.m_nextAction.toString() + "]";
    }
}

