/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components.fileselect;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.DefaultItemSorter;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.Tree;
import com.vaadin.v7.ui.TreeTable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsLog;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsFileTable;
import org.opencms.ui.components.CmsResourceTableProperty;
import org.opencms.ui.components.fileselect.CmsResourceTreeContainer;
import org.opencms.ui.components.fileselect.I_CmsSelectionHandler;
import org.opencms.ui.util.I_CmsItemSorter;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsUUID;

public class CmsResourceTreeTable
extends TreeTable {
    private static final Log LOG = CmsLog.getLog(CmsResourceTreeTable.class);
    private static final long serialVersionUID = 1L;
    public static final String CAPTION_FOLDERS = "CAPTION_FOLDERS";
    CmsObject m_cms;
    private List<I_CmsSelectionHandler<CmsResource>> m_resourceSelectionHandlers = Lists.newArrayList();
    private CmsResource m_root;
    private Predicate<Item> m_selectionFilter = Predicates.alwaysTrue();

    public CmsResourceTreeTable(CmsObject cms, CmsResource root, CmsResourceFilter filter) {
        this(cms, root, new CmsResourceTreeContainer(filter));
    }

    public CmsResourceTreeTable(CmsObject cms, CmsResource root, CmsResourceTreeContainer container) {
        this.m_cms = cms;
        this.m_root = root;
        FileSorter sorter = new FileSorter();
        sorter.setSortProperties((Container.Sortable)container, new Object[]{CAPTION_FOLDERS, CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT}, new boolean[]{true, true});
        container.setItemSorter(sorter);
        this.setContainerDataSource((Container)container);
        Table.ColumnGenerator captionGenerator = new Table.ColumnGenerator(){
            private static final long serialVersionUID = 1L;

            public Object generateCell(Table source, Object itemId, Object columnId) {
                if (CmsResourceTreeTable.CAPTION_FOLDERS.equals(columnId)) {
                    String html = (String)source.getContainerDataSource().getItem(itemId).getItemProperty((Object)CmsResourceTableProperty.PROPERTY_TREE_CAPTION).getValue();
                    Label label = new Label(html, ContentMode.HTML);
                    label.setStyleName("o-tree-table-caption");
                    return label;
                }
                return null;
            }
        };
        this.addGeneratedColumn(CAPTION_FOLDERS, captionGenerator);
        this.setVisibleColumns(new Object[]{CAPTION_FOLDERS, CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT});
        this.setItemCaptionPropertyId(CAPTION_FOLDERS);
        this.setColumnHeader(CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT, CmsVaadinUtils.getMessageText(CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT.getHeaderKey(), new Object[0]));
        this.setColumnHeader(CAPTION_FOLDERS, CmsVaadinUtils.getMessageText(CmsResourceTableProperty.PROPERTY_RESOURCE_NAME.getHeaderKey(), new Object[0]));
        this.addStyleName("no-stripes");
        this.addStyleName("no-horizontal-lines");
        this.addStyleName("o-file-tree");
        this.addExpandListener(new Tree.ExpandListener(){
            private static final long serialVersionUID = 1L;

            public void nodeExpand(Tree.ExpandEvent event) {
                CmsResourceTreeTable.this.getTreeContainer().readTreeLevel(CmsResourceTreeTable.this.m_cms, (CmsUUID)event.getItemId());
                CmsResourceTreeTable.this.getTreeContainer().updateSort();
                CmsResourceTreeTable.this.markAsDirtyRecursive();
            }
        });
        this.addCollapseListener(new Tree.CollapseListener(){
            private static final long serialVersionUID = 1L;

            public void nodeCollapse(Tree.CollapseEvent event) {
                CmsResourceTreeTable.this.getTreeContainer().removeChildren((CmsUUID)event.getItemId());
            }
        });
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){
            private static final long serialVersionUID = 1L;

            public void itemClick(ItemClickEvent event) {
                if (CmsResourceTreeTable.this.isSelectable(event.getItem())) {
                    CmsResource resource = (CmsResource)event.getItem().getItemProperty((Object)"RESOURCE").getValue();
                    CmsResourceTreeTable.this.handleSelection(resource);
                }
            }
        });
        this.setCellStyleGenerator(new StyleGenerator());
        this.getTreeContainer().addTreeItem(cms, this.m_root, null);
        try {
            this.setCollapsed(this.m_root.getStructureId(), false);
            this.markAsDirtyRecursive();
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void addResourceSelectionHandler(I_CmsSelectionHandler<CmsResource> handler) {
        this.m_resourceSelectionHandlers.add(handler);
    }

    public void expandItem(CmsUUID itemId) {
        this.setCollapsed(itemId, false);
    }

    public CmsResourceTreeContainer getTreeContainer() {
        return (CmsResourceTreeContainer)this.getContainerDataSource();
    }

    public void removeResourceSelectionHandler(I_CmsSelectionHandler<CmsResource> handler) {
        this.m_resourceSelectionHandlers.remove(handler);
    }

    public void setSelectionFilter(Predicate<Item> selectionFilter) {
        this.m_selectionFilter = selectionFilter;
    }

    public void showSitemapView(boolean showSitemap) {
        if (showSitemap) {
            this.setSortContainerPropertyId(CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT);
            this.setSortAscending(true);
        } else {
            this.setSortContainerPropertyId(CAPTION_FOLDERS);
            this.setSortAscending(true);
        }
    }

    void handleSelection(CmsResource resource) {
        for (I_CmsSelectionHandler<CmsResource> handler : this.m_resourceSelectionHandlers) {
            handler.onSelection(resource);
        }
    }

    boolean isSelectable(Item item) {
        return this.m_selectionFilter.apply((Object)item);
    }

    public static class FileSorter
    extends DefaultItemSorter
    implements I_CmsItemSorter {
        private static final long serialVersionUID = 1L;

        @Override
        public Collection<?> getSortableContainerPropertyIds(Container container) {
            HashSet<Object> result = new HashSet<Object>();
            result.add(CmsResourceTreeTable.CAPTION_FOLDERS);
            result.add(CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT);
            return result;
        }

        protected int compareProperty(Object propertyId, boolean sortDirection, Item item1, Item item2) {
            if (CmsResourceTreeTable.CAPTION_FOLDERS.equals(propertyId)) {
                Boolean isFolder1 = (Boolean)item1.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_IS_FOLDER).getValue();
                Boolean isFolder2 = (Boolean)item2.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_IS_FOLDER).getValue();
                String name1 = (String)item1.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_RESOURCE_NAME).getValue();
                name1 = CmsFileUtil.removeTrailingSeparator(name1);
                String name2 = (String)item2.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_RESOURCE_NAME).getValue();
                name2 = CmsFileUtil.removeTrailingSeparator(name2);
                return (sortDirection ? 1 : -1) * ComparisonChain.start().compareTrueFirst(isFolder1.booleanValue(), isFolder2.booleanValue()).compare((Comparable)((Object)name1), (Comparable)((Object)name2)).result();
            }
            if (CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT.equals(propertyId) && item1.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_NAVIGATION_POSITION) != null) {
                int result;
                Float pos1 = (Float)item1.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_NAVIGATION_POSITION).getValue();
                Float pos2 = (Float)item2.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_NAVIGATION_POSITION).getValue();
                if (pos1 == null) {
                    result = pos2 == null ? this.compareProperty(CmsResourceTableProperty.PROPERTY_RESOURCE_NAME, true, item1, item2) : 1;
                } else {
                    int n = result = pos2 == null ? -1 : Float.compare(pos1.floatValue(), pos2.floatValue());
                }
                if (!sortDirection) {
                    result *= -1;
                }
                return result;
            }
            return super.compareProperty(propertyId, sortDirection, item1, item2);
        }
    }

    public class StyleGenerator
    implements Table.CellStyleGenerator {
        private static final long serialVersionUID = 1L;

        public String getStyle(Table source, Object itemId, Object propertyId) {
            Item item = source.getContainerDataSource().getItem(itemId);
            Object style = CmsFileTable.getStateStyle(item);
            if (!CmsResourceTreeTable.this.isSelectable(item)) {
                style = (String)style + " o-disabled";
            }
            if (CmsResourceTreeTable.CAPTION_FOLDERS.equals(propertyId)) {
                style = (String)style + " o-name-column";
            } else if (CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT == propertyId && item.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_IN_NAVIGATION) != null && ((Boolean)item.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_IN_NAVIGATION).getValue()).booleanValue()) {
                style = (String)style + " o-in-navigation";
            }
            return style;
        }
    }
}

