/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components.fileselect;

import com.google.common.collect.Lists;
import com.vaadin.event.Action;
import com.vaadin.event.ShortcutAction;
import com.vaadin.server.ClientConnector;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.TreeTable;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsResourceTableProperty;
import org.opencms.ui.components.fileselect.CmsResourceSelectDialogContents;
import org.opencms.ui.components.fileselect.CmsResourceTreeContainer;
import org.opencms.ui.components.fileselect.CmsResourceTreeTable;
import org.opencms.ui.components.fileselect.I_CmsSelectionHandler;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsResourceSelectDialog
extends CustomComponent {
    public static final String PROPERTY_SITE_CAPTION = "caption";
    private static final Log LOG = CmsLog.getLog(CmsResourceSelectDialog.class);
    private static final long serialVersionUID = 1L;
    protected CmsObject m_currentCms;
    protected CmsResourceFilter m_resourceFilter;
    protected CmsResource m_root;
    private CmsResourceTreeTable m_fileTree;
    private boolean m_isSitemapView = true;
    private String m_siteRoot;
    private CmsResourceTreeContainer m_treeData;
    private Container.Filter m_currentFilter;

    public CmsResourceSelectDialog(CmsResourceFilter filter) throws CmsException {
        this(filter, A_CmsUI.getCmsObject());
    }

    public CmsResourceSelectDialog(CmsResourceFilter filter, CmsObject cms) throws CmsException {
        this(filter, cms, new Options());
    }

    public CmsResourceSelectDialog(CmsResourceFilter filter, CmsObject _cms, Options options) throws CmsException {
        CmsObject cms;
        this.m_resourceFilter = filter;
        this.setCompositionRoot((Component)new CmsResourceSelectDialogContents());
        IndexedContainer container = options.getSiteSelectionContainer() != null ? options.getSiteSelectionContainer() : CmsVaadinUtils.getAvailableSitesContainer(_cms, PROPERTY_SITE_CAPTION);
        this.getSiteSelector().setContainerDataSource((Container)container);
        if (!_cms.existsResource("/", CmsResourceFilter.IGNORE_EXPIRATION)) {
            cms = OpenCms.initCmsObject(_cms);
            cms.getRequestContext().setSiteRoot("/system/");
        } else {
            cms = _cms;
        }
        this.m_siteRoot = cms.getRequestContext().getSiteRoot();
        this.getSiteSelector().setValue((Object)CmsVaadinUtils.getPathItemId(this.getSiteSelector().getContainerDataSource(), this.m_siteRoot));
        this.getSiteSelector().setNullSelectionAllowed(false);
        this.getSiteSelector().setItemCaptionPropertyId((Object)PROPERTY_SITE_CAPTION);
        this.getSiteSelector().setFilteringMode(FilteringMode.CONTAINS);
        this.getSiteSelector().addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                String site = (String)event.getProperty().getValue();
                CmsResourceSelectDialog.this.onSiteChange(site);
            }
        });
        CmsResource root = cms.readResource("/");
        this.m_fileTree = this.createTree(cms, root);
        this.m_fileTree.setColumnExpandRatio("CAPTION_FOLDERS", 5.0f);
        this.m_fileTree.setColumnExpandRatio(CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT, 1.0f);
        this.m_treeData = this.m_fileTree.getTreeContainer();
        this.updateRoot(cms, root);
        this.getContents().getTreeContainer().addComponent((Component)this.m_fileTree);
        this.m_fileTree.setSizeFull();
        this.getContents().addAttachListener((ClientConnector.AttachListener & Serializable)event -> {
            Window window = CmsVaadinUtils.getWindow((Component)this);
            if (window != null) {
                window.addActionHandler(new Action.Handler(){
                    private final Action enterKeyShortcutAction = new ShortcutAction(null, 13, null);

                    public Action[] getActions(Object target, Object sender) {
                        return new Action[]{this.enterKeyShortcutAction};
                    }

                    public void handleAction(Action action, Object sender, Object target) {
                        if (this.enterKeyShortcutAction.equals(action) && target == CmsResourceSelectDialog.this.getContents().getFilterBox()) {
                            CmsResourceSelectDialog.this.updateFilter();
                        }
                    }
                });
            }
        });
        this.updateView();
        this.getContents().getFilterButton().addClickListener((Button.ClickListener & Serializable)event -> this.updateFilter());
    }

    public void addSelectionHandler(I_CmsSelectionHandler<CmsResource> handler) {
        this.m_fileTree.addResourceSelectionHandler(handler);
    }

    public void disableSiteSwitch() {
        this.getSiteSelector().setEnabled(false);
    }

    public void openPath(String path) {
        if (!CmsStringUtil.isPrefixPath(this.m_root.getRootPath(), path)) {
            CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(path);
            if (site != null) {
                this.getSiteSelector().setValue((Object)site.getSiteRoot());
                path = this.m_currentCms.getRequestContext().removeSiteRoot(path);
            } else if (OpenCms.getSiteManager().startsWithShared(path)) {
                this.getSiteSelector().setValue((Object)OpenCms.getSiteManager().getSharedFolder());
            } else if (path.startsWith("/system/")) {
                Container container = this.getSiteSelector().getContainerDataSource();
                String newSiteRoot = null;
                for (String possibleSiteRoot : Arrays.asList("", "/", "/system", "/system/")) {
                    if (!container.containsId((Object)possibleSiteRoot)) continue;
                    newSiteRoot = possibleSiteRoot;
                    break;
                }
                if (newSiteRoot == null) {
                    LOG.warn((Object)("Couldn't open path in site selector because neither root site nor system folder are in the site selector. path=" + path));
                    return;
                }
                this.getSiteSelector().setValue(newSiteRoot);
            }
        }
        if (!"/".equals(path)) {
            ArrayList idsToOpen = Lists.newArrayList();
            try {
                CmsResource currentFolder = this.m_currentCms.readResource(CmsResource.getParentFolder(path));
                if (!this.m_root.getStructureId().equals(currentFolder.getStructureId())) {
                    idsToOpen.add(currentFolder.getStructureId());
                    CmsResource parentFolder = null;
                    do {
                        try {
                            parentFolder = this.m_currentCms.readParentFolder(currentFolder.getStructureId());
                            idsToOpen.add(parentFolder.getStructureId());
                            currentFolder = parentFolder;
                        }
                        catch (NullPointerException | CmsException e) {
                            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                            break;
                        }
                    } while (!parentFolder.getStructureId().equals(this.m_root.getStructureId()));
                    Collections.reverse(idsToOpen);
                    for (CmsUUID id : idsToOpen) {
                        this.m_fileTree.expandItem(id);
                    }
                }
            }
            catch (CmsException e) {
                LOG.debug((Object)"Can not read parent folder of current path.", (Throwable)e);
            }
        }
    }

    public void showSitemapView(boolean showSitemapView) {
        if (this.m_isSitemapView != showSitemapView) {
            this.m_isSitemapView = showSitemapView;
            this.updateView();
        }
    }

    public void showStartResource(CmsResource startResource) {
        this.openPath(startResource.getRootPath());
    }

    protected CmsResourceTreeTable createTree(CmsObject cms, CmsResource root) {
        return new CmsResourceTreeTable(cms, root, this.m_resourceFilter);
    }

    protected CmsResourceSelectDialogContents getContents() {
        return (CmsResourceSelectDialogContents)this.getCompositionRoot();
    }

    protected CmsResourceTreeTable getFileTree() {
        return this.m_fileTree;
    }

    protected void onSiteChange(String site) {
        try {
            this.removeStringFilter();
            this.m_treeData.removeAllItems();
            try {
                Field cStrategy = TreeTable.class.getDeclaredField("cStrategy");
                cStrategy.trySetAccessible();
                cStrategy.set((Object)this.m_fileTree, null);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            CmsResourceSelectDialogContents contents = (CmsResourceSelectDialogContents)this.getCompositionRoot();
            contents.getFilterBox().setValue("");
            CmsObject rootCms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
            rootCms.getRequestContext().setSiteRoot("");
            CmsResource siteRootResource = rootCms.readResource(site);
            this.m_treeData.initRoot(rootCms, siteRootResource);
            this.m_fileTree.expandItem(siteRootResource.getStructureId());
            this.m_siteRoot = site;
            this.updateRoot(rootCms, siteRootResource);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected void updateRoot(CmsObject rootCms, CmsResource siteRootResource) {
        this.m_root = siteRootResource;
        this.m_currentCms = rootCms;
        this.updateView();
    }

    protected void updateView() {
        this.m_fileTree.showSitemapView(this.m_isSitemapView);
    }

    private FilterData getFilterData(CmsObject cms, CmsResource root, CmsResourceFilter filter, String filterText) throws CmsException {
        List<CmsResource> allResources = cms.readResources(root, filter, true);
        List matching = allResources.stream().filter(res -> res.getName().toLowerCase().contains(filterText.toLowerCase())).collect(Collectors.toList());
        Map<String, CmsResource> resourcesByPath = allResources.stream().collect(Collectors.toMap(res -> res.getRootPath(), res -> res, (a, b) -> b));
        FilterData result = new FilterData();
        for (CmsResource res2 : matching) {
            String path = res2.getRootPath();
            result.getMatchedPaths().add(path);
            do {
                CmsResource parent;
                if ((parent = resourcesByPath.get(path = CmsResource.getParentFolder(path))) == null) continue;
                result.getOpenFolders().add(parent);
            } while (path != null && !path.equals(root.getRootPath()));
        }
        return result;
    }

    private ComboBox getSiteSelector() {
        return this.getContents().getSiteSelector();
    }

    private void removeStringFilter() {
        if (this.m_currentFilter != null) {
            this.m_treeData.removeContainerFilter(this.m_currentFilter);
            this.m_currentFilter = null;
        }
    }

    private void updateFilter() {
        String filterText = this.getContents().getFilterBox().getValue();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(filterText)) {
            this.removeStringFilter();
        } else {
            this.removeStringFilter();
            try {
                final FilterData filterData = this.getFilterData(this.m_currentCms, this.m_root, this.m_resourceFilter, filterText);
                ArrayList<CmsResource> openFolders = new ArrayList<CmsResource>(filterData.getOpenFolders());
                openFolders.sort(Comparator.comparing(res -> res.getRootPath()));
                for (CmsResource resource : openFolders) {
                    this.m_fileTree.expandItem(resource.getStructureId());
                }
                this.m_currentFilter = new Container.Filter(){
                    private Map<CmsUUID, Boolean> m_cache = new HashMap<CmsUUID, Boolean>();

                    public boolean appliesToProperty(Object propertyId) {
                        return false;
                    }

                    public boolean passesFilter(Object itemId, Item item) throws UnsupportedOperationException {
                        return this.m_cache.computeIfAbsent((CmsUUID)itemId, id -> {
                            CmsResource resource = (CmsResource)item.getItemProperty((Object)"RESOURCE").getValue();
                            for (String matchPath : filterData.getMatchedPaths()) {
                                if (!CmsStringUtil.isPrefixPath(matchPath, resource.getRootPath()) && !CmsStringUtil.isPrefixPath(resource.getRootPath(), matchPath)) continue;
                                return true;
                            }
                            return false;
                        });
                    }
                };
                this.m_treeData.addContainerFilter(this.m_currentFilter);
            }
            catch (Exception e) {
                CmsErrorDialog.showErrorDialog(e);
            }
        }
    }

    public static class Options {
        private IndexedContainer m_siteSelectionContainer;

        public IndexedContainer getSiteSelectionContainer() {
            return this.m_siteSelectionContainer;
        }

        public void setSiteSelectionContainer(IndexedContainer siteSelectionContainer) {
            this.m_siteSelectionContainer = siteSelectionContainer;
        }
    }

    static class FilterData {
        private Set<CmsResource> m_openFolders = new HashSet<CmsResource>();
        private Set<String> m_matchedPaths = new HashSet<String>();

        FilterData() {
        }

        public Set<String> getMatchedPaths() {
            return this.m_matchedPaths;
        }

        public Set<CmsResource> getOpenFolders() {
            return this.m_openFolders;
        }
    }

    class PathSelectionAdapter
    implements I_CmsSelectionHandler<CmsResource> {
        private I_CmsSelectionHandler<String> m_pathHandler;
        private boolean m_useSitePaths;

        public PathSelectionAdapter(I_CmsSelectionHandler<String> pathHandler, boolean useSitePaths) {
            this.m_pathHandler = pathHandler;
            this.m_useSitePaths = useSitePaths;
        }

        @Override
        public void onSelection(CmsResource selected) {
            String path = selected.getRootPath();
            if (this.m_useSitePaths) {
                try {
                    CmsObject cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
                    cms.getRequestContext().setSiteRoot(CmsResourceSelectDialog.this.m_siteRoot);
                    path = cms.getRequestContext().removeSiteRoot(path);
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            this.m_pathHandler.onSelection(path);
        }
    }
}

