/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components.fileselect;

import com.vaadin.data.HasValue;
import java.io.Serializable;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.components.fileselect.A_CmsFileSelectField;

public class CmsPathSelectField
extends A_CmsFileSelectField<String> {
    private static final long serialVersionUID = 1L;
    private boolean m_settingInternalValue;
    private boolean m_useRootPaths;

    public CmsPathSelectField() {
        this.m_textField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (!this.m_settingInternalValue) {
                this.setInternalValue((String)event.getValue());
                this.fireValueChange(false);
            }
        });
    }

    public String getPlaceholder() {
        return this.m_textField.getPlaceholder();
    }

    public Class<? extends String> getType() {
        return String.class;
    }

    public String getValue() {
        return this.m_textField.getValue();
    }

    public boolean isUseRootPaths() {
        return this.m_useRootPaths;
    }

    public void setPlaceholder(String placeholder) {
        this.m_textField.setPlaceholder(placeholder);
    }

    public void setUseRootPaths(boolean useRootPaths) {
        this.m_useRootPaths = useRootPaths;
    }

    public void setValue(String value) {
        this.setValue(false, value);
    }

    protected void setInternalValue(String newValue) {
        this.m_settingInternalValue = true;
        try {
            super.setInternalValue((Object)newValue);
            this.m_textField.setValue(newValue);
        }
        finally {
            this.m_settingInternalValue = false;
        }
    }

    @Override
    protected void setResourceValue(CmsResource resource) {
        CmsObject cms = this.m_cms == null ? A_CmsUI.getCmsObject() : this.m_cms;
        CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(resource.getRootPath());
        if (!this.m_useRootPaths && site != null && cms.getRequestContext().getSiteRoot().equals(site.getSiteRoot())) {
            this.setValue(true, cms.getSitePath(resource));
        } else {
            this.setValue(true, resource.getRootPath());
        }
    }

    protected void setValue(boolean fireChange, String value) {
        this.m_textField.setValue(value);
        this.fireValueChange(false);
    }
}

