/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components.extensions;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamReader;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.AbstractExtension;
import com.vaadin.ui.UI;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.gwt.CmsPrefetchSerializationPolicy;
import org.opencms.gwt.shared.property.CmsPropertiesBean;
import org.opencms.gwt.shared.property.CmsPropertyChangeSet;
import org.opencms.gwt.shared.rpc.I_CmsVfsService;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.I_CmsUpdateListener;
import org.opencms.ui.actions.CmsPropertiesDialogAction;
import org.opencms.ui.shared.rpc.I_CmsPropertyClientRpc;
import org.opencms.ui.shared.rpc.I_CmsPropertyServerRpc;
import org.opencms.ui.util.CmsNewResourceBuilder;
import org.opencms.util.CmsUUID;

public class CmsPropertyDialogExtension
extends AbstractExtension
implements I_CmsPropertyServerRpc {
    private static final Log LOG = CmsLog.getLog(CmsPropertyDialogExtension.class);
    private static final long serialVersionUID = 1L;
    List<CmsUUID> m_ids = Lists.newArrayList();
    int m_position;
    private CmsNewResourceBuilder m_newResourceBuilder;
    private HashSet<CmsUUID> m_updatedIds = Sets.newHashSet();
    private I_CmsUpdateListener<String> m_updateListener;

    public CmsPropertyDialogExtension(UI ui, I_CmsUpdateListener<String> updateListener) {
        this.extend((AbstractClientConnector)ui);
        this.m_updateListener = updateListener;
        this.registerRpc(this, I_CmsPropertyServerRpc.class);
    }

    public void editProperties(CmsUUID structureId, List<CmsUUID> allIds, boolean editName) {
        this.m_position = allIds.indexOf(structureId);
        this.m_ids = allIds;
        this.m_updatedIds.add(structureId);
        boolean online = A_CmsUI.getCmsObject().getRequestContext().getCurrentProject().isOnlineProject();
        ((I_CmsPropertyClientRpc)this.getRpcProxy(I_CmsPropertyClientRpc.class)).editProperties(String.valueOf(structureId), editName, online || allIds.size() < 2);
    }

    public void editPropertiesForNewResource(CmsNewResourceBuilder builder) {
        try {
            CmsPropertiesBean propData = builder.getPropertyData();
            String serializedPropData = RPC.encodeResponseForSuccess((Method)I_CmsVfsService.class.getMethod("loadPropertyData", CmsUUID.class), (Object)propData, (SerializationPolicy)CmsPrefetchSerializationPolicy.instance());
            ((I_CmsPropertyClientRpc)this.getRpcProxy(I_CmsPropertyClientRpc.class)).editPropertiesForNewResource(serializedPropData);
            this.m_newResourceBuilder = builder;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onClose(long delayMillis) {
        this.remove();
        if (delayMillis > 0L) {
            try {
                Thread.sleep(delayMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ArrayList updates = Lists.newArrayList();
        for (CmsUUID id : this.m_updatedIds) {
            updates.add(String.valueOf(id));
        }
        this.m_updateListener.onUpdate(updates);
    }

    @Override
    public void removeExtension() {
        this.remove();
    }

    @Override
    public void requestNextFile(int offset) {
        int newPos = this.m_position;
        int count = 0;
        do {
            newPos = this.nextIndex(newPos, offset);
            if (++count <= this.m_ids.size()) continue;
            newPos = this.m_position;
            break;
        } while (!this.canEdit(this.m_ids.get(newPos)));
        this.m_position = newPos;
        CmsUUID nextId = this.m_ids.get(this.m_position);
        this.m_updatedIds.add(nextId);
        ((I_CmsPropertyClientRpc)this.getRpcProxy(I_CmsPropertyClientRpc.class)).sendNextId(String.valueOf(nextId));
    }

    @Override
    public void savePropertiesForNewResource(String data) {
        try {
            ((I_CmsPropertyClientRpc)this.getRpcProxy(I_CmsPropertyClientRpc.class)).confirmSaveForNew();
            ServerSerializationStreamReader streamReader = new ServerSerializationStreamReader(Thread.currentThread().getContextClassLoader(), null);
            streamReader.prepareToRead(data);
            CmsPropertyChangeSet changes = (CmsPropertyChangeSet)streamReader.readObject();
            this.m_newResourceBuilder.setPropertyChanges(changes);
            this.m_newResourceBuilder.safeCreateResource();
            this.remove();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean canEdit(CmsUUID id) {
        CmsObject cms = A_CmsUI.getCmsObject();
        CmsResource res = null;
        try {
            res = cms.readResource(id, CmsResourceFilter.ALL);
            boolean result = CmsPropertiesDialogAction.VISIBILITY.getVisibility(A_CmsUI.getCmsObject(), Lists.newArrayList((Object[])new CmsResource[]{res})).isActive();
            return result;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    int nextIndex(int pos, int offset) {
        return (pos + offset + this.m_ids.size()) % this.m_ids.size();
    }
}

