/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components.extensions;

import com.google.common.collect.Lists;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.AbstractExtension;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.AbstractComponent;
import java.util.List;
import org.opencms.ui.shared.components.CmsMaxHeightState;
import org.opencms.ui.shared.rpc.I_CmsMaxHeightServerRpc;

public class CmsMaxHeightExtension
extends AbstractExtension
implements I_CmsMaxHeightServerRpc {
    private static final long serialVersionUID = 3978957151754705873L;
    private AbstractComponent m_component;
    private List<I_HeightChangeHandler> m_heightChangeHandlers = Lists.newArrayList();
    private boolean m_enabled = true;

    public CmsMaxHeightExtension(AbstractComponent component, int maxHeight) {
        this.m_component = component;
        this.extend((AbstractClientConnector)component);
        this.registerRpc(this);
        this.getState().setMaxHeight(maxHeight);
    }

    public void addHeightChangeHandler(I_HeightChangeHandler action) {
        this.m_heightChangeHandlers.add(action);
    }

    @Override
    public void fixHeight(int height) {
        if (!this.m_enabled) {
            return;
        }
        if (height < 1) {
            this.m_component.setHeightUndefined();
        } else {
            this.m_component.setHeight((float)height, Sizeable.Unit.PIXELS);
        }
        for (I_HeightChangeHandler handler : this.m_heightChangeHandlers) {
            handler.onChangeHeight(height);
        }
    }

    public void removeHeightChangeHandler(Runnable action) {
        this.m_heightChangeHandlers.remove(action);
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public void updateMaxHeight(int maxHeight) {
        this.getState().setMaxHeight(maxHeight);
    }

    protected CmsMaxHeightState getState() {
        return (CmsMaxHeightState)super.getState();
    }

    public static interface I_HeightChangeHandler {
        public void onChangeHeight(int var1);
    }
}

