/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components.categoryselect;

import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.HierarchicalContainer;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.TextField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opencms.relations.CmsCategory;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.categoryselect.CmsCategoryTree;
import org.opencms.ui.components.fileselect.I_CmsSelectionHandler;
import org.opencms.util.CmsStringUtil;

public class CmsCategorySelectDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = 247205018045790127L;
    private TextField m_filter;
    private Button m_okButton;
    private List<I_CmsSelectionHandler<Collection<CmsCategory>>> m_selectionHandlers = new ArrayList<I_CmsSelectionHandler<Collection<CmsCategory>>>();
    private CmsCategoryTree m_tree;

    public CmsCategorySelectDialog(String contextPath) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_filter.setIcon((Resource)FontOpenCms.FILTER);
        this.m_filter.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
        this.m_filter.addStyleName("inline-icon");
        this.m_filter.setWidth("200px");
        this.m_filter.addTextChangeListener(new FieldEvents.TextChangeListener(){
            private static final long serialVersionUID = 1L;

            public void textChange(FieldEvents.TextChangeEvent event) {
                CmsCategorySelectDialog.this.filterTree(event.getText());
            }
        });
        this.m_tree.loadCategories(A_CmsUI.getCmsObject(), contextPath);
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsCategorySelectDialog.this.onOk();
            }
        });
    }

    public void addSelectionHandler(I_CmsSelectionHandler<Collection<CmsCategory>> selectionHandler) {
        this.m_selectionHandlers.add(selectionHandler);
    }

    public void removeSelectionHandler(I_CmsSelectionHandler<Collection<CmsCategory>> selectionHandler) {
        this.m_selectionHandlers.remove(selectionHandler);
    }

    public void setSelectedCategories(Collection<CmsCategory> categories) {
        this.m_tree.setSelectedCategories(categories);
    }

    void filterTree(String filter) {
        HierarchicalContainer container = (HierarchicalContainer)this.m_tree.getContainerDataSource();
        container.removeAllContainerFilters();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(filter)) {
            final String lowerCaseFilter = filter.toLowerCase();
            container.addContainerFilter(new Container.Filter(){
                private static final long serialVersionUID = 1L;

                public boolean appliesToProperty(Object propertyId) {
                    return true;
                }

                public boolean passesFilter(Object itemId, Item item) throws UnsupportedOperationException {
                    CmsCategory cat = (CmsCategory)itemId;
                    return cat.getPath().toLowerCase().contains(lowerCaseFilter) || cat.getTitle() != null && cat.getTitle().toLowerCase().contains(lowerCaseFilter);
                }
            });
        }
    }

    void onOk() {
        if (!this.m_selectionHandlers.isEmpty()) {
            Collection<CmsCategory> categories = this.m_tree.getSelectedCategories();
            for (I_CmsSelectionHandler<Collection<CmsCategory>> handler : this.m_selectionHandlers) {
                handler.onSelection(categories);
            }
        }
    }
}

