/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import com.vaadin.ui.RichTextArea;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Cleaner;
import org.jsoup.safety.Safelist;

public class CmsRichTextArea
extends RichTextArea {
    private static final long serialVersionUID = 1L;
    private static final String CSS_CLASSNAME = "richopensans";
    private String m_styleName = "";

    public CmsRichTextArea() {
        this.addStyleName("o-richtextarea-reduced");
    }

    public static String cleanHtml(String html, boolean allowLinks) {
        if (html == null) {
            return null;
        }
        Safelist whitelist = new Safelist();
        whitelist.addTags(new String[]{"font", "b", "span", "i", "strong", "br", "u", "ul", "ol", "li", "div"});
        whitelist.addAttributes("font", new String[]{"size", "color", "face"});
        if (allowLinks) {
            whitelist.addTags(new String[]{"a"});
            whitelist.addAttributes("a", new String[]{"href"});
        }
        Cleaner cleaner = new Cleaner(whitelist);
        Document doc = Jsoup.parseBodyFragment((String)html);
        Document cleaned = cleaner.clean(doc);
        return cleaned.body().html();
    }
}

