/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import com.google.common.base.Joiner;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import com.vaadin.event.dd.DropHandler;
import com.vaadin.ui.Component;
import com.vaadin.ui.Composite;
import com.vaadin.ui.CustomComponent;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsResourceIcon;
import org.opencms.ui.components.CmsResourceTableProperty;
import org.opencms.ui.util.I_CmsItemSorter;
import org.opencms.util.CmsColorContrastCalculator;
import org.opencms.util.CmsPath;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsResourceTable
extends CustomComponent {
    public static final int COLLAPSED = 1;
    public static final int INVISIBLE = 2;
    private static final CategoryComparator CATEGORY_COMPARATOR = new CategoryComparator();
    private static final Log LOG = CmsLog.getLog(CmsResourceTable.class);
    private static final CmsColorContrastCalculator m_contrastCalculator = new CmsColorContrastCalculator();
    private static final long serialVersionUID = 1L;
    protected ItemContainer m_container = new ItemContainer();
    protected Table m_fileTable = new Table(){
        private long m_changingVariables;

        public void changeVariables(Object source, Map<String, Object> variables) {
            ++this.m_changingVariables;
            try {
                super.changeVariables(source, variables);
            }
            finally {
                --this.m_changingVariables;
            }
        }

        public void setColumnCollapsed(Object propertyId, boolean collapsed) throws IllegalStateException {
            super.setColumnCollapsed(propertyId, collapsed);
            if (this.m_changingVariables > 0L && CmsResourceTable.this.m_columnSettingChangeHandler != null) {
                CmsResourceTable.this.m_columnSettingChangeHandler.onColumnSettingsChanged();
            }
        }

        public void sort(Object[] propertyId, boolean[] ascending) throws UnsupportedOperationException {
            super.sort(propertyId, ascending);
            if (this.m_changingVariables > 0L && CmsResourceTable.this.m_columnSettingChangeHandler != null) {
                CmsResourceTable.this.m_columnSettingChangeHandler.onColumnSettingsChanged();
            }
        }
    };
    protected List<I_ResourcePropertyProvider> m_propertyProviders = new ArrayList<I_ResourcePropertyProvider>();
    private ColumnSettingChangeHandler m_columnSettingChangeHandler;

    public CmsResourceTable() {
        this.m_fileTable.setContainerDataSource((Container)this.m_container);
        this.setCompositionRoot((Component)this.m_fileTable);
        this.m_fileTable.setRowHeaderMode(Table.RowHeaderMode.HIDDEN);
        this.m_fileTable.setItemDescriptionGenerator((AbstractSelect.ItemDescriptionGenerator)new DefaultItemDescriptionGenerator());
    }

    public static void fillItemDefault(Item resourceItem, CmsObject cms, CmsResource resource, Locale locale) {
        if (resource == null) {
            LOG.error((Object)"Error rendering item for 'null' resource");
            return;
        }
        if (resourceItem == null) {
            LOG.error((Object)("Error rendering 'null' item for resource " + resource.getRootPath()));
            return;
        }
        if (cms == null) {
            cms = A_CmsUI.getCmsObject();
            LOG.warn((Object)"CmsObject was 'null', using thread local CmsObject");
        }
        CmsResourceUtil resUtil = new CmsResourceUtil(cms, resource);
        HashMap<String, CmsProperty> resourceProps = null;
        try {
            List<CmsProperty> props = cms.readPropertyObjects(resource, false);
            resourceProps = new HashMap<String, CmsProperty>();
            for (CmsProperty prop : props) {
                resourceProps.put(prop.getName(), prop);
            }
        }
        catch (CmsException e1) {
            LOG.debug((Object)("Unable to read properties for resource '" + resource.getRootPath() + "'."), (Throwable)e1);
        }
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(resource);
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_TYPE_ICON) != null) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_TYPE_ICON).setValue((Object)new CmsResourceIcon(resUtil, resource.getState(), true));
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_PROJECT) != null) {
            Label projectFlag = null;
            switch (resUtil.getProjectState().getMode()) {
                case 1: {
                    projectFlag = new Label(new CmsCssIcon("oc-icon-24-project_yellow").getHtml(resUtil.getLockedInProjectName()), ContentMode.HTML);
                    break;
                }
                case 2: {
                    projectFlag = new Label(new CmsCssIcon("oc-icon-24-project_red").getHtml(resUtil.getLockedInProjectName()), ContentMode.HTML);
                    break;
                }
                case 5: {
                    projectFlag = new Label(new CmsCssIcon("oc-icon-24-publish").getHtml(resUtil.getLockedInProjectName()), ContentMode.HTML);
                    break;
                }
            }
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_PROJECT).setValue(projectFlag);
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_INSIDE_PROJECT) != null) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_INSIDE_PROJECT).setValue((Object)resUtil.isInsideProject());
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_RELEASED_NOT_EXPIRED) != null) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_RELEASED_NOT_EXPIRED).setValue((Object)resUtil.isReleasedAndNotExpired());
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_RESOURCE_NAME) != null) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_RESOURCE_NAME).setValue((Object)resource.getName());
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_SITE_PATH) != null) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_SITE_PATH).setValue((Object)cms.getSitePath(resource));
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_TITLE) != null && resourceProps != null) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_TITLE).setValue((Object)(resourceProps.containsKey("Title") ? ((CmsProperty)resourceProps.get("Title")).getValue() : ""));
        }
        boolean inNavigation = false;
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT) != null && resourceProps != null) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT).setValue((Object)(resourceProps.containsKey("NavText") ? ((CmsProperty)resourceProps.get("NavText")).getValue() : ""));
            inNavigation = resourceProps.containsKey("NavText");
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_NAVIGATION_POSITION) != null && resourceProps != null) {
            try {
                Float navPos = resourceProps.containsKey("NavPos") ? Float.valueOf(((CmsProperty)resourceProps.get("NavPos")).getValue()) : (inNavigation ? Float.valueOf(Float.MAX_VALUE) : null);
                resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_NAVIGATION_POSITION).setValue((Object)navPos);
                inNavigation = navPos != null;
            }
            catch (Exception e) {
                LOG.debug((Object)"Error evaluating navPos property", (Throwable)e);
            }
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_IN_NAVIGATION) != null) {
            if (inNavigation && resourceProps != null && resourceProps.containsKey("NavInfo") && "ignoreInDefaultNav".equals(((CmsProperty)resourceProps.get("NavInfo")).getValue())) {
                inNavigation = false;
            }
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_IN_NAVIGATION).setValue((Object)inNavigation);
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_COPYRIGHT) != null && resourceProps != null) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_COPYRIGHT).setValue((Object)(resourceProps.containsKey("Copyright") ? ((CmsProperty)resourceProps.get("Copyright")).getValue() : ""));
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_CACHE) != null && resourceProps != null) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_CACHE).setValue((Object)(resourceProps.containsKey("cache") ? ((CmsProperty)resourceProps.get("cache")).getValue() : ""));
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_RESOURCE_TYPE) != null) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_RESOURCE_TYPE).setValue((Object)CmsWorkplaceMessages.getResourceTypeName(locale, type.getTypeName()));
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_INTERNAL_RESOURCE_TYPE) != null) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_INTERNAL_RESOURCE_TYPE).setValue((Object)type.getTypeName());
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_IS_FOLDER) != null) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_IS_FOLDER).setValue((Object)resource.isFolder());
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_SIZE) != null && resource.isFile()) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_SIZE).setValue((Object)resource.getLength());
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_PERMISSIONS) != null) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_PERMISSIONS).setValue((Object)resUtil.getPermissionString());
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_DATE_MODIFIED) != null) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_DATE_MODIFIED).setValue((Object)resource.getDateLastModified());
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_USER_MODIFIED) != null) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_USER_MODIFIED).setValue((Object)resUtil.getUserLastModified());
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_DATE_CREATED) != null) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_DATE_CREATED).setValue((Object)resource.getDateCreated());
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_USER_CREATED) != null) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_USER_CREATED).setValue((Object)resUtil.getUserCreated());
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_DATE_RELEASED) != null) {
            long release = resource.getDateReleased();
            if (release != 0L) {
                resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_DATE_RELEASED).setValue((Object)release);
            } else {
                resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_DATE_RELEASED).setValue(null);
            }
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_DATE_EXPIRED) != null) {
            long expire = resource.getDateExpired();
            if (expire != Long.MAX_VALUE) {
                resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_DATE_EXPIRED).setValue((Object)expire);
            } else {
                resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_DATE_EXPIRED).setValue(null);
            }
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_STATE_NAME) != null) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_STATE_NAME).setValue((Object)resUtil.getStateName());
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_STATE) != null) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_STATE).setValue((Object)resource.getState());
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_USER_LOCKED) != null) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_USER_LOCKED).setValue((Object)resUtil.getLockedByName());
        }
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_CATEGORIES) != null) {
            CategoryLabel l = new CategoryLabel(resUtil, locale);
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_CATEGORIES).setValue((Object)l);
        }
    }

    public static String getStateStyle(CmsResourceState state) {
        String stateStyle = "";
        if (state != null) {
            if (state.isDeleted()) {
                stateStyle = "o-state-deleted";
            } else if (state.isNew()) {
                stateStyle = "o-state-new";
            } else if (state.isChanged()) {
                stateStyle = "o-state-changed";
            }
        }
        return stateStyle;
    }

    private static String getCompositeCategoryTitle(Map<CmsPath, CmsCategory> categories, CmsCategory category) {
        ArrayList<String> components = new ArrayList<String>();
        CmsCategory currentCategory = category;
        while (currentCategory != null) {
            components.add(currentCategory.getTitle());
            CmsPath parentPath = new CmsPath(CmsResource.getParentFolder(currentCategory.getPath()));
            currentCategory = categories.get(parentPath);
        }
        Collections.reverse(components);
        return Joiner.on((String)" / ").join(components);
    }

    public void addPropertyProvider(I_ResourcePropertyProvider provider) {
        this.m_propertyProviders.add(provider);
    }

    public void clearSelection() {
        this.m_fileTable.setValue(Collections.emptySet());
    }

    public void fillTable(CmsObject cms, List<CmsResource> resources) {
        this.fillTable(cms, resources, true);
    }

    public void fillTable(CmsObject cms, List<CmsResource> resources, boolean clearFilter) {
        this.fillTable(cms, resources, clearFilter, true);
    }

    public void fillTable(CmsObject cms, List<CmsResource> resources, boolean clearFilter, boolean sort) {
        this.fillTable(cms, resources, clearFilter, true, false);
    }

    public void fillTable(CmsObject cms, List<CmsResource> resources, boolean clearFilter, boolean sort, boolean distinctResources) {
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        this.m_container.removeAllItems();
        if (clearFilter) {
            this.m_container.removeAllContainerFilters();
        }
        if (distinctResources) {
            HashMap<String, String> ids = new HashMap<String, String>();
            for (CmsResource resource : resources) {
                String id = resource.getStructureId().getStringValue();
                if (ids.containsKey(id)) continue;
                this.fillItem(cms, resource, wpLocale);
                ids.put(id, "");
            }
        } else {
            for (CmsResource resource : resources) {
                this.fillItem(cms, resource, wpLocale);
            }
        }
        if (sort) {
            this.m_fileTable.sort();
        }
        this.clearSelection();
    }

    public List<CmsUUID> getAllIds() {
        return this.itemIdsToUUIDs((List)this.m_fileTable.getContainerDataSource().getItemIds());
    }

    public int getItemCount() {
        return this.m_container.getItemCount();
    }

    public CmsUUID getUUIDFromItemID(String itemId) {
        return new CmsUUID(itemId);
    }

    public boolean isColumnVisible(CmsResourceTableProperty propertyId) {
        return Arrays.asList(this.m_fileTable.getVisibleColumns()).contains(propertyId) && !this.m_fileTable.isColumnCollapsed((Object)propertyId);
    }

    public void removePropertyProvider(I_ResourcePropertyProvider provider) {
        this.m_propertyProviders.remove(provider);
    }

    public void selectAll() {
        this.m_fileTable.setValue((Object)this.m_fileTable.getItemIds());
    }

    public void setCollapsedColumns(Object ... collapsedColumns) {
        HashSet collapsedSet = Sets.newHashSet();
        for (Object collapsed : collapsedColumns) {
            collapsedSet.add(collapsed);
        }
        for (Object key : this.m_fileTable.getVisibleColumns()) {
            boolean isCollapsed = collapsedSet.contains(key);
            this.internalSetColumnCollapsed(key, isCollapsed);
        }
    }

    public void setColumnSettingChangeHandler(ColumnSettingChangeHandler columnSettingChangeHandler) {
        this.m_columnSettingChangeHandler = columnSettingChangeHandler;
    }

    public void setDragMode(Table.TableDragMode dragMode) {
        this.m_fileTable.setDragMode(dragMode);
    }

    public void setDropHandler(DropHandler handler) {
        this.m_fileTable.setDropHandler(handler);
    }

    public void setValue(Set<String> o) {
        this.m_fileTable.setValue(o);
    }

    protected void fillItem(CmsObject cms, CmsResource resource, Locale locale) {
        Item resourceItem = this.m_container.getItem(resource.getStructureId().toString());
        if (resourceItem == null) {
            resourceItem = this.m_container.addItem(resource.getStructureId().toString());
        }
        CmsResourceTable.fillItemDefault(resourceItem, cms, resource, locale);
        for (I_ResourcePropertyProvider provider : this.m_propertyProviders) {
            provider.addItemProperties(resourceItem, cms, resource, locale);
        }
    }

    protected void internalSetColumnCollapsed(Object key, boolean collapsed) {
        this.m_fileTable.setColumnCollapsed(key, collapsed);
    }

    protected List<CmsUUID> itemIdsToUUIDs(Collection<String> itemIds) {
        ArrayList<CmsUUID> ids = new ArrayList<CmsUUID>();
        for (String itemId : itemIds) {
            if (itemId == null) continue;
            ids.add(this.getUUIDFromItemID(itemId));
        }
        return ids;
    }

    protected static class ItemContainer
    extends IndexedContainer {
        private static final long serialVersionUID = -2033722658471550506L;

        protected ItemContainer() {
        }

        public Collection<?> getSortableContainerPropertyIds() {
            if (this.getItemSorter() instanceof I_CmsItemSorter) {
                return ((I_CmsItemSorter)this.getItemSorter()).getSortableContainerPropertyIds((Container)this);
            }
            return super.getSortableContainerPropertyIds();
        }

        protected int getItemCount() {
            return this.getAllItemIds().size();
        }
    }

    public static class DefaultItemDescriptionGenerator
    implements AbstractSelect.ItemDescriptionGenerator {
        private static final long serialVersionUID = 1L;

        public String generateDescription(Component source, Object itemId, Object propertyId) {
            Table table = (Table)source;
            try {
                if (propertyId != null && itemId != null) {
                    Object value;
                    Property prop = table.getContainerDataSource().getItem(itemId).getItemProperty(propertyId);
                    Converter converter = table.getConverter(propertyId);
                    if (CmsResourceTableProperty.PROPERTY_RESOURCE_NAME == propertyId) {
                        return null;
                    }
                    if (converter != null && String.class.equals((Object)converter.getPresentationType())) {
                        return (String)converter.convertToPresentation(prop.getValue(), String.class, A_CmsUI.get().getLocale());
                    }
                    if ((String.class.equals((Object)prop.getType()) || ClassUtils.isPrimitiveOrWrapper((Class)prop.getType())) && (value = prop.getValue()) != null) {
                        return CmsEncoder.escapeXml(String.valueOf(value));
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public static class CategoryLabel
    extends Composite
    implements Comparable<CategoryLabel> {
        private static final long serialVersionUID = 1L;
        private boolean m_initialized;
        private Label m_label = new Label();
        private Locale m_locale;
        private CmsResourceUtil m_resUtil;
        private String m_value = "";

        public CategoryLabel(CmsResourceUtil resUtil, Locale locale) {
            this.m_locale = locale;
            this.m_resUtil = resUtil;
            this.setCompositionRoot((Component)this.m_label);
            this.addStyleName("o-category-label");
        }

        public void attach() {
            this.init();
            super.attach();
        }

        @Override
        public int compareTo(CategoryLabel o) {
            return CATEGORY_COMPARATOR.compare(this.getValue(), o.getValue());
        }

        public String getValue() {
            this.init();
            return this.m_value;
        }

        public String toString() {
            return this.getValue();
        }

        protected synchronized void init() {
            if (!this.m_initialized) {
                this.m_initialized = true;
                try {
                    CmsObject cms = this.m_resUtil.getCms();
                    CmsCategoryService catService = CmsCategoryService.getInstance();
                    List<CmsCategory> categories = catService.readResourceCategories(cms, this.m_resUtil.getResource());
                    categories = catService.localizeCategories(cms, categories, this.m_locale);
                    Map<CmsPath, CmsCategory> categoriesByPath = categories.stream().collect(Collectors.toMap(cat -> new CmsPath(cat.getPath()), cat -> cat, (a, b) -> b));
                    Set parents = categories.stream().map(cat -> CmsResource.getParentFolder(cat.getPath())).filter(path -> path != null).map(path -> new CmsPath((String)path)).collect(Collectors.toSet());
                    boolean removeParents = OpenCms.getWorkplaceManager().isExplorerCategoriesLeavesOnly();
                    boolean fullPath = OpenCms.getWorkplaceManager().isExplorerCategoriesWithPath();
                    ArrayList<CmsCategory> categoriesToDisplay = new ArrayList<CmsCategory>(categories);
                    if (removeParents) {
                        categoriesToDisplay.removeIf(cat -> parents.contains(new CmsPath(cat.getPath())));
                    }
                    List items = categoriesToDisplay.stream().map(cat -> new CategoryItem(cat.getPath(), fullPath ? CmsResourceTable.getCompositeCategoryTitle(categoriesByPath, cat) : cat.getTitle(), cat.getBackground())).collect(Collectors.toList());
                    Comparator comparator = (a, b) -> ComparisonChain.start().compare((Comparable)((Object)a.getCategoryPath()), (Comparable)((Object)b.getCategoryPath())).result();
                    Collections.sort(items, comparator);
                    this.m_value = items.stream().map(item -> item.getTitle()).collect(Collectors.joining(", "));
                    this.m_label.setDescription(this.m_value);
                    String html = items.stream().flatMap(item -> {
                        Object colorStyle = "";
                        String bg = item.getBackground();
                        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(bg)) {
                            bg = bg.trim();
                            Object fgSuffix = "";
                            try {
                                fgSuffix = " color: " + m_contrastCalculator.getForeground(bg) + " !important;";
                            }
                            catch (Exception e) {
                                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                            }
                            colorStyle = " style='background-color: " + bg + " !important; " + (String)fgSuffix + "' ";
                        }
                        return Arrays.asList("<div class='o-category-label-category' ", colorStyle, ">", CmsEncoder.escapeXml(item.getTitle()), "</div>").stream();
                    }).collect(Collectors.joining(""));
                    this.m_label.setContentMode(ContentMode.HTML);
                    this.m_label.setValue(html);
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }

        class CategoryItem {
            private String m_background;
            private String m_title;
            private String m_categoryPath;

            public CategoryItem(String categoryPath, String title, String background) {
                this.m_categoryPath = categoryPath;
                this.m_title = title;
                this.m_background = background;
            }

            public String getBackground() {
                return this.m_background;
            }

            public String getCategoryPath() {
                return this.m_categoryPath;
            }

            public String getTitle() {
                return this.m_title;
            }
        }
    }

    public static interface ColumnSettingChangeHandler {
        public void onColumnSettingsChanged();
    }

    public static interface I_ResourcePropertyProvider {
        public void addItemProperties(Item var1, CmsObject var2, CmsResource var3, Locale var4);
    }

    public static class CategoryComparator
    implements Comparator<String> {
        private final Collator m_collator = Collator.getInstance((ULocale)ULocale.ROOT);

        @Override
        public int compare(String c1, String c2) {
            if ("".equals(c1) && "".equals(c2)) {
                return 0;
            }
            if ("".equals(c1)) {
                return 1;
            }
            if ("".equals(c2)) {
                return -1;
            }
            return this.m_collator.compare(c1, c2);
        }
    }

    public static class ColumnEntry {
        private CmsResourceTableProperty m_column;
        private int m_flags;

        public CmsResourceTableProperty getColumn() {
            return this.m_column;
        }

        public boolean isCollapsed() {
            return (this.m_flags & 1) != 0;
        }

        public boolean isVisible() {
            return 0 == (this.m_flags & 2);
        }

        public void setColumn(CmsResourceTableProperty column) {
            this.m_column = column;
        }

        public void setFlags(int flags) {
            this.m_flags = flags;
        }

        public String toString() {
            return "ColumnEntry[" + this.getColumn().getId() + "," + this.m_flags + "]";
        }
    }

    public class ColumnBuilder {
        private List<ColumnEntry> m_columnEntries = Lists.newArrayList();

        public void buildColumns() {
            LinkedHashSet<CmsResourceTableProperty> visible = new LinkedHashSet<CmsResourceTableProperty>();
            LinkedHashSet<CmsResourceTableProperty> collapsed = new LinkedHashSet<CmsResourceTableProperty>();
            for (ColumnEntry entry : this.m_columnEntries) {
                CmsResourceTableProperty prop = entry.getColumn();
                CmsResourceTable.this.m_container.addContainerProperty(prop, prop.getColumnType(), prop.getDefaultValue());
                if (entry.isCollapsed()) {
                    collapsed.add(entry.getColumn());
                }
                if (!entry.isVisible()) continue;
                visible.add(entry.getColumn());
            }
            CmsResourceTable.this.m_fileTable.setVisibleColumns(visible.toArray(new Object[0]));
            Object[] collapsedColumnsArray = collapsed.toArray(new Object[0]);
            CmsResourceTable.this.setCollapsedColumns(collapsedColumnsArray);
            for (CmsResourceTableProperty visibleProp : visible) {
                String headerKey = visibleProp.getHeaderKey();
                if (!CmsStringUtil.isEmptyOrWhitespaceOnly(headerKey)) {
                    CmsResourceTable.this.m_fileTable.setColumnHeader((Object)visibleProp, CmsVaadinUtils.getMessageText(headerKey, new Object[0]));
                } else {
                    CmsResourceTable.this.m_fileTable.setColumnHeader((Object)visibleProp, "");
                }
                CmsResourceTable.this.m_fileTable.setColumnCollapsible((Object)visibleProp, visibleProp.isCollapsible());
                if (visibleProp.getColumnWidth() > 0) {
                    CmsResourceTable.this.m_fileTable.setColumnWidth((Object)visibleProp, visibleProp.getColumnWidth());
                }
                if (visibleProp.getExpandRatio() > 0.0f) {
                    CmsResourceTable.this.m_fileTable.setColumnExpandRatio((Object)visibleProp, visibleProp.getExpandRatio());
                }
                if (visibleProp.getConverter() == null) continue;
                CmsResourceTable.this.m_fileTable.setConverter((Object)visibleProp, visibleProp.getConverter());
            }
        }

        public ColumnBuilder column(CmsResourceTableProperty prop) {
            this.column(prop, 0);
            return this;
        }

        public ColumnBuilder column(CmsResourceTableProperty prop, int flags) {
            ColumnEntry entry = new ColumnEntry();
            entry.setColumn(prop);
            entry.setFlags(flags);
            this.m_columnEntries.add(entry);
            return this;
        }
    }
}

