/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import com.google.common.collect.Lists;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.FontIcon;
import com.vaadin.server.Resource;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.db.CmsModificationContext;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeFolderExtended;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsSecurityException;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsResourceIcon
extends Label {
    public static final String ICON_CLASS_CHANGED = "oc-icon-16-overlay-changed";
    public static final String ICON_CLASS_ONLINE_FOLDER = "oc-icon-16-online-folder";
    public static final String ICON_CLASS_LOCK_OTHER = "oc-icon-16-lock-other";
    public static final String ICON_CLASS_LOCK_OWN = "oc-icon-16-lock-own";
    public static final String ICON_CLASS_LOCK_PUBLISH = "oc-icon-16-lock-publish";
    public static final String ICON_CLASS_LOCK_SHARED = "oc-icon-16-lock-shared";
    public static final String ICON_CLASS_SIBLING = "oc-icon-16-overlay-sibling";
    private static final Log LOG = CmsLog.getLog(CmsResourceIcon.class);
    private static final long serialVersionUID = 5031544534869165777L;

    public CmsResourceIcon() {
        this.setPrimaryStyleName("o-resource-icon");
        this.setContentMode(ContentMode.HTML);
    }

    public CmsResourceIcon(CmsResourceUtil resUtil, CmsResourceState state, boolean showLocks) {
        this();
        this.initContent(resUtil, state, showLocks, true);
    }

    public static String getDefaultFileOrDetailType(CmsObject cms, CmsResource resource) {
        String type = null;
        if (resource.isFolder() && !(OpenCms.getResourceManager().getResourceType(resource) instanceof CmsResourceTypeFolderExtended) && !CmsJspNavBuilder.isNavLevelFolder(cms, resource)) {
            try {
                CmsResource defaultFile = cms.readDefaultFile(resource, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                if (defaultFile != null && (type = CmsResourceIcon.getDetailType(cms, defaultFile, resource)) == null) {
                    type = OpenCms.getResourceManager().getResourceType(defaultFile).getTypeName();
                }
            }
            catch (CmsSecurityException cmsSecurityException) {}
        } else if (CmsResourceTypeXmlContainerPage.isContainerPage(resource)) {
            type = CmsResourceIcon.getDetailType(cms, resource, null);
        }
        return type;
    }

    public static String getDetailType(CmsObject cms, CmsResource detailPage, CmsResource parentFolder) {
        String type;
        block5: {
            type = null;
            try {
                if (!OpenCms.getADEManager().isDetailPage(cms, detailPage)) break block5;
                List<CmsDetailPageInfo> detailPages = OpenCms.getADEManager().getRawDetailPages(cms);
                if (parentFolder == null) {
                    parentFolder = cms.readParentFolder(detailPage.getStructureId());
                }
                for (CmsDetailPageInfo info : detailPages) {
                    if (!info.getId().equals(detailPage.getStructureId()) && !info.getId().equals(parentFolder.getStructureId())) continue;
                    type = info.getType();
                    if (type.startsWith("function@")) {
                        type = "function";
                    }
                    break;
                }
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
        return type;
    }

    public static String getIconHTML(CmsResourceUtil resUtil, CmsResourceState state, boolean showLocks) {
        return "<span class=\"o-resource-icon\">" + CmsResourceIcon.getIconInnerHTML(resUtil, state, showLocks, true) + "</span>";
    }

    public static Resource getSitemapResourceIcon(CmsObject cms, CmsResource resource, IconMode iconMode) {
        boolean skipDefaultFile;
        CmsResource defaultFile = null;
        ArrayList resourcesForType = Lists.newArrayList();
        resourcesForType.add(resource);
        boolean bl = skipDefaultFile = iconMode == IconMode.sitemapSelect && OpenCms.getResourceManager().matchResourceType("subsitemap", resource.getTypeId());
        if (resource.isFolder() && !skipDefaultFile) {
            try {
                defaultFile = cms.readDefaultFile(resource, CmsResourceFilter.IGNORE_EXPIRATION);
                if (defaultFile != null) {
                    resourcesForType.add(0, defaultFile);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (CmsJspNavBuilder.isNavLevelFolder(cms, resource)) {
            return new CmsCssIcon("oc-icon-24-navlevel");
        }
        CmsResource maybePage = (CmsResource)resourcesForType.get(0);
        if (CmsResourceTypeXmlContainerPage.isContainerPage(maybePage)) {
            CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, maybePage.getRootPath());
            for (CmsDetailPageInfo realInfo : config.getAllDetailPages(true)) {
                CmsExplorerTypeSettings settings;
                if (!realInfo.getUri().equals(maybePage.getRootPath()) && !realInfo.getUri().equals(CmsResource.getParentFolder(maybePage.getRootPath())) || (settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(realInfo.getIconType())) == null) continue;
                return CmsResourceUtil.getBigIconResource(settings, resource.getName());
            }
        }
        Resource result = null;
        for (CmsResource res : resourcesForType) {
            I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(res);
            CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type.getTypeName());
            if (settings == null) continue;
            result = CmsResourceUtil.getBigIconResource(settings, res.getName());
            break;
        }
        return result;
    }

    public static String getTreeCaptionHTML(String resourceName, CmsResourceUtil resUtil, CmsResourceState state, boolean showLocks) {
        return CmsResourceIcon.getIconHTML(resUtil, null, false) + "<span class=\"o-tree-caption\">" + resourceName + "</span>";
    }

    private static String getIconInnerHTML(CmsResourceUtil resUtil, CmsResourceState state, boolean showLocks, boolean showDetailIcon) {
        Resource iconResource = resUtil.getBigIconResource();
        return CmsResourceIcon.getIconInnerHTML(resUtil, iconResource, state, showLocks, showDetailIcon);
    }

    private static String getIconInnerHTML(CmsResourceUtil resUtil, Resource iconResource, CmsResourceState state, boolean showLocks, boolean showDetailIcon) {
        Object content = iconResource instanceof FontIcon ? ((FontIcon)iconResource).getHtml() : (iconResource instanceof ExternalResource ? "<img src=\"" + ((ExternalResource)iconResource).getURL() + "\" />" : "");
        boolean isNavLevel = false;
        if (resUtil != null) {
            if (showDetailIcon && !isNavLevel) {
                String smallIconUri;
                String detailType;
                if (resUtil.getResource().isFolder()) {
                    detailType = CmsResourceIcon.getDefaultFileOrDetailType(resUtil.getCms(), resUtil.getResource());
                    if (detailType != null && (smallIconUri = CmsResourceIcon.getSmallTypeIconHTML(detailType, false)) != null) {
                        content = (String)content + smallIconUri;
                    }
                } else if (CmsResourceTypeXmlContainerPage.isContainerPage(resUtil.getResource()) && (detailType = CmsResourceIcon.getDefaultFileOrDetailType(resUtil.getCms(), resUtil.getResource())) != null && (smallIconUri = CmsResourceIcon.getSmallTypeIconHTML(detailType, true)) != null) {
                    content = (String)content + smallIconUri;
                }
            }
            if (showLocks) {
                String lockIcon;
                String message = null;
                if (resUtil.getLock().getSystemLock().isPublish()) {
                    lockIcon = "o-lock-publish oc-icon-16-lock-publish";
                    message = CmsVaadinUtils.getMessageText("GUI_PUBLISH_TOOLTIP_0", new Object[0]);
                } else {
                    switch (resUtil.getLockState()) {
                        case 1: {
                            lockIcon = "o-lock-other oc-icon-16-lock-other";
                            break;
                        }
                        case 2: {
                            lockIcon = "o-lock-shared oc-icon-16-lock-shared";
                            break;
                        }
                        case 3: {
                            lockIcon = "o-lock-user oc-icon-16-lock-own";
                            break;
                        }
                        default: {
                            lockIcon = null;
                        }
                    }
                    if (lockIcon != null) {
                        message = CmsVaadinUtils.getMessageText("GUI_EXPLORER_LIST_ACTION_LOCK_NAME_2", resUtil.getLockedByName(), resUtil.getLockedInProjectName());
                    }
                }
                if (lockIcon != null) {
                    content = (String)content + CmsResourceIcon.getOverlaySpan(lockIcon, message);
                }
            }
        }
        boolean isOnlineFolder = false;
        if (resUtil != null) {
            CmsResource resource = resUtil.getResource();
            if (CmsModificationContext.getOnlineFolderOptions().getPaths().stream().anyMatch(onlineFolder -> CmsStringUtil.isPrefixPath(onlineFolder, resource.getRootPath()))) {
                content = (String)content + CmsResourceIcon.getOverlaySpan("oc-icon-16-online-folder o-online-folder", null);
                isOnlineFolder = true;
            }
        }
        if (state != null && !isOnlineFolder) {
            String title;
            String string = title = resUtil != null ? CmsVaadinUtils.getMessageText("GUI_LABEL_USER_LAST_MODIFIED_0", new Object[0]) + " " + resUtil.getUserLastModified() : null;
            if (state.isChanged() || state.isDeleted()) {
                content = (String)content + CmsResourceIcon.getOverlaySpan("o-state-changed oc-icon-16-overlay-changed", title);
            } else if (state.isNew()) {
                content = (String)content + CmsResourceIcon.getOverlaySpan("o-state-new oc-icon-16-overlay-changed", title);
            }
        }
        if (resUtil != null && resUtil.getLinkType() == 1) {
            content = (String)content + CmsResourceIcon.getOverlaySpan("o-sibling oc-icon-16-overlay-sibling", null);
        }
        return content;
    }

    private static String getOverlaySpan(String cssClass, String title) {
        StringBuffer result = new StringBuffer();
        result.append("<span class=\"").append(cssClass).append("\"");
        if (title != null) {
            result.append(" title=\"").append(title).append("\"");
        }
        result.append("></span>");
        return result.toString();
    }

    private static String getSmallTypeIconHTML(String type, boolean isPageOverlay) {
        String overlayClass;
        CmsExplorerTypeSettings typeSettings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type);
        if (typeSettings == null && LOG.isWarnEnabled()) {
            LOG.warn((Object)("Could not read explorer type settings for " + type));
        }
        String result = null;
        String string = overlayClass = isPageOverlay ? "o-page-icon-overlay" : "o-icon-overlay";
        if (typeSettings != null) {
            result = typeSettings.getSmallIconStyle() != null ? "<span class=\"v-icon " + overlayClass + " " + typeSettings.getSmallIconStyle() + "\">&nbsp;</span>" : (typeSettings.getIcon() != null ? "<img src=\"" + CmsWorkplace.getResourceUri("filetypes/" + typeSettings.getIcon()) + "\" class=\"" + overlayClass + "\" />" : "<span class=\"v-icon " + overlayClass + " oc-icon-16-default\">&nbsp;</span>");
        }
        return result;
    }

    public void initContent(CmsResourceUtil resUtil, CmsResourceState state, boolean showLocks, boolean showDetailIcon) {
        this.setValue(CmsResourceIcon.getIconInnerHTML(resUtil, state, showLocks, showDetailIcon));
    }

    public void initContent(CmsResourceUtil resUtil, Resource iconResource, CmsResourceState state, boolean showLocks, boolean showDetailIcon) {
        this.setValue(CmsResourceIcon.getIconInnerHTML(resUtil, iconResource, state, showLocks, showDetailIcon));
    }

    public static enum IconMode {
        localeCompare,
        sitemapSelect;

    }
}

