/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import au.com.bytecode.opencsv.CSVWriter;
import com.google.common.collect.Lists;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import com.vaadin.event.FieldEvents;
import com.vaadin.event.ShortcutListener;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.shared.Registration;
import com.vaadin.ui.Component;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.util.DefaultItemSorter;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.filter.Or;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.AbstractTextField;
import com.vaadin.v7.ui.DefaultFieldFactory;
import com.vaadin.v7.ui.Field;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.TableFieldFactory;
import com.vaadin.v7.ui.TextField;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.I_CmsEditPropertyContext;
import org.opencms.ui.actions.I_CmsDefaultAction;
import org.opencms.ui.apps.CmsFileExplorerSettings;
import org.opencms.ui.apps.I_CmsContextProvider;
import org.opencms.ui.components.CmsResourceTable;
import org.opencms.ui.components.CmsResourceTableProperty;
import org.opencms.ui.components.I_CmsFilePropertyEditHandler;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.contextmenu.CmsResourceContextMenuBuilder;
import org.opencms.ui.contextmenu.I_CmsContextMenuBuilder;
import org.opencms.ui.util.I_CmsItemSorter;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsFileTable
extends CmsResourceTable {
    public static final Map<CmsResourceTableProperty, Integer> DEFAULT_TABLE_PROPERTIES;
    static final Log LOG;
    private static final long serialVersionUID = 5460048685141699277L;
    protected List<CmsResource> m_currentResources = new ArrayList<CmsResource>();
    CmsResourceTableProperty m_actionColumnProperty;
    List<Table.CellStyleGenerator> m_additionalStyleGenerators;
    I_CmsFilePropertyEditHandler m_editHandler;
    FileEditHandler m_fileEditHandler = new FileEditHandler();
    CmsContextMenu m_menu;
    I_CmsContextMenuBuilder m_menuBuilder;
    private Table.TableDragMode m_beforEditDragMode;
    private Registration m_columnEditEnterRegistration;
    private Registration m_columnEditEscRegistration;
    private I_CmsContextProvider m_contextProvider;
    private CmsUUID m_editItemId;
    private CmsResourceTableProperty m_editProperty;
    private List<Collection<Container.Filter>> m_filterStack = new ArrayList<Collection<Container.Filter>>();
    private I_FolderSelectHandler m_folderSelectHandler;
    private String m_originalEditValue;

    public CmsFileTable(I_CmsContextProvider contextProvider) {
        this(contextProvider, DEFAULT_TABLE_PROPERTIES);
    }

    public CmsFileTable(I_CmsContextProvider contextProvider, Map<CmsResourceTableProperty, Integer> tableColumns) {
        this.m_additionalStyleGenerators = new ArrayList<Table.CellStyleGenerator>();
        this.m_actionColumnProperty = CmsResourceTableProperty.PROPERTY_RESOURCE_NAME;
        this.m_contextProvider = contextProvider;
        this.m_container.setItemSorter(new FileSorter());
        this.m_fileTable.addStyleName("borderless");
        this.m_fileTable.addStyleName("o-simple-drag");
        this.m_fileTable.setSizeFull();
        this.m_fileTable.setColumnCollapsingAllowed(true);
        this.m_fileTable.setSelectable(true);
        this.m_fileTable.setMultiSelect(true);
        this.m_fileTable.setTableFieldFactory((TableFieldFactory)new FileFieldFactory());
        CmsResourceTable.ColumnBuilder builder = new CmsResourceTable.ColumnBuilder(this);
        for (Map.Entry<CmsResourceTableProperty, Integer> entry : tableColumns.entrySet()) {
            builder.column(entry.getKey(), entry.getValue());
        }
        builder.buildColumns();
        this.m_fileTable.setSortContainerPropertyId((Object)CmsResourceTableProperty.PROPERTY_RESOURCE_NAME);
        this.m_menu = new CmsContextMenu();
        this.m_fileTable.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                Set selectedIds = (Set)event.getProperty().getValue();
                ArrayList<CmsResource> selectedResources = new ArrayList<CmsResource>();
                for (String id : selectedIds) {
                    try {
                        CmsResource resource = A_CmsUI.getCmsObject().readResource(CmsFileTable.this.getUUIDFromItemID(id), CmsResourceFilter.ALL);
                        selectedResources.add(resource);
                    }
                    catch (CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                CmsFileTable.this.m_currentResources = selectedResources;
                CmsFileTable.this.rebuildMenu();
            }
        });
        this.m_fileTable.addItemClickListener(new ItemClickEvent.ItemClickListener(){
            private static final long serialVersionUID = 1L;

            public void itemClick(ItemClickEvent event) {
                CmsFileTable.this.handleFileItemClick(event);
            }
        });
        this.m_fileTable.setCellStyleGenerator(new Table.CellStyleGenerator(){
            private static final long serialVersionUID = 1L;

            public String getStyle(Table source, Object itemId, Object propertyId) {
                Item item = CmsFileTable.this.m_container.getItem(itemId);
                Object style = CmsFileTable.getStateStyle(item);
                if (CmsFileTable.this.m_actionColumnProperty == propertyId) {
                    style = (String)style + " o-hover-column";
                } else if ((CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT == propertyId || CmsResourceTableProperty.PROPERTY_TITLE == propertyId) && item.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_IN_NAVIGATION) != null && ((Boolean)item.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_IN_NAVIGATION).getValue()).booleanValue()) {
                    style = (String)style + " o-in-navigation";
                }
                for (Table.CellStyleGenerator generator : CmsFileTable.this.m_additionalStyleGenerators) {
                    String additional = generator.getStyle(source, itemId, propertyId);
                    if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(additional)) continue;
                    style = (String)style + " " + additional;
                }
                return style;
            }
        });
        this.m_menu.setAsTableContextMenu(this.m_fileTable);
    }

    public static String getStateStyle(Item resourceItem) {
        Object result = "";
        if (resourceItem != null) {
            if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_INSIDE_PROJECT) == null || ((Boolean)resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_INSIDE_PROJECT).getValue()).booleanValue()) {
                CmsResourceState state = (CmsResourceState)resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_STATE).getValue();
                result = CmsFileTable.getStateStyle(state);
            } else {
                result = "o-project-other";
            }
            if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_RELEASED_NOT_EXPIRED) != null && !((Boolean)resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_RELEASED_NOT_EXPIRED).getValue()).booleanValue()) {
                result = (String)result + " o-expired";
            }
            if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_DISABLED) != null && ((Boolean)resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_DISABLED).getValue()).booleanValue()) {
                result = (String)result + " o-disabled";
            }
        }
        return result;
    }

    public void addAdditionalStyleGenerator(Table.CellStyleGenerator styleGenerator) {
        this.m_additionalStyleGenerators.add(styleGenerator);
    }

    public void applyWorkplaceAppSettings() {
        this.m_container.addContainerProperty(CmsResourceTableProperty.PROPERTY_SITE_PATH, CmsResourceTableProperty.PROPERTY_SITE_PATH.getColumnType(), CmsResourceTableProperty.PROPERTY_SITE_PATH.getDefaultValue());
        Object[] visibleCols = this.m_fileTable.getVisibleColumns();
        for (int i = 0; i < visibleCols.length; ++i) {
            if (!CmsResourceTableProperty.PROPERTY_RESOURCE_NAME.equals(visibleCols[i])) continue;
            visibleCols[i] = CmsResourceTableProperty.PROPERTY_SITE_PATH;
        }
        this.m_fileTable.setVisibleColumns(visibleCols);
        this.m_fileTable.setColumnCollapsible((Object)CmsResourceTableProperty.PROPERTY_SITE_PATH, false);
        this.m_fileTable.setColumnHeader((Object)CmsResourceTableProperty.PROPERTY_SITE_PATH, CmsVaadinUtils.getMessageText(CmsResourceTableProperty.PROPERTY_SITE_PATH.getHeaderKey(), new Object[0]));
        try {
            CmsFileExplorerSettings settings = OpenCms.getWorkplaceAppManager().getAppSettings(A_CmsUI.getCmsObject(), CmsFileExplorerSettings.class);
            this.setTableState(settings);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while reading file explorer settings from user.", (Throwable)e);
        }
        this.m_fileTable.setSortContainerPropertyId((Object)CmsResourceTableProperty.PROPERTY_SITE_PATH);
        this.setActionColumnProperty(CmsResourceTableProperty.PROPERTY_SITE_PATH);
        this.setMenuBuilder(new CmsResourceContextMenuBuilder());
    }

    public void clearFilters() {
        IndexedContainer container = (IndexedContainer)this.m_fileTable.getContainerDataSource();
        container.removeAllContainerFilters();
    }

    public boolean containsId(CmsUUID structureId) {
        return this.m_fileTable.getContainerDataSource().getItem((Object)String.valueOf(structureId)) != null;
    }

    public void filterTable(String search) {
        this.m_container.removeAllContainerFilters();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(search)) {
            this.m_container.addContainerFilter((Container.Filter)new Or(new Container.Filter[]{new SimpleStringFilter((Object)CmsResourceTableProperty.PROPERTY_RESOURCE_NAME, search, true, false), new SimpleStringFilter((Object)CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT, search, true, false), new SimpleStringFilter((Object)CmsResourceTableProperty.PROPERTY_TITLE, search, true, false), new SimpleStringFilter((Object)CmsResourceTableProperty.PROPERTY_CATEGORIES, search, true, false)}));
        }
        if (this.m_fileTable.getValue() != null & !((Set)this.m_fileTable.getValue()).isEmpty()) {
            this.m_fileTable.setCurrentPageFirstItemId(((Set)this.m_fileTable.getValue()).iterator().next());
        }
    }

    public byte[] generateCsv() {
        try {
            Container container = this.m_fileTable.getContainerDataSource();
            Object[] columnArray = this.m_fileTable.getVisibleColumns();
            HashSet<Object> columns = new HashSet<Object>(Arrays.asList(columnArray));
            LinkedHashMap columnFormatters = new LinkedHashMap();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8));
            ArrayList<String> csvHeaders = new ArrayList<String>();
            ArrayList<CmsResourceTableProperty> csvColumns = new ArrayList<CmsResourceTableProperty>();
            for (Object object : this.m_fileTable.getVisibleColumns()) {
                Class<?> colType;
                if (!(object instanceof CmsResourceTableProperty)) continue;
                CmsResourceTableProperty tableProp = (CmsResourceTableProperty)object;
                if (this.m_fileTable.isColumnCollapsed(object) || (colType = tableProp.getColumnType()).getName().contains("vaadin")) continue;
                String colHeader = OpenCms.getWorkplaceManager().getMessages(Locale.ENGLISH).key(tableProp.getHeaderKey());
                csvHeaders.add(colHeader);
                csvColumns.add(tableProp);
            }
            String[] emptyArray = new String[]{};
            writer.writeNext(csvHeaders.toArray(emptyArray));
            SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            iso8601.setTimeZone(TimeZone.getTimeZone("UTC"));
            HashSet<CmsResourceTableProperty> dateCols = new HashSet<CmsResourceTableProperty>(Arrays.asList(CmsResourceTableProperty.PROPERTY_DATE_CREATED, CmsResourceTableProperty.PROPERTY_DATE_MODIFIED, CmsResourceTableProperty.PROPERTY_DATE_RELEASED, CmsResourceTableProperty.PROPERTY_DATE_EXPIRED));
            for (Object itemId : this.m_fileTable.getContainerDataSource().getItemIds()) {
                Item item = this.m_fileTable.getContainerDataSource().getItem(itemId);
                ArrayList<String> row = new ArrayList<String>();
                for (CmsResourceTableProperty col : csvColumns) {
                    Object value = item.getItemProperty((Object)col).getValue();
                    String csvValue = "";
                    if (value != null) {
                        csvValue = dateCols.contains(col) && value instanceof Long ? iso8601.format(new Date((Long)value)) : value.toString();
                    }
                    row.add(csvValue);
                }
                writer.writeNext(row.toArray(emptyArray));
            }
            writer.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public I_CmsContextProvider getContextProvider() {
        return this.m_contextProvider;
    }

    public int getFirstVisibleItemIndex() {
        return this.m_fileTable.getCurrentPageFirstItemIndex();
    }

    public Collection<CmsUUID> getSelectedIds() {
        return this.itemIdsToUUIDs((Collection)this.m_fileTable.getValue());
    }

    public List<CmsResource> getSelectedResources() {
        return this.m_currentResources;
    }

    public CmsFileExplorerSettings getTableSettings() {
        CmsFileExplorerSettings fileTableState = new CmsFileExplorerSettings();
        fileTableState.setSortAscending(this.m_fileTable.isSortAscending());
        fileTableState.setSortColumnId((CmsResourceTableProperty)this.m_fileTable.getSortContainerPropertyId());
        ArrayList<CmsResourceTableProperty> collapsedCollumns = new ArrayList<CmsResourceTableProperty>();
        ArrayList<CmsResourceTableProperty> uncollapsedColumns = new ArrayList<CmsResourceTableProperty>();
        Object[] visibleCols = this.m_fileTable.getVisibleColumns();
        for (int i = 0; i < visibleCols.length; ++i) {
            if (this.m_fileTable.isColumnCollapsed(visibleCols[i])) {
                collapsedCollumns.add((CmsResourceTableProperty)visibleCols[i]);
                continue;
            }
            uncollapsedColumns.add((CmsResourceTableProperty)visibleCols[i]);
        }
        fileTableState.setCollapsedColumns(collapsedCollumns);
        fileTableState.setUncollapsedColumns(uncollapsedColumns);
        return fileTableState;
    }

    public void handleSelection(String itemId) {
        Collection selection = (Collection)this.m_fileTable.getValue();
        if (selection == null) {
            this.m_fileTable.select((Object)itemId);
        } else if (!selection.contains(itemId)) {
            this.m_fileTable.setValue(null);
            this.m_fileTable.select((Object)itemId);
        }
    }

    public boolean isEditing() {
        return this.m_editItemId != null;
    }

    public boolean isEditProperty(CmsResourceTableProperty propertyId) {
        return this.m_editProperty != null && this.m_editProperty.equals(propertyId);
    }

    public void openContextMenu(ItemClickEvent event) {
        this.m_menu.openForTable(event, this.m_fileTable);
    }

    public void removeAdditionalStyleGenerator(Table.CellStyleGenerator styleGenerator) {
        this.m_additionalStyleGenerators.remove(styleGenerator);
    }

    public void restoreFilters() {
        if (this.m_filterStack.size() > 0) {
            IndexedContainer container = (IndexedContainer)this.m_fileTable.getContainerDataSource();
            container.removeAllContainerFilters();
            Collection<Container.Filter> filters = this.m_filterStack.remove(this.m_filterStack.size() - 1);
            for (Container.Filter filter : filters) {
                container.addContainerFilter(filter);
            }
        } else {
            LOG.error((Object)"restoreFilter called but no saved filters available");
        }
    }

    public void saveFilters() {
        IndexedContainer container = (IndexedContainer)this.m_fileTable.getContainerDataSource();
        Collection filters = container.getContainerFilters();
        this.m_filterStack.add(new ArrayList(filters));
    }

    public void setActionColumnProperty(CmsResourceTableProperty actionColumnProperty) {
        this.m_actionColumnProperty = actionColumnProperty;
    }

    public void setContextProvider(I_CmsContextProvider provider) {
        this.m_contextProvider = provider;
    }

    public void setFirstVisibleItemIndex(int i) {
        this.m_fileTable.setCurrentPageFirstItemIndex(i);
    }

    public void setFolderSelectHandler(I_FolderSelectHandler folderSelectHandler) {
        this.m_folderSelectHandler = folderSelectHandler;
    }

    public void setMenuBuilder(I_CmsContextMenuBuilder builder) {
        this.m_menuBuilder = builder;
    }

    public void setTableState(CmsFileExplorerSettings state) {
        if (state != null) {
            this.m_fileTable.setSortContainerPropertyId((Object)state.getSortColumnId());
            this.m_fileTable.setSortAscending(state.isSortAscending());
            Object[] visibleCols = this.m_fileTable.getVisibleColumns();
            for (int i = 0; i < visibleCols.length; ++i) {
                boolean isCollapsed;
                if (!DEFAULT_TABLE_PROPERTIES.containsKey(visibleCols[i])) continue;
                if (state.getUncollapsedColumns() != null) {
                    isCollapsed = !state.getUncollapsedColumns().contains(visibleCols[i]);
                } else {
                    boolean bl = isCollapsed = state.getCollapsedColumns().contains(visibleCols[i]) || CmsResourceTableProperty.PROPERTY_CATEGORIES.equals(visibleCols[i]);
                }
                if (this.m_fileTable.isColumnCollapsible(visibleCols[i])) {
                    this.m_fileTable.setColumnCollapsed(visibleCols[i], isCollapsed);
                    continue;
                }
                LOG.debug((Object)("Skip collapsing none-collapsible column " + String.valueOf(visibleCols[i])));
            }
        }
    }

    public void startEdit(CmsUUID itemId, CmsResourceTableProperty propertyId, I_CmsFilePropertyEditHandler editHandler) {
        this.m_editItemId = itemId;
        this.m_editProperty = propertyId;
        this.m_originalEditValue = (String)this.m_container.getItem(this.m_editItemId.toString()).getItemProperty((Object)this.m_editProperty).getValue();
        this.m_editHandler = editHandler;
        this.m_beforEditDragMode = this.m_fileTable.getDragMode();
        this.m_fileTable.setDragMode(Table.TableDragMode.NONE);
        this.m_fileTable.setEditable(true);
    }

    public void stopEdit() {
        if (this.m_editHandler != null) {
            this.saveFilters();
            this.clearFilters();
            try {
                String value = (String)this.m_container.getItem(this.m_editItemId.toString()).getItemProperty((Object)this.m_editProperty).getValue();
                if (!value.equals(this.m_originalEditValue)) {
                    this.m_editHandler.validate(value);
                    this.m_editHandler.save(value);
                } else {
                    this.m_editHandler.cancel();
                }
            }
            finally {
                this.restoreFilters();
            }
        }
        this.clearEdit();
        this.m_fileTable.setDragMode(this.m_beforEditDragMode);
        this.m_beforEditDragMode = null;
    }

    public void update(Collection<CmsUUID> ids, boolean remove) {
        for (CmsUUID id : ids) {
            this.updateItem(id, remove);
        }
        this.rebuildMenu();
    }

    public void updateColumnWidths(int estimatedSpace) {
        Object[] cols = this.m_fileTable.getVisibleColumns();
        ArrayList expandCols = Lists.newArrayList();
        int nonExpandWidth = 0;
        int totalExpandMinWidth = 0;
        for (Object colObj : cols) {
            if (this.m_fileTable.isColumnCollapsed(colObj)) continue;
            CmsResourceTableProperty prop = (CmsResourceTableProperty)colObj;
            if (0.0f < this.m_fileTable.getColumnExpandRatio((Object)prop)) {
                expandCols.add(prop);
                totalExpandMinWidth += this.getAlternativeWidthForExpandingColumns(prop);
                continue;
            }
            nonExpandWidth += prop.getColumnWidth();
        }
        if (estimatedSpace < totalExpandMinWidth + nonExpandWidth) {
            for (CmsResourceTableProperty expandCol : expandCols) {
                this.m_fileTable.setColumnWidth((Object)expandCol, this.getAlternativeWidthForExpandingColumns(expandCol));
            }
        }
    }

    public void updateSorting() {
        this.m_fileTable.sort();
    }

    void cancelEdit() {
        if (this.m_editHandler != null) {
            this.m_editHandler.cancel();
        }
        this.clearEdit();
    }

    CmsUUID getEditItemId() {
        return this.m_editItemId;
    }

    CmsResourceTableProperty getEditProperty() {
        return this.m_editProperty;
    }

    void handleFileItemClick(ItemClickEvent event) {
        if (this.isEditing()) {
            this.stopEdit();
        } else if (!event.isCtrlKey() && !event.isShiftKey()) {
            String itemId = (String)event.getItemId();
            CmsUUID structureId = this.getUUIDFromItemID(itemId);
            boolean openedFolder = false;
            if (event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT)) {
                this.handleSelection(itemId);
                this.openContextMenu(event);
            } else if (event.getPropertyId() == null || CmsResourceTableProperty.PROPERTY_TYPE_ICON.equals(event.getPropertyId())) {
                this.handleSelection(itemId);
                this.openContextMenu(event);
            } else if (this.m_actionColumnProperty.equals(event.getPropertyId())) {
                Boolean isFolder = (Boolean)event.getItem().getItemProperty((Object)CmsResourceTableProperty.PROPERTY_IS_FOLDER).getValue();
                if (isFolder != null && isFolder.booleanValue()) {
                    if (this.m_folderSelectHandler != null) {
                        this.m_folderSelectHandler.onFolderSelect(structureId);
                    }
                    openedFolder = true;
                } else {
                    try {
                        CmsObject cms = A_CmsUI.getCmsObject();
                        CmsResource res = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                        this.m_currentResources = Collections.singletonList(res);
                        I_CmsDialogContext context = this.m_contextProvider.getDialogContext();
                        I_CmsDefaultAction action = OpenCms.getWorkplaceAppManager().getDefaultAction(context, this.m_menuBuilder);
                        if (action != null) {
                            action.executeAction(context);
                            return;
                        }
                    }
                    catch (CmsVfsResourceNotFoundException e) {
                        LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    catch (CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            } else {
                I_CmsDialogContext context = this.m_contextProvider.getDialogContext();
                if (this.m_currentResources.size() == 1 && this.m_currentResources.get(0).getStructureId().equals(structureId) && context instanceof I_CmsEditPropertyContext && ((I_CmsEditPropertyContext)((Object)context)).isPropertyEditable(event.getPropertyId())) {
                    ((I_CmsEditPropertyContext)((Object)context)).editProperty(event.getPropertyId());
                }
            }
            if (!openedFolder) {
                this.update(Collections.singletonList(structureId), false);
            }
        }
    }

    void rebuildMenu() {
        if (!this.getSelectedIds().isEmpty() && this.m_menuBuilder != null) {
            this.m_menu.removeAllItems();
            this.m_menuBuilder.buildContextMenu(this.getContextProvider().getDialogContext(), this.m_menu);
        }
    }

    private void clearColumnEditActions() {
        if (this.m_columnEditEnterRegistration != null) {
            this.m_columnEditEnterRegistration.remove();
            this.m_columnEditEnterRegistration = null;
        }
        if (this.m_columnEditEscRegistration != null) {
            this.m_columnEditEscRegistration.remove();
            this.m_columnEditEscRegistration = null;
        }
    }

    private void clearEdit() {
        this.m_fileTable.setEditable(false);
        if (this.m_editItemId != null) {
            try {
                this.saveFilters();
                this.clearFilters();
                this.updateItem(this.m_editItemId, false);
            }
            finally {
                this.restoreFilters();
            }
        }
        this.m_editItemId = null;
        this.m_editProperty = null;
        this.m_editHandler = null;
        this.clearColumnEditActions();
        this.updateSorting();
    }

    private int getAlternativeWidthForExpandingColumns(CmsResourceTableProperty prop) {
        if (prop.getId().equals(CmsResourceTableProperty.PROPERTY_RESOURCE_NAME.getId())) {
            return 200;
        }
        if (prop.getId().equals(CmsResourceTableProperty.PROPERTY_TITLE.getId())) {
            return 300;
        }
        if (prop.getId().equals(CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT.getId())) {
            return 200;
        }
        return 200;
    }

    private void updateItem(CmsUUID itemId, boolean remove) {
        if (remove) {
            String idStr = itemId != null ? itemId.toString() : null;
            this.m_container.removeItem(idStr);
            return;
        }
        CmsObject cms = A_CmsUI.getCmsObject();
        try {
            CmsResource resource = cms.readResource(itemId, CmsResourceFilter.ALL);
            this.fillItem(cms, resource, OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
        }
        catch (CmsVfsResourceNotFoundException e) {
            if (null != itemId) {
                this.m_container.removeItem(itemId.toString());
            }
            LOG.debug((Object)"Failed to update file table item, removing it from view.", (Throwable)e);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    static {
        LOG = CmsLog.getLog(CmsFileTable.class);
        LinkedHashMap<CmsResourceTableProperty, Integer> defaultProps = new LinkedHashMap<CmsResourceTableProperty, Integer>();
        defaultProps.put(CmsResourceTableProperty.PROPERTY_TYPE_ICON, 0);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_PROJECT, 1);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_RESOURCE_NAME, 0);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_TITLE, 0);
        try {
            if (OpenCms.getWorkplaceManager().isExplorerCategoriesEnabled()) {
                defaultProps.put(CmsResourceTableProperty.PROPERTY_CATEGORIES, 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        defaultProps.put(CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT, 1);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_NAVIGATION_POSITION, 2);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_IN_NAVIGATION, 2);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_COPYRIGHT, 1);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_CACHE, 1);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_RESOURCE_TYPE, 0);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_INTERNAL_RESOURCE_TYPE, 1);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_SIZE, 0);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_PERMISSIONS, 1);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_DATE_MODIFIED, 0);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_USER_MODIFIED, 1);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_DATE_CREATED, 1);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_USER_CREATED, 1);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_DATE_RELEASED, 0);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_DATE_EXPIRED, 0);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_STATE_NAME, 0);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_USER_LOCKED, 0);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_IS_FOLDER, 2);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_STATE, 2);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_INSIDE_PROJECT, 2);
        defaultProps.put(CmsResourceTableProperty.PROPERTY_RELEASED_NOT_EXPIRED, 2);
        DEFAULT_TABLE_PROPERTIES = Collections.unmodifiableMap(defaultProps);
    }

    public class FileEditHandler
    implements FieldEvents.BlurListener {
        private static final long serialVersionUID = -2286815522247807054L;

        public void blur(FieldEvents.BlurEvent event) {
            CmsFileTable.this.stopEdit();
        }
    }

    public static class FileSorter
    extends DefaultItemSorter
    implements I_CmsItemSorter {
        private static final long serialVersionUID = 1L;

        @Override
        public Collection<?> getSortableContainerPropertyIds(Container container) {
            HashSet result = new HashSet();
            for (Object propId : container.getContainerPropertyIds()) {
                Class propertyType = container.getType(propId);
                if (!Comparable.class.isAssignableFrom(propertyType) && !propertyType.isPrimitive() && (!propId.equals(CmsResourceTableProperty.PROPERTY_TYPE_ICON) || !container.getContainerPropertyIds().contains(CmsResourceTableProperty.PROPERTY_NAVIGATION_POSITION))) continue;
                result.add(propId);
            }
            return result;
        }

        protected int compareProperty(Object propertyId, boolean sortDirection, Item item1, Item item2) {
            if (CmsResourceTableProperty.PROPERTY_RESOURCE_NAME.equals(propertyId)) {
                Boolean isFolder2;
                Boolean isFolder1 = (Boolean)item1.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_IS_FOLDER).getValue();
                if (!isFolder1.equals(isFolder2 = (Boolean)item2.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_IS_FOLDER).getValue())) {
                    int result;
                    int n = result = isFolder1 != false ? -1 : 1;
                    if (!sortDirection) {
                        result *= -1;
                    }
                    return result;
                }
            } else {
                if ((CmsResourceTableProperty.PROPERTY_TYPE_ICON.equals(propertyId) || CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT.equals(propertyId)) && item1.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_NAVIGATION_POSITION) != null) {
                    int result;
                    Float pos1 = (Float)item1.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_NAVIGATION_POSITION).getValue();
                    Float pos2 = (Float)item2.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_NAVIGATION_POSITION).getValue();
                    if (pos1 == null) {
                        result = pos2 == null ? this.compareProperty(CmsResourceTableProperty.PROPERTY_RESOURCE_NAME, true, item1, item2) : 1;
                    } else {
                        int n = result = pos2 == null ? -1 : Float.compare(pos1.floatValue(), pos2.floatValue());
                    }
                    if (!sortDirection) {
                        result *= -1;
                    }
                    return result;
                }
                if (((CmsResourceTableProperty)propertyId).getColumnType().equals(String.class)) {
                    String value1 = (String)item1.getItemProperty(propertyId).getValue();
                    String value2 = (String)item2.getItemProperty(propertyId).getValue();
                    Collator collator = Collator.getInstance((ULocale)ULocale.ROOT);
                    int result = collator.compare(value1, value2);
                    if (!sortDirection) {
                        result = -result;
                    }
                    return result;
                }
            }
            return super.compareProperty(propertyId, sortDirection, item1, item2);
        }
    }

    public class FileFieldFactory
    extends DefaultFieldFactory {
        private static final long serialVersionUID = 3079590603587933576L;

        public Field<?> createField(Container container, Object itemId, Object propertyId, Component uiContext) {
            Field result = null;
            if (itemId.equals(CmsFileTable.this.getEditItemId().toString()) && CmsFileTable.this.isEditProperty((CmsResourceTableProperty)propertyId)) {
                result = super.createField(container, itemId, propertyId, uiContext);
                result.addStyleName("o-inline-textfield");
                result.addValidator((Validator)CmsFileTable.this.m_editHandler);
                if (result instanceof TextField) {
                    ((TextField)result).setComponentError(null);
                    CmsFileTable.this.clearColumnEditActions();
                    CmsFileTable.this.m_columnEditEscRegistration = CmsFileTable.this.addShortcutListener(new ShortcutListener("Cancel edit", 27, null){
                        private static final long serialVersionUID = 1L;

                        public void handleAction(Object sender, Object target) {
                            CmsFileTable.this.cancelEdit();
                        }
                    });
                    CmsFileTable.this.m_columnEditEnterRegistration = CmsFileTable.this.addShortcutListener(new ShortcutListener("Save", 13, null){
                        private static final long serialVersionUID = 1L;

                        public void handleAction(Object sender, Object target) {
                            CmsFileTable.this.stopEdit();
                        }
                    });
                    ((TextField)result).addBlurListener((FieldEvents.BlurListener)CmsFileTable.this.m_fileEditHandler);
                    ((TextField)result).setTextChangeEventMode(AbstractTextField.TextChangeEventMode.LAZY);
                    ((TextField)result).addTextChangeListener((FieldEvents.TextChangeListener)CmsFileTable.this.m_editHandler);
                }
                result.focus();
            }
            return result;
        }
    }

    public static interface I_FolderSelectHandler {
        public void onFolderSelect(CmsUUID var1);
    }
}

