/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.userdata;

import com.google.common.base.Supplier;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.FileDownloader;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.server.UserError;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.userdata.I_CmsUserDataDomain;
import org.opencms.jsp.userdata.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.I_CmsReport;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.userdata.CmsUserDataReportThread;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.editablegroup.CmsEditableGroup;
import org.opencms.ui.dialogs.permissions.CmsPrincipalSelect;
import org.opencms.ui.dialogs.permissions.CmsPrincipalSelectDialog;
import org.opencms.ui.report.CmsReportOverlay;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsUserDataAppPanel
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = CmsLog.getLog(CmsUserDataAppPanel.class);
    public static final String O_USERDATA_CONTAINER = "o-userdata-container";
    protected TextField m_email;
    protected FormLayout m_filters;
    protected Button m_searchByEmail;
    protected CmsEditableGroup m_filterGroup;
    protected VerticalLayout m_resultsContainer;
    protected Label m_resultsLabel;
    protected Button m_download;
    protected Button m_pickUserButton;
    protected TextField m_user;
    protected Button m_searchByUser;
    protected String m_result;
    protected AtomicReference<CmsReportOverlay> m_reportOverlay = new AtomicReference();

    public CmsUserDataAppPanel() {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), new HashMap<String, String>());
        this.m_resultsLabel.setContentMode(ContentMode.HTML);
        this.m_resultsLabel.setWidth("100%");
        this.m_resultsLabel.addStyleName(O_USERDATA_CONTAINER);
        this.m_resultsContainer.setVisible(false);
        this.m_filterGroup = new CmsEditableGroup((AbstractOrderedLayout)this.m_filters, (Supplier<Component>)((Supplier)() -> {
            TextField filterField = new TextField();
            return filterField;
        }), CmsVaadinUtils.getMessageText("GUI_USERDATA_TEXT_FILTER_ADD_0", new Object[0]));
        this.m_filterGroup.setRowCaption(CmsVaadinUtils.getMessageText("GUI_USERDATA_TEXT_FILTER_0", new Object[0]));
        this.m_filterGroup.addRow((Component)new TextField());
        FileDownloader downloader = new FileDownloader((Resource)new StreamResource((StreamResource.StreamSource & Serializable)() -> {
            String result = this.getResult();
            byte[] resultBytes = result.getBytes(StandardCharsets.UTF_8);
            return new ByteArrayInputStream(resultBytes);
        }, "userdata.html"));
        downloader.extend((AbstractComponent)this.m_download);
        this.m_download.setIcon((Resource)VaadinIcons.DOWNLOAD);
        this.m_pickUserButton.setCaption("");
        this.m_pickUserButton.setIcon((Resource)FontAwesome.USER);
        this.m_pickUserButton.addStyleName("o-button-icon");
        this.m_pickUserButton.addClickListener((Button.ClickListener & Serializable)evt -> {
            Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.max);
            CmsPrincipalSelectDialog dialog = new CmsPrincipalSelectDialog(principal -> this.selectUser(principal), "", window, CmsPrincipalSelect.WidgetType.userwidget, true, CmsPrincipalSelect.PrincipalType.user);
            dialog.setOuComboBoxEnabled(true);
            window.setCaption(CmsVaadinUtils.getMessageText("GUI_USERDATA_SELECT_USER_0", new Object[0]));
            window.setContent((Component)dialog);
            A_CmsUI.get().addWindow(window);
        });
        this.m_searchByEmail.addClickListener((Button.ClickListener & Serializable)event -> {
            this.hideResult();
            ArrayList filterStrings = new ArrayList();
            this.m_filterGroup.getRows().stream().forEach(row -> {
                TextField textField;
                String value;
                if (row.getComponent() instanceof TextField && !CmsStringUtil.isEmptyOrWhitespaceOnly(value = (textField = (TextField)row.getComponent()).getValue())) {
                    value = value.trim();
                    filterStrings.add(value);
                }
            });
            String email = this.m_email.getValue().trim();
            CmsObject cms = this.getCmsObjectForReport();
            try {
                Document doc = Jsoup.parseBodyFragment((String)"");
                doc.body().addClass(O_USERDATA_CONTAINER);
                doc.head().append("<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\" />");
                try (InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("VAADIN/themes/opencms/userdata.css");){
                    String style = new String(CmsFileUtil.readFully(stream, false), StandardCharsets.UTF_8);
                    doc.head().append("<style>\n" + style + "\n</style>\n");
                }
                Status status = new Status();
                ArrayList<String> headerSearchTerms = new ArrayList<String>();
                if (!CmsStringUtil.isEmptyOrWhitespaceOnly(email)) {
                    headerSearchTerms.add(email);
                }
                headerSearchTerms.addAll(filterStrings);
                String headerSearchTermsString = headerSearchTerms.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", "));
                doc.body().appendElement("h1").attr("class", "udr-header").text(Messages.get().getBundle(cms.getRequestContext().getLocale()).key("GUI_USER_INFORMATION_FOR_1", headerSearchTermsString));
                CmsUserDataReportThread thread = new CmsUserDataReportThread(cms, report -> {
                    try {
                        boolean changed = OpenCms.getUserDataRequestManager().getInfoForEmail(cms, I_CmsUserDataDomain.Mode.workplace, email, filterStrings, doc.body(), (I_CmsReport)report);
                        status.setChanged(changed);
                    }
                    catch (CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        status.setException(e);
                    }
                });
                if (this.m_reportOverlay.get() != null) {
                    this.removeComponent((Component)this.m_reportOverlay.get());
                    this.m_reportOverlay.set(null);
                }
                this.m_reportOverlay.set(new CmsReportOverlay(thread));
                this.addComponent((Component)this.m_reportOverlay.get());
                this.m_reportOverlay.get().addReportFinishedHandler(() -> {
                    if (status.getException() != null) {
                        CmsErrorDialog.showErrorDialog(status.getException());
                    } else if (status.isChanged()) {
                        this.showResult(doc);
                    } else {
                        this.showResult(null);
                    }
                });
                thread.start();
            }
            catch (Exception e) {
                CmsErrorDialog.showErrorDialog(e);
            }
        });
        this.m_searchByUser.addClickListener((Button.ClickListener & Serializable)evt -> {
            this.hideResult();
            this.m_user.setComponentError(null);
            String user = this.m_user.getValue().trim();
            CmsObject cms = this.getCmsObjectForReport();
            CmsUser userObj = null;
            try {
                userObj = cms.readUser(user);
            }
            catch (Exception e) {
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                this.m_user.setComponentError((ErrorMessage)new UserError(CmsVaadinUtils.getMessageText("GUI_USERDATA_USER_NOT_FOUND_0", new Object[0])));
                return;
            }
            CmsUser finalUser = userObj;
            try {
                Document doc = Jsoup.parseBodyFragment((String)"");
                Status status = new Status();
                doc.body().appendElement("h1").attr("class", "udr-header").text(Messages.get().getBundle(cms.getRequestContext().getLocale()).key("GUI_USER_INFORMATION_FOR_1", user));
                CmsUserDataReportThread thread = new CmsUserDataReportThread(cms, report -> {
                    try {
                        boolean changed = OpenCms.getUserDataRequestManager().getInfoForUser(cms, I_CmsUserDataDomain.Mode.workplace, finalUser, doc.body(), (I_CmsReport)report);
                        status.setChanged(changed);
                    }
                    catch (CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        status.setException(e);
                    }
                });
                if (this.m_reportOverlay.get() != null) {
                    this.removeComponent((Component)this.m_reportOverlay.get());
                    this.m_reportOverlay.set(null);
                }
                this.m_reportOverlay.set(new CmsReportOverlay(thread));
                this.addComponent((Component)this.m_reportOverlay.get());
                this.m_reportOverlay.get().addReportFinishedHandler(() -> {
                    if (status.getException() != null) {
                        CmsErrorDialog.showErrorDialog(status.getException());
                    } else if (status.isChanged()) {
                        this.showResult(doc);
                    } else {
                        this.showResult(null);
                    }
                });
                thread.start();
            }
            catch (Exception e) {
                CmsErrorDialog.showErrorDialog(e);
            }
        });
    }

    protected CmsObject getCmsObjectForReport() {
        CmsObject cms = A_CmsUI.getCmsObject();
        try {
            cms = OpenCms.initCmsObject(cms);
            cms.getRequestContext().setLocale(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return cms;
    }

    protected String getResult() {
        return this.m_result;
    }

    private void hideResult() {
        this.m_resultsLabel.setValue("");
        this.m_resultsContainer.setVisible(false);
    }

    private void selectUser(I_CmsPrincipal principal) {
        CmsUser user = (CmsUser)principal;
        this.m_user.setComponentError(null);
        this.m_user.setValue(user.getName());
    }

    private void showResult(Document doc) {
        if (doc != null) {
            this.m_resultsContainer.setVisible(true);
            this.m_resultsLabel.setValue(doc.body().html());
            this.m_result = "<!DOCTYPE html>\n" + doc.toString();
        } else {
            this.hideResult();
            String notfound = CmsVaadinUtils.getMessageText("GUI_USERDATA_NOT_FOUND_0", new Object[0]);
            Notification notification = new Notification("", "<p>" + CmsEncoder.escapeXml(notfound) + "</p>", Notification.Type.WARNING_MESSAGE, true);
            notification.setDelayMsec(-1);
            notification.show(Page.getCurrent());
        }
    }

    private class Status {
        private volatile boolean m_changed;
        private volatile Exception m_exception;

        private Status() {
        }

        public Exception getException() {
            return this.m_exception;
        }

        public boolean isChanged() {
            return this.m_changed;
        }

        public void setChanged(boolean changed) {
            this.m_changed = changed;
        }

        public void setException(Exception exception) {
            this.m_exception = exception;
        }
    }
}

