/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.data.HasValue;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.ui.Label;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsUser;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.user.A_CmsImportExportUserDialog;
import org.opencms.ui.apps.user.I_CmsOuTreeType;
import org.opencms.util.CmsUUID;

public class CmsUserCsvExportDialog
extends A_CmsImportExportUserDialog {
    private List<CmsUser> m_user;
    private Button m_cancel;
    private Button m_download;
    private Label m_elementToExportOU;
    private Label m_elementToExportGroup;
    private Label m_elementToExportRole;
    private CheckBox m_includeTechnicalFields;
    private Label m_elementExtendedDataUser;
    private Label m_elementExtendedDataRole;
    private Label m_elementToExportCount;

    CmsUserCsvExportDialog(List<CmsUser> userToExport, String ou, I_CmsOuTreeType type, String elementName, boolean extendedData, Window window, boolean includeTechnicalFields) {
        window.setCaption(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_IMEXPORT_EXPORT_0", new Object[0]));
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_includeTechnicalFields.addValueChangeListener((HasValue.ValueChangeListener)new HasValue.ValueChangeListener<Boolean>(){

            public void valueChange(HasValue.ValueChangeEvent event) {
                CmsUserCsvExportDialog.this.initDownloadButton();
            }
        });
        this.m_includeTechnicalFields.setVisible(includeTechnicalFields);
        this.m_user = userToExport;
        super.init(ou, window);
        this.m_elementToExportOU.setVisible(type.isUser());
        this.m_elementToExportGroup.setVisible(type.isGroup());
        this.m_elementToExportRole.setVisible(type.isRole());
        this.m_elementExtendedDataUser.setVisible(extendedData && type.isUser());
        this.m_elementExtendedDataRole.setVisible(extendedData && type.isRole());
        this.m_elementToExportOU.setValue(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_EXPORT_OU_1", elementName));
        this.m_elementToExportGroup.setValue(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_EXPORT_GROUP_1", elementName));
        this.m_elementToExportRole.setValue(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_EXPORT_ROLE_1", elementName));
        this.m_elementToExportCount.setValue(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_EXPORT_COUNT_1", userToExport.size()));
    }

    @Override
    Button getCloseButton() {
        return this.m_cancel;
    }

    @Override
    Button getDownloadButton() {
        return this.m_download;
    }

    @Override
    Map<CmsUUID, CmsUser> getUserToExport() {
        HashMap<CmsUUID, CmsUser> userMap = new HashMap<CmsUUID, CmsUser>();
        for (CmsUser user : this.m_user) {
            userMap.put(user.getId(), user);
        }
        return userMap;
    }

    @Override
    boolean isExportWithTechnicalFields() {
        return this.m_includeTechnicalFields.getValue();
    }
}

