/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.HierarchicalContainer;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsRole;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.apps.user.CmsOuTreeType;
import org.opencms.ui.apps.user.I_CmsOuTreeType;
import org.opencms.util.CmsUUID;

public class CmsOuTree
extends Tree {
    private static final Log LOG = CmsLog.getLog(CmsOuTree.class);
    private static CmsOrganizationalUnit m_rootSystemOU;
    private static final String PROP_NAME = "name";
    private static final String PROP_TYPE = "type";
    private static final long serialVersionUID = -3532367333216144806L;
    private static final String PROP_SID = "sid";
    private CmsAccountsApp m_app;
    private CmsObject m_cms;
    private CmsOrganizationalUnit m_rootOu;
    private HierarchicalContainer m_treeContainer;

    public CmsOuTree(CmsObject cms, CmsAccountsApp app, String baseOU) {
        this.m_cms = cms;
        try {
            m_rootSystemOU = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_cms, "");
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        this.m_app = app;
        this.addStyleName("o-full-width-padding");
        this.addStyleName("o-simple-drag");
        this.setWidth("100%");
        this.m_treeContainer = new HierarchicalContainer();
        this.m_treeContainer.addContainerProperty((Object)PROP_NAME, String.class, (Object)"");
        this.m_treeContainer.addContainerProperty((Object)PROP_TYPE, I_CmsOuTreeType.class, null);
        this.m_treeContainer.addContainerProperty((Object)PROP_SID, CmsUUID.class, null);
        this.setContainerDataSource((Container)this.m_treeContainer);
        this.m_rootOu = null;
        try {
            this.m_rootOu = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_cms, baseOU);
            Item item = this.m_treeContainer.addItem((Object)this.m_rootOu);
            item.getItemProperty((Object)PROP_NAME).setValue((Object)this.getIconCaptionHTML(this.m_rootOu, CmsOuTreeType.OU));
            item.getItemProperty((Object)PROP_TYPE).setValue((Object)CmsOuTreeType.OU);
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read OU", (Throwable)e);
        }
        this.setItemCaptionPropertyId(PROP_NAME);
        this.setHtmlContentAllowed(true);
        this.setNullSelectionAllowed(false);
        this.addChildrenForOUNode(this.m_rootOu);
        this.expandItem(this.m_rootOu);
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){
            private static final long serialVersionUID = -6475529853027436127L;

            public void itemClick(ItemClickEvent event) {
                CmsOuTree.this.handleItemClick(event.getItemId());
            }
        });
        this.addExpandListener(new Tree.ExpandListener(){
            private static final long serialVersionUID = 589297480547091120L;

            public void nodeExpand(Tree.ExpandEvent event) {
                CmsOuTree.this.handleExpand(event.getItemId());
            }
        });
    }

    public void openPath(String path, I_CmsOuTreeType type, CmsUUID groupID) {
        if (type == null) {
            return;
        }
        try {
            this.expandItem(this.m_rootOu);
            String[] pathP = path.split("/");
            Object complPath = "";
            for (String subP : pathP) {
                complPath = (String)complPath + subP + "/";
                CmsOrganizationalUnit ou = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_cms, (String)complPath);
                this.addChildrenForOUNode(ou);
                this.expandItem(ou);
            }
            if (type.isGroup() || type.isRole()) {
                String itemId = type.getId() + OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_cms, path).getName();
                this.expandItem(itemId);
                if (groupID == null) {
                    this.setValue(itemId);
                    return;
                }
                this.setValue(groupID);
                return;
            }
            if (type.isUser()) {
                this.setValue(type.getId() + OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_cms, path).getName());
                return;
            }
            this.setValue(OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_cms, path));
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read OU", (Throwable)e);
        }
    }

    protected void handleExpand(Object itemId) {
        I_CmsOuTreeType type = (I_CmsOuTreeType)this.getItem(itemId).getItemProperty((Object)PROP_TYPE).getValue();
        this.loadAndExpand(itemId, type);
    }

    protected void handleItemClick(Object itemId) {
        Item item = this.getItem(itemId);
        I_CmsOuTreeType type = (I_CmsOuTreeType)this.getItem(itemId).getItemProperty((Object)PROP_TYPE).getValue();
        CmsUUID roleOrGroupID = null;
        boolean idInItem = false;
        if (itemId instanceof CmsUUID) {
            roleOrGroupID = (CmsUUID)itemId;
            idInItem = true;
        } else if (item.getItemProperty((Object)PROP_SID).getValue() != null) {
            roleOrGroupID = (CmsUUID)item.getItemProperty((Object)PROP_SID).getValue();
            idInItem = true;
        }
        if (type.equals(CmsOuTreeType.ROLE)) {
            String ou = this.getOuFromItem(itemId, CmsOuTreeType.ROLE);
            boolean isRoot = ou.isEmpty();
            if (isRoot) {
                ou = "/";
            }
            if (!((String)itemId).endsWith(ou)) {
                if (isRoot) {
                    if (((String)itemId).length() > ou.length() + 1) {
                        roleOrGroupID = new CmsUUID(((String)itemId).substring(ou.length() + 1));
                    }
                } else {
                    roleOrGroupID = new CmsUUID(((String)itemId).substring(ou.length() + 2));
                }
            }
        }
        this.m_app.update(this.getOuFromItem(itemId, type), type, roleOrGroupID, "");
        if (this.isExpanded(itemId) || idInItem) {
            return;
        }
        this.loadAndExpand(itemId, type);
        this.setValue(itemId);
    }

    void updateOU(CmsOrganizationalUnit item) {
        if (this.m_treeContainer.getChildren((Object)item) == null) {
            return;
        }
        for (Object it : this.m_treeContainer.getChildren((Object)item)) {
            I_CmsOuTreeType type;
            if (!this.isExpanded(it) || !(type = (I_CmsOuTreeType)this.getItem(it).getItemProperty((Object)PROP_TYPE).getValue()).isGroup()) continue;
            this.addChildrenForGroupsNode(type, type.getId() + item.getName());
        }
    }

    private void addChildrenForGroupsNode(I_CmsOuTreeType type, String ouItem) {
        try {
            List<CmsGroup> groups = this.m_app.readGroupsForOu(this.m_cms, ouItem.substring(1), type, false);
            ArrayList itemsToRemove = new ArrayList();
            Collection childCol = this.m_treeContainer.getChildren((Object)ouItem);
            if (childCol != null) {
                itemsToRemove.addAll(childCol);
            }
            for (CmsGroup group : groups) {
                Pair key = Pair.of((Object)type.getId(), (Object)group.getId());
                Item groupItem = this.m_treeContainer.addItem((Object)key);
                if (groupItem == null) {
                    groupItem = this.getItem(key);
                    itemsToRemove.remove(key);
                }
                groupItem.getItemProperty((Object)PROP_SID).setValue((Object)group.getId());
                groupItem.getItemProperty((Object)PROP_NAME).setValue((Object)this.getIconCaptionHTML(group, CmsOuTreeType.GROUP));
                groupItem.getItemProperty((Object)PROP_TYPE).setValue((Object)type);
                this.setChildrenAllowed(key, false);
                this.m_treeContainer.setParent((Object)key, (Object)ouItem);
            }
            for (CmsGroup item : itemsToRemove) {
                this.m_treeContainer.removeItem((Object)item);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Can not read group", (Throwable)e);
        }
    }

    private void addChildrenForOUNode(CmsOrganizationalUnit item) {
        ArrayList itemsToRemove = new ArrayList();
        Collection childCol = this.m_treeContainer.getChildren((Object)item);
        if (childCol != null) {
            itemsToRemove.addAll(childCol);
        }
        try {
            if (this.m_app.isOUManagable(item.getName())) {
                List<I_CmsOuTreeType> types = this.m_app.getTreeTypeProvider().getTreeTypes();
                for (I_CmsOuTreeType type : types) {
                    if (!type.isValidForOu(this.m_cms, item.getName()) || type.isOrgUnit()) continue;
                    String itemId = type.getId() + item.getName();
                    Item newItem = this.m_treeContainer.addItem((Object)itemId);
                    itemsToRemove.remove(itemId);
                    if (newItem == null) continue;
                    newItem.getItemProperty((Object)PROP_NAME).setValue((Object)this.getIconCaptionHTML(itemId, type));
                    newItem.getItemProperty((Object)PROP_TYPE).setValue((Object)type);
                    this.m_treeContainer.setParent((Object)itemId, (Object)item);
                    this.setChildrenAllowed(itemId, type.isExpandable());
                }
            }
            List<CmsOrganizationalUnit> ous = OpenCms.getOrgUnitManager().getOrganizationalUnits(this.m_cms, item.getName(), false);
            ArrayList<CmsOrganizationalUnit> webOus = new ArrayList<CmsOrganizationalUnit>();
            for (CmsOrganizationalUnit ou : ous) {
                if (!this.m_app.isParentOfManagableOU(ou.getName())) continue;
                itemsToRemove.remove(ou);
                if (ou.hasFlagWebuser()) {
                    webOus.add(ou);
                    continue;
                }
                this.addOuToTree(ou, item);
            }
            for (CmsOrganizationalUnit ou : webOus) {
                if (!this.m_app.isParentOfManagableOU(ou.getName())) continue;
                itemsToRemove.remove(ou);
                this.addOuToTree(ou, item);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Can't read ou", (Throwable)e);
        }
        for (Object it : itemsToRemove) {
            this.m_treeContainer.removeItemRecursively(it);
        }
    }

    private void addChildrenForRolesNode(String ouItem) {
        try {
            List<CmsRole> roles = OpenCms.getRoleManager().getRoles(this.m_cms, ouItem.substring(1), false);
            CmsRole.applySystemRoleOrder(roles);
            for (CmsRole role : roles) {
                String roleId = ouItem + "/" + String.valueOf(role.getId());
                Item roleItem = this.m_treeContainer.addItem((Object)roleId);
                if (roleItem == null) {
                    roleItem = this.getItem(roleId);
                }
                roleItem.getItemProperty((Object)PROP_NAME).setValue((Object)this.getIconCaptionHTML(role, CmsOuTreeType.ROLE));
                roleItem.getItemProperty((Object)PROP_TYPE).setValue((Object)CmsOuTreeType.ROLE);
                this.setChildrenAllowed(roleId, false);
                this.m_treeContainer.setParent((Object)roleId, (Object)ouItem);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Can not read group", (Throwable)e);
        }
    }

    private void addOuToTree(CmsOrganizationalUnit ou, CmsOrganizationalUnit parent_ou) {
        Item containerItem = this.m_treeContainer.addItem((Object)ou);
        if (containerItem == null) {
            containerItem = this.getItem(ou);
        }
        containerItem.getItemProperty((Object)PROP_NAME).setValue((Object)this.getIconCaptionHTML(ou, CmsOuTreeType.OU));
        containerItem.getItemProperty((Object)PROP_TYPE).setValue((Object)CmsOuTreeType.OU);
        this.m_treeContainer.setParent((Object)ou, (Object)parent_ou);
    }

    private String getIconCaptionHTML(Object item, I_CmsOuTreeType type) {
        CmsCssIcon icon = type.getIcon();
        String caption = type.getName();
        if (item instanceof CmsOrganizationalUnit) {
            CmsOrganizationalUnit ou = (CmsOrganizationalUnit)item;
            if (ou.hasFlagWebuser()) {
                icon = new CmsCssIcon("oc-icon-24-webuser");
            }
            String string = caption = ou.equals(m_rootSystemOU) ? ou.getDisplayName(A_CmsUI.get().getLocale()) : ou.getName();
        }
        if (item instanceof CmsGroup) {
            caption = ((CmsGroup)item).getName();
            icon = this.m_app.getGroupIcon((CmsGroup)item);
        }
        if (item instanceof CmsRole) {
            caption = ((CmsRole)item).getName(A_CmsUI.get().getLocale());
        }
        if (icon != null) {
            return "<span class=\"o-resource-icon\">" + icon.getHtml() + "</span><span class=\"o-tree-caption\">" + caption + "</span>";
        }
        return "";
    }

    private String getOuFromItem(Object itemId, I_CmsOuTreeType type) {
        if (type.equals(CmsOuTreeType.OU)) {
            return ((CmsOrganizationalUnit)itemId).getName();
        }
        Object o = this.m_treeContainer.getParent(itemId);
        while (!(o instanceof CmsOrganizationalUnit)) {
            o = this.m_treeContainer.getParent(o);
        }
        return ((CmsOrganizationalUnit)o).getName();
    }

    private void loadAndExpand(Object itemId, I_CmsOuTreeType type) {
        if (type.isOrgUnit()) {
            this.addChildrenForOUNode((CmsOrganizationalUnit)itemId);
        }
        if (type.isGroup()) {
            this.addChildrenForGroupsNode(type, (String)itemId);
        }
        if (type.isRole()) {
            this.addChildrenForRolesNode((String)itemId);
        }
        this.expandItem(itemId);
    }
}

